/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.server;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.services.LanguageServer;

public interface StreamConnectionProvider {
    public void start() throws IOException;

    public InputStream getInputStream();

    public OutputStream getOutputStream();

    public @Nullable InputStream getErrorStream();

    default public InputStream forwardCopyTo(InputStream input, final OutputStream output) {
        if (input == null) {
            return null;
        }
        if (output == null) {
            return input;
        }
        FilterInputStream filterInput = new FilterInputStream(input){

            @Override
            public int read() throws IOException {
                int res = super.read();
                System.err.print((char)res);
                return res;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int bytes = super.read(b, off, len);
                byte[] payload = new byte[bytes];
                System.arraycopy(b, off, payload, 0, bytes);
                output.write(payload, 0, payload.length);
                return bytes;
            }

            @Override
            public int read(byte[] b) throws IOException {
                int bytes = super.read(b);
                byte[] payload = new byte[bytes];
                System.arraycopy(b, 0, payload, 0, bytes);
                output.write(payload, 0, payload.length);
                return bytes;
            }
        };
        return filterInput;
    }

    default public Object getInitializationOptions(@Nullable URI rootUri) {
        return null;
    }

    default public Object getExperimentalFeaturesPOJO() {
        return null;
    }

    default public String getTrace(@Nullable URI rootUri) {
        return "off";
    }

    public void stop();

    default public void handleMessage(Message message, LanguageServer languageServer, @Nullable URI rootURI) {
    }
}

