/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.IMavenDiscovery;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.archetype.ArchetypePlugin;
import org.eclipse.m2e.core.ui.internal.console.MavenConsoleImpl;
import org.eclipse.m2e.core.ui.internal.project.MavenUpdateConfigurationChangeListener;
import org.eclipse.m2e.core.ui.internal.search.util.SearchEngine;
import org.eclipse.m2e.core.ui.internal.wizards.IMavenDiscoveryUI;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class M2EUIPluginActivator
extends AbstractUIPlugin {
    public static final String PREFS_ARCHETYPES = "archetypesInfo.xml";
    public static final String PLUGIN_ID = "org.eclipse.m2e.core.ui";
    private static M2EUIPluginActivator instance;
    private ServiceTracker<ArchetypePlugin, ArchetypePlugin> archetypeManager;
    private ScopedPreferenceStore preferenceStore;
    private MavenConsoleImpl console;
    private MavenUpdateConfigurationChangeListener mavenUpdateConfigurationChangeListener;
    public static final String PROP_SHOW_EXPERIMENTAL_FEATURES = "m2e.showExperimentalFeatures";
    private BundleContext context;

    public M2EUIPluginActivator() {
        instance = this;
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.m2e.core");
        }
        return this.preferenceStore;
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        super.start(context);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.mavenUpdateConfigurationChangeListener = new MavenUpdateConfigurationChangeListener();
        workspace.addResourceChangeListener((IResourceChangeListener)this.mavenUpdateConfigurationChangeListener, 1);
        MavenPluginActivator mavenPlugin = MavenPluginActivator.getDefault();
        IPath nexusCache = Platform.getStateLocation((Bundle)mavenPlugin.getBundle()).append("nexus");
        FileUtils.deleteDirectory((File)nexusCache.toFile());
        File localRepo = mavenPlugin.getRepositoryRegistry().getLocalRepository().getBasedir();
        Path m2eCache = localRepo.toPath().resolve(".cache/m2e/");
        if (Files.isDirectory(m2eCache, new LinkOption[0])) {
            M2EUIPluginActivator.deleteLegacyCacheDirectory(m2eCache);
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.mavenUpdateConfigurationChangeListener);
        this.mavenUpdateConfigurationChangeListener = null;
    }

    public static M2EUIPluginActivator getDefault() {
        return instance;
    }

    public static Image getImage(String path) {
        ImageRegistry registry = M2EUIPluginActivator.getDefault().getImageRegistry();
        Image image = registry.get(path);
        if (image == null) {
            registry.put(path, (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.m2e.core", (String)path).get());
            image = registry.get(path);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.m2e.core", (String)path).get();
    }

    public synchronized MavenConsoleImpl getMavenConsole() {
        if (this.console == null) {
            this.console = new MavenConsoleImpl(MavenImages.M2);
        }
        return this.console;
    }

    public boolean hasMavenConsoleImpl() {
        return this.console != null;
    }

    public SearchEngine getSearchEngine(IProject project) {
        return null;
    }

    public synchronized IMavenDiscovery getMavenDiscovery() {
        BundleContext context = this.getBundle().getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(IMavenDiscovery.class);
        if (serviceReference != null) {
            return (IMavenDiscovery)context.getService(serviceReference);
        }
        return null;
    }

    public IMavenDiscoveryUI getImportWizardPageFactory() {
        BundleContext context = this.getBundle().getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(IMavenDiscoveryUI.class);
        if (serviceReference != null) {
            return (IMavenDiscoveryUI)context.getService(serviceReference);
        }
        return null;
    }

    public static boolean showExperimentalFeatures() {
        return Boolean.parseBoolean(System.getProperty(PROP_SHOW_EXPERIMENTAL_FEATURES));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchetypePlugin getArchetypePlugin() {
        M2EUIPluginActivator m2EUIPluginActivator = this;
        synchronized (m2EUIPluginActivator) {
            if (this.archetypeManager == null) {
                this.archetypeManager = new ServiceTracker(this.context, ArchetypePlugin.class, null);
                this.archetypeManager.open();
            }
        }
        return (ArchetypePlugin)this.archetypeManager.getService();
    }

    private static void deleteLegacyCacheDirectory(final Path m2eCache) {
        final Path resolve = m2eCache.resolve("DELETE_ME.txt");
        if (Files.isRegularFile(resolve, new LinkOption[0]) || Boolean.parseBoolean(System.getProperty("m2e.keep.legacy.cache"))) {
            return;
        }
        new UIJob("Delete legacy M2E cache"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                final boolean[] askAgain = new boolean[]{true};
                MessageDialog dialog = new MessageDialog(this.getDisplay().getActiveShell(), "Delete obsolete M2E cache?", null, "A cache directory used by previous M2E versions was detected:\n\n" + m2eCache + "\n\n" + "It's no longer used by newer M2E versions and, unless older Eclipse installations need it, can be safely deleted.", 3, 0, new String[]{"Keep Cache", "Delete Cache"}){

                    protected Control createCustomArea(Composite parent) {
                        Button checkbox = new Button(parent, 32);
                        checkbox.setText("Don't ask me again?");
                        checkbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                            boolean bl = blArray[0] = !checkbox.getSelection();
                        }));
                        return super.createCustomArea(parent);
                    }
                };
                int selection = dialog.open();
                if (selection == 1) {
                    try {
                        FileUtils.deleteDirectory((File)m2eCache.toFile());
                    }
                    catch (IOException e) {
                        return Status.error((String)"Failed to delete legacy M2E cache", (Throwable)e);
                    }
                }
                if (!askAgain[0]) {
                    try {
                        Files.writeString(resolve, (CharSequence)"This cache directory was created by a previous Maven2Eclipse 1.x version and is no longer used since M2E 2.0.\nUnless older Eclipse installations need it, it can be deleted safely.\"\n", new OpenOption[0]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule(10000L);
    }
}

