/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.mojo;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.maven.DefaultMaven;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.UrlModelSource;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.embedder.MavenExecutionContext;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;
import org.eclipse.m2e.editor.internal.Messages;
import org.eclipse.m2e.editor.mojo.DefaultMojoParameterMetadata;
import org.eclipse.m2e.editor.mojo.IMojoParameterMetadata;
import org.eclipse.m2e.editor.mojo.IMojoParameterMetadataProvider;
import org.eclipse.m2e.editor.mojo.MojoParameter;
import org.eclipse.m2e.editor.mojo.PlexusConfigHelper;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MojoParameterMetadataProvider
implements IMojoParameterMetadataProvider {
    private static final Logger log = LoggerFactory.getLogger(MojoParameterMetadataProvider.class);
    private static final Cache<String, MojoParameter> cache = CacheBuilder.newBuilder().maximumSize(100L).softValues().build();
    protected final MavenImpl maven = (MavenImpl)MavenPlugin.getMaven();
    public static final String EXTENSION_MOJO_PARAMETER_METADATA = "org.eclipse.m2e.editor.xml.mojoParameterMetadata";
    private static final Map<String, MojoParameter> PREDEF = Map.of("org.eclipse.m2e:lifecycle-mapping:1.0.0", new MojoParameter("", "", Collections.singletonList(new MojoParameter("lifecycleMappingMetadata", "LifecycleMappingMetadata", Collections.singletonList(new MojoParameter("pluginExecutions", "List<PluginExecution>", Collections.singletonList(new MojoParameter("pluginExecution", "PluginExecution", Arrays.asList(new MojoParameter("pluginExecutionFilter", "PluginExecutionFilter", Arrays.asList(new MojoParameter("groupId", "String"), new MojoParameter("artifactId", "String"), new MojoParameter("versionRange", "String"), new MojoParameter("goals", "List<String>", Collections.singletonList(new MojoParameter("goal", "String").multiple())))), new MojoParameter("action", "Action", Arrays.asList(new MojoParameter("ignore", "void"), new MojoParameter("execute", "Execute", Arrays.asList(new MojoParameter("runOnIncremental", "boolean"), new MojoParameter("runOnConfiguration", "boolean"))))))).multiple())))))));

    @Override
    public MojoParameter getClassConfiguration(ArtifactKey pluginKey, String className) throws CoreException {
        try {
            String key = String.valueOf(pluginKey.toPortableString()) + "/" + className;
            return (MojoParameter)cache.get((Object)key, () -> (MojoParameter)this.execute(pluginKey, (context, monitor) -> {
                PluginDescriptor pd = this.getPluginDescriptor(pluginKey, context, monitor);
                List<MojoParameter> parameters = null;
                if (pd != null) {
                    Class clazz;
                    try {
                        clazz = pd.getClassRealm().loadClass(className);
                    }
                    catch (ClassNotFoundException ex) {
                        return null;
                    }
                    parameters = new PlexusConfigHelper().loadParameters(pd.getClassRealm(), clazz, monitor);
                }
                return new MojoParameter("", className, parameters);
            }));
        }
        catch (ExecutionException e) {
            Throwable throwable = t = e.getCause();
            if (throwable instanceof CoreException var5_7) {
                throw coreEx;
            }
            if (t instanceof RuntimeException var7_9) {
                throw runtimeEx;
            }
            throw new CoreException(Status.error((String)e.getMessage(), (Throwable)e));
        }
    }

    @Override
    public MojoParameter getMojoConfiguration(ArtifactKey pluginKey, Collection<String> mojos) throws CoreException {
        ArrayList<MojoParameter> params = new ArrayList<MojoParameter>();
        HashSet<String> collected = new HashSet<String>();
        for (String mojo : mojos) {
            MojoParameter md = this.getMojoConfiguration(pluginKey, mojo);
            for (MojoParameter p : md.getNestedParameters()) {
                if (!collected.add(p.getName())) continue;
                params.add(p);
            }
        }
        return new MojoParameter("", "", params);
    }

    @Override
    public MojoParameter getMojoConfiguration(ArtifactKey pluginKey) throws CoreException {
        return this.getMojoConfiguration(pluginKey, "*");
    }

    @Override
    public MojoParameter getMojoConfiguration(ArtifactKey pluginKey, String mojo) throws CoreException {
        MojoParameter predefParameters = this.getPredefined(pluginKey);
        if (predefParameters != null) {
            return predefParameters;
        }
        String key = String.valueOf(pluginKey.toPortableString()) + "/mojo/" + (mojo == null ? "*" : mojo);
        try {
            return (MojoParameter)cache.get((Object)key, () -> (MojoParameter)this.execute(pluginKey, (context, monitor) -> {
                PluginDescriptor pd = this.getPluginDescriptor(pluginKey, context, monitor);
                List<MojoParameter> parameters = null;
                if (pd != null) {
                    parameters = this.loadMojoParameters(pd, mojo, monitor);
                }
                return new MojoParameter("", mojo, parameters);
            }));
        }
        catch (ExecutionException e) {
            Throwable throwable = t = e.getCause();
            if (throwable instanceof CoreException var7_8) {
                throw coreEx;
            }
            if (t instanceof RuntimeException var9_10) {
                throw runtimeEx;
            }
            throw new CoreException(Status.error((String)e.getMessage(), (Throwable)e));
        }
    }

    List<MojoParameter> loadMojoParameters(PluginDescriptor desc, String goal, IProgressMonitor monitor) throws CoreException {
        PlexusConfigHelper helper = new PlexusConfigHelper();
        if ("*".equals(goal)) {
            ArrayList<MojoParameter> parameters = new ArrayList<MojoParameter>();
            HashSet<String> collected = new HashSet<String>();
            for (MojoDescriptor mojo : desc.getMojos()) {
                for (MojoParameter p : this.loadMojoParameters(desc, mojo, helper, monitor)) {
                    if (!collected.add(p.getName())) continue;
                    parameters.add(p);
                }
            }
            return parameters;
        }
        return this.loadMojoParameters(desc, desc.getMojo(goal), helper, monitor);
    }

    private MojoParameter getPredefined(ArtifactKey pluginKey) {
        return PREDEF.get(String.valueOf(pluginKey.groupId()) + ":" + pluginKey.artifactId() + ":" + pluginKey.version());
    }

    <T> T execute(ArtifactKey pluginKey, ICallable<T> callable) throws CoreException {
        Object[] result = new Object[1];
        CoreException[] innerException = new CoreException[1];
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, monitor -> {
                monitor.beginTask(Messages.PomTemplateContext_resolvingPlugin, 100);
                try {
                    MavenExecutionContext context = this.maven.createExecutionContext();
                    context.getExecutionRequest().setCacheTransferError(false);
                    Object res = context.execute((context1, monitor1) -> {
                        MavenProject mp = this.getProject(context1);
                        if (mp != null) {
                            return context1.execute(mp, callable, monitor1);
                        }
                        return null;
                    }, monitor);
                    if (monitor.isCanceled()) {
                        return;
                    }
                    objectArray[0] = res;
                }
                catch (CoreException ex) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    coreExceptionArray[0] = ex;
                }
            });
        }
        catch (InterruptedException | InvocationTargetException ex) {
            throw new CoreException(Status.error((String)ex.getMessage(), (Throwable)ex));
        }
        if (innerException[0] != null) {
            throw innerException[0];
        }
        Object res = result[0];
        return (T)res;
    }

    MavenProject getProject(IMavenExecutionContext context) {
        UrlModelSource modelSource = new UrlModelSource(DefaultMaven.class.getResource("project/standalone.xml"));
        try {
            return this.lookup(ProjectBuilder.class).build((ModelSource)modelSource, context.newProjectBuildingRequest()).getProject();
        }
        catch (ProjectBuildingException | CoreException ex) {
            log.warn(ex.getMessage());
            return null;
        }
    }

    PluginDescriptor getPluginDescriptor(ArtifactKey pluginKey, IMavenExecutionContext context, IProgressMonitor monitor) {
        Plugin plugin = new Plugin();
        plugin.setGroupId(pluginKey.groupId());
        plugin.setArtifactId(pluginKey.artifactId());
        plugin.setVersion(pluginKey.version());
        List remoteRepos = context.getSession().getCurrentProject().getRemotePluginRepositories();
        try {
            PluginDescriptor desc = this.lookup(MavenPluginManager.class).getPluginDescriptor(plugin, remoteRepos, context.getRepositorySession());
            this.lookup(BuildPluginManager.class).getPluginRealm(context.getSession(), desc);
            return desc;
        }
        catch (Exception ex) {
            log.warn(ex.getMessage());
            return null;
        }
    }

    <T> T lookup(Class<T> clazz) throws CoreException {
        return (T)this.maven.lookup(clazz);
    }

    List<MojoParameter> loadMojoParameters(PluginDescriptor desc, MojoDescriptor mojo, PlexusConfigHelper helper, IProgressMonitor monitor) throws CoreException {
        IMojoParameterMetadata metadata = null;
        String mojoConfigurator = mojo.getComponentConfigurator();
        if (mojoConfigurator != null) {
            metadata = MojoParameterMetadataProvider.readMojoParameterMetadata(mojoConfigurator);
        }
        if (metadata == null) {
            metadata = new DefaultMojoParameterMetadata();
        }
        return metadata.loadMojoParameters(desc, mojo, helper, monitor);
    }

    private static IMojoParameterMetadata readMojoParameterMetadata(String mojoConfigurator) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint mappingsExtensionPoint = registry.getExtensionPoint(EXTENSION_MOJO_PARAMETER_METADATA);
        if (mappingsExtensionPoint != null) {
            IExtension[] mappingsExtensions;
            IExtension[] iExtensionArray = mappingsExtensions = mappingsExtensionPoint.getExtensions();
            int n = mappingsExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if ("mojoParameterMetadata".equals(element.getName()) && mojoConfigurator.equals(element.getAttribute("configurator"))) {
                        try {
                            return (IMojoParameterMetadata)element.createExecutableExtension("class");
                        }
                        catch (CoreException ex) {
                            log.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }
}

