/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import com.ibm.icu.text.NumberFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.ArrayIntBig;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.internal.MATPlugin;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Bytes;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.ClassHistogramRecord;
import org.eclipse.mat.snapshot.ClassLoaderHistogramRecord;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.IMultiplePathsFromGCRootsComputer;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.MultiplePathsFromGCRootsRecord;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

@CommandName(value="find_leaks")
@Category(value="__hidden__")
@Icon(value="/META-INF/icons/leak.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/runningleaksuspectsreport.html")
public class FindLeaksQuery
implements IQuery {
    private static final Set<String> REFERENCE_FIELD_SET = new HashSet<String>(Arrays.asList("referent"));
    private static final Set<String> UNFINALIZED_REFERENCE_FIELD_SET = new HashSet<String>(Arrays.asList("<" + GCRootInfo.getTypeAsString(1024) + ">"));
    private static final int MAX_DEPTH = 1000;
    @Argument
    public ISnapshot snapshot;
    @Argument(isMandatory=false)
    public int threshold_percent = 20;
    @Argument(isMandatory=false)
    public int max_paths = 10000;
    public double big_drop_ratio = 0.7;

    public IResult execute(IProgressListener listener) throws Exception {
        long totalHeap = this.snapshot.getSnapshotInfo().getUsedHeapSize();
        int[] topDominators = this.snapshot.getImmediateDominatedIds(-1);
        long threshold = (long)this.threshold_percent * totalHeap / 100L;
        listener.subTask(Messages.FindLeaksQuery_SearchingSingleObjects);
        ArrayInt suspiciousObjects = new ArrayInt();
        HashSet<String> suspectNames = new HashSet<String>();
        int i = 0;
        while (i < topDominators.length && this.snapshot.getRetainedHeapSize(topDominators[i]) > threshold) {
            suspiciousObjects.add(topDominators[i]);
            suspectNames.add(this.snapshot.getClassOf(topDominators[i]).getName());
            ++i;
        }
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        listener.subTask(Messages.FindLeaksQuery_SearchingGroupsOfObjects);
        Histogram histogram = this.groupByClasses(topDominators, listener);
        ArrayList<ClassHistogramRecord> suspiciousClasses = new ArrayList<ClassHistogramRecord>();
        ClassHistogramRecord[] classRecords = histogram.getClassHistogramRecords().toArray(new ClassHistogramRecord[0]);
        Arrays.sort(classRecords, Histogram.reverseComparator(Histogram.COMPARATOR_FOR_RETAINEDHEAPSIZE));
        int k = 0;
        while (k < classRecords.length && classRecords[k].getRetainedHeapSize() > threshold) {
            if (!suspectNames.contains(classRecords[k].getLabel())) {
                suspiciousClasses.add(classRecords[k]);
            }
            ++k;
        }
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        return this.buildResult(suspiciousObjects, suspiciousClasses, totalHeap, listener);
    }

    private Histogram groupByClasses(int[] dominated, IProgressListener listener) throws SnapshotException {
        Histogram histogram = this.snapshot.getHistogram(dominated, listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        Collection<ClassHistogramRecord> records = histogram.getClassHistogramRecords();
        ClassHistogramRecord[] arr = new ClassHistogramRecord[records.size()];
        int i = 0;
        for (ClassHistogramRecord record : records) {
            record.setRetainedHeapSize(this.sumRetainedSize(record.getObjectIds(), this.snapshot));
            arr[i++] = record;
            if (i % 10 != 0 || !listener.isCanceled()) continue;
            throw new IProgressListener.OperationCanceledException();
        }
        Collection<ClassLoaderHistogramRecord> loaderRecords = histogram.getClassLoaderHistogramRecords();
        ClassLoaderHistogramRecord[] loaderArr = new ClassLoaderHistogramRecord[loaderRecords.size()];
        i = 0;
        for (ClassLoaderHistogramRecord record : loaderRecords) {
            long retainedSize = 0L;
            for (ClassHistogramRecord classRecord : record.getClassHistogramRecords()) {
                retainedSize += classRecord.getRetainedHeapSize();
            }
            record.setRetainedHeapSize(retainedSize);
            loaderArr[i++] = record;
        }
        return histogram;
    }

    private long sumRetainedSize(int[] objectIds, ISnapshot snapshot) throws SnapshotException {
        long sum = 0L;
        int[] nArray = objectIds;
        int n = objectIds.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            sum += snapshot.getRetainedHeapSize(id);
            ++n2;
        }
        return sum;
    }

    private AccumulationPoint findAccumulationPoint(int bigObjectId) throws SnapshotException {
        int dominator = bigObjectId;
        double dominatorRetainedSize = this.snapshot.getRetainedHeapSize(dominator);
        int[] dominated = this.snapshot.getImmediateDominatedIds(dominator);
        int depth = 0;
        while (dominated != null && dominated.length != 0 && depth < 1000) {
            double dominatedRetainedSize = this.snapshot.getRetainedHeapSize(dominated[0]);
            if (dominatedRetainedSize / dominatorRetainedSize < this.big_drop_ratio) {
                return new AccumulationPoint(this.snapshot.getObject(dominator));
            }
            dominatorRetainedSize = dominatedRetainedSize;
            dominator = dominated[0];
            dominated = this.snapshot.getImmediateDominatedIds(dominator);
            ++depth;
        }
        if (dominated == null || dominated.length == 0) {
            return new AccumulationPoint(this.snapshot.getObject(dominator));
        }
        return null;
    }

    private SuspectRecord buildSuspectRecordGroupOfObjects(ClassHistogramRecord record, IProgressListener listener) throws SnapshotException {
        int[] objectIds = this.getRandomIds(record.getObjectIds());
        IObject suspectClass = this.snapshot.getObject(record.getClassId());
        HashMap<IClass, Set<String>> excludeMap = new HashMap<IClass, Set<String>>();
        Collection<IClass> classes = this.snapshot.getClassesByName("java.lang.ref.WeakReference", true);
        if (classes != null) {
            for (IClass clazz : classes) {
                excludeMap.put(clazz, REFERENCE_FIELD_SET);
            }
        }
        if ((classes = this.snapshot.getClassesByName("java.lang.Runtime", false)) != null) {
            for (IClass clazz : classes) {
                excludeMap.put(clazz, UNFINALIZED_REFERENCE_FIELD_SET);
            }
        }
        IMultiplePathsFromGCRootsComputer comp = this.snapshot.getMultiplePathsFromGCRoots(objectIds, excludeMap);
        MultiplePathsFromGCRootsRecord[] records = comp.getPathsByGCRoot(listener);
        ArrayIntBig commonPath = new ArrayIntBig();
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        if (records.length > 0) {
            int numPaths = comp.getAllPaths(listener).length;
            int diff = objectIds.length - numPaths;
            if (diff > 0) {
                listener.sendUserMessage(IProgressListener.Severity.INFO, MessageUtil.format((String)Messages.FindLeaksQuery_PathNotFound, (Object[])new Object[]{diff, objectIds.length}), null);
            }
            this.setRetainedSizesForMPaths(records, this.snapshot);
            Arrays.sort(records, MultiplePathsFromGCRootsRecord.getComparatorByNumberOfReferencedObjects());
            MultiplePathsFromGCRootsRecord parentRecord = records[0];
            int threshold = (int)(0.8 * (double)objectIds.length);
            while (parentRecord.getCount() > threshold) {
                commonPath.add(parentRecord.getObjectId());
                MultiplePathsFromGCRootsRecord[] children = parentRecord.nextLevel();
                if (children == null || children.length == 0) {
                    AccumulationPoint accPoint = new AccumulationPoint(this.snapshot.getObject(parentRecord.getObjectId()));
                    SuspectRecordGroupOfObjects result = new SuspectRecordGroupOfObjects(suspectClass, record.getObjectIds(), record.getRetainedHeapSize(), accPoint, commonPath.toArray(), comp);
                    return result;
                }
                this.setRetainedSizesForMPaths(children, this.snapshot);
                Arrays.sort(children, MultiplePathsFromGCRootsRecord.getComparatorByNumberOfReferencedObjects());
                if ((double)children[0].getReferencedRetainedSize() / (double)parentRecord.getReferencedRetainedSize() < this.big_drop_ratio) {
                    AccumulationPoint accPoint = new AccumulationPoint(this.snapshot.getObject(parentRecord.getObjectId()));
                    SuspectRecordGroupOfObjects result = new SuspectRecordGroupOfObjects(suspectClass, record.getObjectIds(), record.getRetainedHeapSize(), accPoint, commonPath.toArray(), comp);
                    return result;
                }
                parentRecord = children[0];
            }
        }
        return new SuspectRecordGroupOfObjects(suspectClass, record.getObjectIds(), record.getRetainedHeapSize(), null, commonPath.toArray(), comp);
    }

    private void setRetainedSizesForMPaths(MultiplePathsFromGCRootsRecord[] records, ISnapshot snapshot) throws SnapshotException {
        MultiplePathsFromGCRootsRecord[] multiplePathsFromGCRootsRecordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            MultiplePathsFromGCRootsRecord rec = multiplePathsFromGCRootsRecordArray[n2];
            int[] referencedObjects = rec.getReferencedObjects();
            long retained = 0L;
            int[] nArray = referencedObjects;
            int n3 = referencedObjects.length;
            int n4 = 0;
            while (n4 < n3) {
                int objectId = nArray[n4];
                retained += snapshot.getRetainedHeapSize(objectId);
                ++n4;
            }
            rec.setReferencedRetainedSize(retained);
            ++n2;
        }
    }

    private IResult buildResult(ArrayInt suspiciousObjects, ArrayList<ClassHistogramRecord> suspiciousClasses, long totalHeap, IProgressListener listener) throws SnapshotException {
        int[] suspectObjIds;
        SuspectRecord[] allSuspects = new SuspectRecord[suspiciousObjects.size() + suspiciousClasses.size()];
        int j = 0;
        int[] nArray = suspectObjIds = suspiciousObjects.toArray();
        int n = suspectObjIds.length;
        int n2 = 0;
        while (n2 < n) {
            int objectId = nArray[n2];
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            IObject suspectObject = this.snapshot.getObject(objectId);
            AccumulationPoint accPoint = this.findAccumulationPoint(objectId);
            SuspectRecord r = new SuspectRecord(suspectObject, suspectObject.getRetainedHeapSize(), accPoint);
            allSuspects[j++] = r;
            ++n2;
        }
        for (ClassHistogramRecord record : suspiciousClasses) {
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            SuspectRecord r = this.buildSuspectRecordGroupOfObjects(record, listener);
            allSuspects[j++] = r;
        }
        return new SuspectsResultTable(allSuspects, totalHeap);
    }

    private int[] getRandomIds(int[] objectIds) {
        if (objectIds.length <= this.max_paths) {
            return objectIds;
        }
        MATPlugin.log((IStatus)new Status(1, "org.eclipse.mat.api", MessageUtil.format((String)Messages.FindLeaksQuery_TooManySuspects, (Object[])new Object[]{objectIds.length, this.max_paths})));
        Random random = new Random();
        int length = objectIds.length;
        BitField visited = new BitField(length);
        int[] result = new int[this.max_paths];
        int i = 0;
        while (i < this.max_paths) {
            int index = random.nextInt(length);
            while (visited.get(index)) {
                index = random.nextInt(length);
            }
            visited.set(index);
            result[i] = objectIds[index];
            ++i;
        }
        return result;
    }

    public static class AccumulationPoint {
        IObject object;

        public AccumulationPoint(IObject object) {
            this.object = object;
        }

        public IObject getObject() {
            return this.object;
        }

        public long getRetainedHeapSize() {
            return this.getObject().getRetainedHeapSize();
        }
    }

    public static class AccumulationPointOfGroupOfObject
    extends AccumulationPoint {
        int[] commonPath;
        IMultiplePathsFromGCRootsComputer pathsComputer;

        public AccumulationPointOfGroupOfObject(IObject object, int[] commonPath, IMultiplePathsFromGCRootsComputer pathsComputer) {
            super(object);
            this.commonPath = (int[])commonPath.clone();
            this.pathsComputer = pathsComputer;
        }

        public int[] getCommonPath() {
            return (int[])this.commonPath.clone();
        }

        public IMultiplePathsFromGCRootsComputer getPathsComputer() {
            return this.pathsComputer;
        }
    }

    public static class SuspectRecord {
        IObject suspect;
        Bytes suspectRetained;
        AccumulationPoint accumulationPoint;

        SuspectRecord(IObject suspect, long suspectRetained, AccumulationPoint accumulationPoint) {
            this.suspect = suspect;
            this.suspectRetained = new Bytes(suspectRetained);
            this.accumulationPoint = accumulationPoint;
        }

        public IObject getSuspect() {
            return this.suspect;
        }

        public long getSuspectRetained() {
            return this.suspectRetained.getValue();
        }

        public AccumulationPoint getAccumulationPoint() {
            return this.accumulationPoint;
        }
    }

    public static class SuspectRecordGroupOfObjects
    extends SuspectRecord {
        int[] commonPath;
        IMultiplePathsFromGCRootsComputer pathsComputer;
        int[] suspectInstances;

        SuspectRecordGroupOfObjects(IObject suspect, int[] suspectInstances, long suspectRetained, AccumulationPoint accumulationPoint, int[] commonPath, IMultiplePathsFromGCRootsComputer pathsComputer) {
            super(suspect, suspectRetained, accumulationPoint);
            this.suspectInstances = suspectInstances;
            this.commonPath = commonPath;
            this.pathsComputer = pathsComputer;
        }

        public int[] getCommonPath() {
            return (int[])this.commonPath.clone();
        }

        public IMultiplePathsFromGCRootsComputer getPathsComputer() {
            return this.pathsComputer;
        }

        public int[] getSuspectInstances() {
            return (int[])this.suspectInstances.clone();
        }
    }

    public static class SuspectsResultTable
    implements IResultTable {
        SuspectRecord[] data;
        long totalHeap;

        public SuspectsResultTable(SuspectRecord[] data, long totalHeap) {
            this.data = (SuspectRecord[])data.clone();
            this.totalHeap = totalHeap;
        }

        public ResultMetaData getResultMetaData() {
            return new ResultMetaData.Builder().addContext(new ContextProvider(Messages.FindLeaksQuery_LeakSuspect){

                public IContextObject getContext(Object row) {
                    return this.getLeakSuspect(row);
                }
            }).addContext(new ContextProvider(Messages.FindLeaksQuery_AccumulationPoint){

                public IContextObject getContext(Object row) {
                    return this.getAccumulationPoint(row);
                }
            }).build();
        }

        public Column[] getColumns() {
            return new Column[]{new Column(Messages.FindLeaksQuery_ColumnLeakSuspect), new Column(Messages.FindLeaksQuery_Column_NumObjects, Long.class), new Column(Messages.FindLeaksQuery_Column_SuspectRetainedHeap, Bytes.class), new Column(Messages.FindLeaksQuery_Column_SuspectPercent, Double.class).formatting((Format)NumberFormat.getPercentInstance()), new Column(Messages.FindLeaksQuery_Column_AccumulationPoint), new Column(Messages.FindLeaksQuery_Column_AccPointRetainedHeap, Bytes.class), new Column(Messages.FindLeaksQuery_Column_AccPointPercent, Double.class).formatting((Format)NumberFormat.getPercentInstance())};
        }

        public int getRowCount() {
            return this.data.length;
        }

        public SuspectRecord getRow(int rowId) {
            return this.data[rowId];
        }

        public Object getColumnValue(Object row, int columnIndex) {
            SuspectRecord suspect = (SuspectRecord)row;
            switch (columnIndex) {
                case 0: {
                    return suspect.suspect.getTechnicalName();
                }
                case 1: {
                    return suspect instanceof SuspectRecordGroupOfObjects ? ((SuspectRecordGroupOfObjects)suspect).suspectInstances.length : 1;
                }
                case 2: {
                    return suspect.suspectRetained;
                }
                case 3: {
                    return (double)suspect.getSuspectRetained() / (double)this.totalHeap;
                }
                case 4: {
                    return suspect.accumulationPoint == null ? Messages.FindLeaksQuery_NotFound : suspect.accumulationPoint.getObject().getTechnicalName();
                }
                case 5: {
                    return new Bytes(suspect.accumulationPoint == null ? 0L : suspect.accumulationPoint.getRetainedHeapSize());
                }
                case 6: {
                    return suspect.accumulationPoint == null ? 0.0 : (double)suspect.accumulationPoint.getRetainedHeapSize() / (double)this.totalHeap;
                }
            }
            return null;
        }

        public IContextObject getContext(final Object row) {
            return new IContextObject(){

                public int getObjectId() {
                    return ((SuspectRecord)row).suspect.getObjectId();
                }
            };
        }

        IContextObject getLeakSuspect(Object row) {
            final SuspectRecord suspect = (SuspectRecord)row;
            if (suspect instanceof SuspectRecordGroupOfObjects) {
                return new IContextObjectSet(){

                    public int getObjectId() {
                        return suspect.suspect.getObjectId();
                    }

                    public int[] getObjectIds() {
                        return ((SuspectRecordGroupOfObjects)suspect).suspectInstances;
                    }

                    public String getOQL() {
                        return null;
                    }
                };
            }
            return new IContextObject(){

                public int getObjectId() {
                    return suspect.suspect.getObjectId();
                }
            };
        }

        IContextObject getAccumulationPoint(Object row) {
            final SuspectRecord suspect = (SuspectRecord)row;
            if (suspect.accumulationPoint == null) {
                return null;
            }
            return new IContextObject(){

                public int getObjectId() {
                    return suspect.accumulationPoint.getObject().getObjectId();
                }
            };
        }

        public SuspectRecord[] getData() {
            return (SuspectRecord[])this.data.clone();
        }

        public long getTotalHeap() {
            return this.totalHeap;
        }
    }
}

