/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.model.nattable.nattablecelleditor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MatrixRelationShipDirection implements Enumerator
{
    NONE(0, "NONE", "NONE"),
    FROM_ROW_TO_COLUMN(1, "FROM_ROW_TO_COLUMN", "FROM_ROW_TO_COLUMN"),
    FROM_COLUMN_TO_ROW(2, "FROM_COLUMN_TO_ROW", "FROM_COLUMN_TO_ROW");

    public static final int NONE_VALUE = 0;
    public static final int FROM_ROW_TO_COLUMN_VALUE = 1;
    public static final int FROM_COLUMN_TO_ROW_VALUE = 2;
    private static final MatrixRelationShipDirection[] VALUES_ARRAY;
    public static final List<MatrixRelationShipDirection> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MatrixRelationShipDirection[]{NONE, FROM_ROW_TO_COLUMN, FROM_COLUMN_TO_ROW};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MatrixRelationShipDirection get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MatrixRelationShipDirection result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MatrixRelationShipDirection getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MatrixRelationShipDirection result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MatrixRelationShipDirection get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return FROM_ROW_TO_COLUMN;
            }
            case 2: {
                return FROM_COLUMN_TO_ROW;
            }
        }
        return null;
    }

    private MatrixRelationShipDirection(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

