/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.ui.model;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.ITypeCatalog;
import org.eclipse.uml2.uml.Type;

public class ResourceTypeProvider
implements ITypeCatalog {
    protected Resource resource;
    protected EClassifier requestedType;
    protected Predicate<EObject> typePredicate;

    public ResourceTypeProvider(Resource resource, EClass requestedType) {
        this.resource = resource;
        this.requestedType = requestedType;
        this.typePredicate = new TypePredicate();
    }

    @Override
    public List<Type> getTypes() {
        ArrayList<Type> result = new ArrayList<Type>();
        TreeIterator iter = this.resource.getAllContents();
        Iterators.filter((Iterator)iter, (Predicate)this.getTypePredicate());
        while (iter.hasNext()) {
            EObject object = (EObject)iter.next();
            if (!this.requestedType.isInstance((Object)object)) continue;
            result.add((Type)object);
        }
        return result;
    }

    private Predicate getTypePredicate() {
        return this.typePredicate;
    }

    @Override
    public Iterator<Type> iterator() {
        return Iterators.filter((Iterator)this.resource.getAllContents(), (Predicate)this.getTypePredicate());
    }

    class TypePredicate
    implements Predicate<EObject> {
        TypePredicate() {
        }

        public boolean apply(EObject input) {
            return ResourceTypeProvider.this.requestedType.isInstance((Object)input);
        }
    }
}

