/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.cdt.core.remotemake;

import java.io.IOException;
import java.io.OutputStream;
import java.text.StringCharacterIterator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ptp.ems.core.EnvManagerConfigString;
import org.eclipse.ptp.ems.core.EnvManagerRegistry;
import org.eclipse.ptp.ems.core.IEnvManager;
import org.eclipse.ptp.ems.core.IEnvManagerConfig;
import org.eclipse.ptp.internal.rdt.sync.cdt.core.Activator;
import org.eclipse.ptp.internal.rdt.sync.cdt.core.messages.Messages;
import org.eclipse.ptp.internal.rdt.sync.cdt.core.remotemake.RemoteProcessClosure;
import org.eclipse.ptp.internal.rdt.sync.core.RDTSyncCorePlugin;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.core.SyncFlag;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.exceptions.MissingConnectionException;
import org.eclipse.ptp.rdt.sync.core.handlers.ISyncExceptionHandler;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteProcessService;
import org.eclipse.remote.core.RemoteProcessAdapter;
import org.eclipse.remote.core.exception.RemoteConnectionException;

public class SyncCommandLauncher
implements ICommandLauncher {
    public static final String EMS_CONFIG_PROPERTY = "ems-configuration";
    private static final Set<Character> NON_ESCAPED_ASCII_CHARS;
    private static ISyncExceptionHandler syncExceptionHandler;
    protected IProject fProject;
    protected Process fProcess;
    protected IRemoteProcess fRemoteProcess;
    protected boolean fShowCommand;
    protected String[] fCommandArgs;
    protected String lineSeparator = "\r\n";
    protected String fErrorMessage;
    protected Map<String, String> remoteEnvMap;
    private boolean shouldSyncBeforeRun = true;
    private boolean shouldSyncAfterRun = true;
    protected static final long DELAY = 50L;

    static {
        syncExceptionHandler = new ISyncExceptionHandler(){

            public void handle(IProject project, CoreException e) {
                RDTSyncCorePlugin.log((String)project.getName(), (Throwable)e);
            }
        };
        NON_ESCAPED_ASCII_CHARS = new HashSet<Character>();
        StringCharacterIterator it = new StringCharacterIterator("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789/._-");
        char c = it.first();
        while (c != '\uffff') {
            NON_ESCAPED_ASCII_CHARS.add(Character.valueOf(c));
            c = it.next();
        }
    }

    private static String escape(String inputString) {
        if (inputString == null) {
            return null;
        }
        StringBuilder newString = new StringBuilder(inputString.length() + 16);
        StringCharacterIterator it = new StringCharacterIterator(inputString);
        char c = it.first();
        while (c != '\uffff') {
            if (c == '\'') {
                newString.append("'\\\\\\''");
            } else if (c > '\u007f' || NON_ESCAPED_ASCII_CHARS.contains(Character.valueOf(c))) {
                newString.append(c);
            } else {
                newString.append("\\" + c);
            }
            c = it.next();
        }
        return newString.toString();
    }

    private static String getCommandAsString(IPath commandPath, String[] args) {
        StringBuilder sb = new StringBuilder();
        sb.append(SyncCommandLauncher.escape(commandPath.toOSString()));
        sb.append(' ');
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            sb.append(SyncCommandLauncher.escape(arg));
            sb.append(' ');
            ++n2;
        }
        return sb.toString();
    }

    private List<String> constructCommand(IPath commandPath, String[] args, IRemoteConnection connection, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        SyncConfig config = SyncConfigManager.getActive((IProject)this.getProject());
        EnvManagerConfigString projectProperties = new EnvManagerConfigString(config.getProperty(EMS_CONFIG_PROPERTY));
        if (projectProperties.isEnvMgmtEnabled()) {
            IEnvManager envManager = EnvManagerRegistry.getEnvManager((IProgressMonitor)progress.newChild(50), (IRemoteConnection)connection);
            try {
                LinkedList<String> command = new LinkedList<String>();
                command.add("bash");
                command.add("-l");
                String bashScriptFilename = envManager.createBashScript((IProgressMonitor)progress.newChild(50), true, (IEnvManagerConfig)projectProperties, SyncCommandLauncher.getCommandAsString(commandPath, args));
                command.add(bashScriptFilename);
                return command;
            }
            catch (Exception e) {
                Activator.log(Messages.SyncCommandLauncher_0, e);
                LinkedList<String> command = new LinkedList<String>();
                command.add("bash");
                command.add("-l");
                command.add("-c");
                String bashCommand = envManager.getBashConcatenation("; ", true, (IEnvManagerConfig)projectProperties, SyncCommandLauncher.getCommandAsString(commandPath, args));
                command.add(bashCommand);
                return command;
            }
        }
        LinkedList<String> command = new LinkedList<String>();
        command.add("bash");
        command.add("-l");
        command.add("-c");
        command.add(SyncCommandLauncher.getCommandAsString(commandPath, args));
        return command;
    }

    protected String[] constructCommandArray(String command, String[] commandArgs) {
        String[] args = new String[1 + commandArgs.length];
        args[0] = command;
        System.arraycopy(commandArgs, 0, args, 1, commandArgs.length);
        return args;
    }

    private Properties convertEnvMapToProperties() {
        Properties properties = new Properties();
        for (String key : this.remoteEnvMap.keySet()) {
            properties.put(key, this.remoteEnvMap.get(key));
        }
        return properties;
    }

    public Process execute(IPath commandPath, String[] args, String[] env, IPath changeToDirectory, IProgressMonitor monitor) throws CoreException {
        IRemoteConnection connection;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.getProject() == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.internal.rdt.sync.cdt.core", Messages.SyncCommandLauncher_1));
        }
        SyncConfig config = SyncConfigManager.getActive((IProject)this.getProject());
        if (config == null) {
            return null;
        }
        String projectLocalRoot = this.getProject().getLocation().toPortableString();
        String projectActualRoot = config.getLocation(this.getProject());
        String fixedDirectory = changeToDirectory.toString().replaceFirst(Pattern.quote(projectLocalRoot), Matcher.quoteReplacement(projectActualRoot));
        changeToDirectory = new Path(fixedDirectory);
        this.fCommandArgs = this.constructCommandArray(commandPath.toPortableString(), args);
        try {
            connection = config.getRemoteConnection();
        }
        catch (MissingConnectionException e2) {
            throw new CoreException((IStatus)new Status(8, "org.eclipse.ptp.internal.rdt.sync.cdt.core", Messages.SyncCommandLauncher_2));
        }
        if (!connection.isOpen()) {
            try {
                connection.open((IProgressMonitor)progress.newChild(20));
            }
            catch (RemoteConnectionException e1) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.internal.rdt.sync.cdt.core", Messages.SyncCommandLauncher_3, (Throwable)e1));
            }
        }
        List<String> command = this.constructCommand(commandPath, args, connection, (IProgressMonitor)progress.newChild(10));
        IRemoteProcessService processService = (IRemoteProcessService)connection.getService(IRemoteProcessService.class);
        if (processService == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.internal.rdt.sync.cdt.core", Messages.SyncCommandLauncher_4));
        }
        IRemoteProcessBuilder processBuilder = processService.getProcessBuilder(command);
        this.remoteEnvMap = processBuilder.environment();
        String[] stringArray = env;
        int n = env.length;
        int n2 = 0;
        while (n2 < n) {
            String envVar = stringArray[n2];
            String[] splitStr = envVar.split("=", 2);
            if (splitStr.length > 1) {
                this.remoteEnvMap.put(splitStr[0], splitStr[1]);
            } else if (splitStr.length == 1) {
                this.remoteEnvMap.put(splitStr[0], "");
            }
            ++n2;
        }
        IRemoteFileService fileService = (IRemoteFileService)connection.getService(IRemoteFileService.class);
        if (changeToDirectory != null && fileService != null) {
            processBuilder.directory(fileService.getResource(changeToDirectory.toString()));
        }
        this.syncOnPreBuild((IProgressMonitor)progress.newChild(60));
        IRemoteProcess p = null;
        try {
            p = processBuilder.start();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.internal.rdt.sync.cdt.core", Messages.SyncCommandLauncher_5, (Throwable)e));
        }
        this.fRemoteProcess = p;
        this.fProcess = new RemoteProcessAdapter(p);
        return this.fProcess;
    }

    public String[] getCommandArgs() {
        return this.fCommandArgs;
    }

    public String getCommandLine() {
        return this.getCommandLine(this.getCommandArgs());
    }

    private String getCommandLine(String[] commandArgs) {
        if (this.fProject == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        if (this.fCommandArgs != null) {
            String[] stringArray = commandArgs;
            int n = commandArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String commandArg = stringArray[n2];
                buf.append(commandArg);
                buf.append(' ');
                ++n2;
            }
            buf.append(this.lineSeparator);
        }
        return buf.toString();
    }

    public Properties getEnvironment() {
        return this.convertEnvMapToProperties();
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public IProject getProject() {
        return this.fProject;
    }

    protected void printCommandLine(OutputStream os) {
        if (os != null) {
            String cmd = this.getCommandLine(this.getCommandArgs());
            try {
                os.write(cmd.getBytes());
                os.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setErrorMessage(String error) {
        this.fErrorMessage = error;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public void setSyncAfterRun(boolean shouldSync) {
        this.shouldSyncAfterRun = shouldSync;
    }

    public void setSyncBeforeRun(boolean shouldSync) {
        this.shouldSyncBeforeRun = shouldSync;
    }

    public void showCommand(boolean show) {
        this.fShowCommand = show;
    }

    private void syncOnPostBuild(IProgressMonitor monitor) throws CoreException {
        SyncConfig config = SyncConfigManager.getActive((IProject)this.getProject());
        if (this.shouldSyncAfterRun && SyncManager.getSyncAuto() && config.isSyncOnPostBuild()) {
            SyncManager.syncBlocking(null, (IProject)this.getProject(), (Set)SyncFlag.RL_ONLY, (IProgressMonitor)monitor, (ISyncExceptionHandler)syncExceptionHandler);
        }
    }

    private void syncOnPreBuild(IProgressMonitor monitor) throws CoreException {
        SyncConfig config = SyncConfigManager.getActive((IProject)this.getProject());
        if (this.shouldSyncBeforeRun && config.isSyncOnPreBuild()) {
            switch (SyncManager.getSyncMode((IProject)this.getProject())) {
                case ACTIVE_BEFORE_BUILD: {
                    SyncManager.syncBlocking(null, (IProject)this.getProject(), (Set)SyncFlag.LR_ONLY, (IProgressMonitor)monitor, (ISyncExceptionHandler)syncExceptionHandler);
                    break;
                }
                case ACTIVE: {
                    SyncManager.syncBlocking(null, (IProject)this.getProject(), (Set)SyncFlag.WAIT_FOR_LR_ONLY, (IProgressMonitor)monitor, (ISyncExceptionHandler)syncExceptionHandler);
                    break;
                }
                case ALL: {
                    SyncManager.syncBlocking(null, (IProject)this.getProject(), (Set)SyncFlag.WAIT_FOR_LR_ONLY, (IProgressMonitor)monitor, (ISyncExceptionHandler)syncExceptionHandler);
                    break;
                }
                case NONE: {
                    break;
                }
                case UNAVAILABLE: {
                    break;
                }
            }
        }
    }

    public int waitAndRead(OutputStream out, OutputStream err) {
        if (this.fShowCommand) {
            this.printCommandLine(out);
        }
        if (this.fProcess == null) {
            return -1;
        }
        RemoteProcessClosure closure = new RemoteProcessClosure(this.fRemoteProcess, out, err);
        closure.runBlocking();
        return 0;
    }

    public int waitAndRead(OutputStream output, OutputStream err, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)15);
        if (this.fShowCommand) {
            this.printCommandLine(output);
        }
        if (this.fProcess == null) {
            return -1;
        }
        RemoteProcessClosure closure = new RemoteProcessClosure(this.fRemoteProcess, output, err);
        closure.runNonBlocking();
        while (!progress.isCanceled() && closure.isRunning()) {
            try {
                Thread.sleep(50L);
                progress.worked(1);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        closure.isAlive();
        int state = 0;
        if (progress.isCanceled()) {
            closure.terminate();
            state = 1;
            this.setErrorMessage(Messages.SyncCommandLauncher_6);
        }
        try {
            this.fProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.syncOnPostBuild((IProgressMonitor)progress.newChild(5));
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        try {
            this.getProject().refreshLocal(2, (IProgressMonitor)progress.newChild(5));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return state;
    }

    public static void setSyncExceptionHandler(ISyncExceptionHandler handler) {
        syncExceptionHandler = handler;
    }
}

