/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.FlatContainerStyle;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.description.DescriptionPackage;
import org.eclipse.sirius.diagram.sequence.description.FrameMapping;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.SequenceEditPartsOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ISequenceEventEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.InteractionUseResizableEditPolicy;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.SequenceLaunchToolEditPolicy;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.ui.SequenceNoCopyDragEditPartsTrackerEx;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeContainerEditPart;
import org.eclipse.sirius.ext.gmf.runtime.diagram.ui.tools.RubberbandDragTracker;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.SiriusWrapLabel;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;

public class InteractionUseEditPart
extends DNodeContainerEditPart
implements ISequenceEventEditPart {
    private SiriusWrapLabel fExpressionLabelFigure;
    private NotificationListener usedInteractionLabelUpdater = new NotificationListener(){

        public void notifyChanged(Notification notification) {
            if (!notification.isTouch()) {
                InteractionUseEditPart.this.refreshUsedInteractionLabel();
            }
        }
    };

    public InteractionUseEditPart(View view) {
        super(view);
    }

    public void addNotify() {
        SequenceEditPartsOperations.registerDiagramElement((IGraphicalEditPart)this, (EObject)this.resolveDiagramElement());
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        SequenceEditPartsOperations.unregisterDiagramElement((IGraphicalEditPart)this, (EObject)this.resolveDiagramElement());
    }

    public void installEditPolicy(Object key, EditPolicy editPolicy) {
        if ("PrimaryDrag Policy".equals(key)) {
            super.installEditPolicy(key, (EditPolicy)new InteractionUseResizableEditPolicy());
        } else {
            super.installEditPolicy(key, editPolicy);
        }
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("launchTool", (EditPolicy)new SequenceLaunchToolEditPolicy());
    }

    protected String computeCenterLabelExpression() {
        ContainerMapping actualMapping;
        DNodeContainer dNodeContainer;
        String centeredLabelText = "";
        if (this.resolveSemanticElement() instanceof DNodeContainer && (dNodeContainer = (DNodeContainer)this.resolveSemanticElement()).eContainer() != null && (actualMapping = dNodeContainer.getActualMapping()) instanceof FrameMapping) {
            FrameMapping frameMapping = (FrameMapping)actualMapping;
            String centerLabelExpression = frameMapping.getCenterLabelExpression();
            EObject eObject = dNodeContainer.getTarget();
            try {
                centeredLabelText = this.evaluationExpression(eObject, centerLabelExpression);
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)frameMapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getFrameMapping_CenterLabelExpression(), (Throwable)e);
            }
        }
        return centeredLabelText;
    }

    private String evaluationExpression(EObject self, String expression) throws EvaluationException {
        IInterpreter interpreter = null;
        if (self != null && (interpreter = InterpreterUtil.getInterpreter((EObject)self)) != null) {
            return interpreter.evaluateString(self, expression);
        }
        return "";
    }

    private void refreshUsedInteractionLabel() {
        if (this.fExpressionLabelFigure != null) {
            this.fExpressionLabelFigure.setText(this.computeCenterLabelExpression());
        }
    }

    public void activate() {
        super.activate();
        DiagramEventBroker broker = null;
        TransactionalEditingDomain theEditingDomain = this.getEditingDomain();
        if (theEditingDomain != null) {
            broker = DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        if (broker != null) {
            for (EObject semantic : this.resolveAllSemanticElements()) {
                broker.addNotificationListener(semantic, this.usedInteractionLabelUpdater);
            }
        }
    }

    public void deactivate() {
        super.deactivate();
        DiagramEventBroker broker = null;
        TransactionalEditingDomain theEditingDomain = this.getEditingDomain();
        if (theEditingDomain != null) {
            broker = DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        if (broker != null) {
            for (EObject semantic : this.resolveAllSemanticElements()) {
                broker.removeNotificationListener(semantic, this.usedInteractionLabelUpdater);
            }
        }
    }

    @Override
    public ISequenceEvent getISequenceEvent() {
        return (ISequenceEvent)ISequenceElementAccessor.getInteractionUse((View)this.getNotationView()).get();
    }

    protected NodeFigure createMainFigure() {
        DDiagramElementContainer container;
        EObject eObj;
        NodeFigure figure = super.createMainFigure();
        if (figure instanceof DefaultSizeNodeFigure && (eObj = this.resolveSemanticElement()) instanceof DDiagramElementContainer && (container = (DDiagramElementContainer)eObj).getOwnedStyle() instanceof FlatContainerStyle) {
            ((DefaultSizeNodeFigure)figure).setDefaultSize(60, 50);
        }
        this.fExpressionLabelFigure = new SiriusWrapLabel();
        this.refreshUsedInteractionLabel();
        this.fExpressionLabelFigure.setTextWrap(true);
        this.fExpressionLabelFigure.setLabelAlignment(0x1000000);
        figure.add((IFigure)this.fExpressionLabelFigure);
        return figure;
    }

    public DragTracker getDragTracker(Request request) {
        if (request instanceof SelectionRequest && ((SelectionRequest)request).isAltKeyPressed()) {
            return new RubberbandDragTracker();
        }
        return new SequenceNoCopyDragEditPartsTrackerEx((EditPart)this);
    }
}

