/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.querybasedfeatures.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.viatra.addon.querybasedfeatures.runtime.QueryBasedFeatureKind;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IMatchUpdateListener;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineLifecycleListener;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.api.ViatraQueryModelUpdateListener;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.QuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

public abstract class QueryBasedFeature {
    private ViatraQueryMatcher<IPatternMatch> matcher;
    private Set<IPatternMatch> matchFoundEvents;
    private Set<IPatternMatch> matchLostEvents;
    private final EStructuralFeature feature;
    private String sourceParamName;
    private String targetParamName;
    private boolean keepCache = true;
    private boolean initialized = false;
    private final List<ENotificationImpl> notifications = new ArrayList<ENotificationImpl>();
    private ModelUpdateListener listener;
    private EngineLifecycleListener engineLifecycleListener;
    private MatchUpdateListener matchUpdateListener;

    protected void initialize(ViatraQueryMatcher<IPatternMatch> matcher, String sourceParamName, String targetParamName) {
        if (this.initialized) {
            ViatraQueryLoggingUtil.getLogger(this.getClass()).error((Object)"[QueryBasedFeature] Feature already initialized!");
            return;
        }
        this.initialized = true;
        this.matcher = matcher;
        this.sourceParamName = sourceParamName;
        this.targetParamName = targetParamName;
        if (matcher.getPositionOfParameter(sourceParamName) == null) {
            ViatraQueryLoggingUtil.getLogger(this.getClass()).error((Object)("[QueryBasedFeature] Source parameter " + sourceParamName + " not found!"));
        }
        if (targetParamName != null && matcher.getPositionOfParameter(targetParamName) == null) {
            ViatraQueryLoggingUtil.getLogger(this.getClass()).error((Object)("[QueryBasedFeature] Target parameter " + targetParamName + " not found!"));
        }
        this.matchFoundEvents = new HashSet<IPatternMatch>();
        this.matchLostEvents = new HashSet<IPatternMatch>();
        this.matchUpdateListener = new MatchUpdateListener();
        this.engineLifecycleListener = new EngineLifecycleListener();
        this.listener = new ModelUpdateListener();
    }

    private void sendNotfications() {
        while (!this.notifications.isEmpty()) {
            ENotificationImpl remove = this.notifications.remove(0);
            ((Notifier)remove.getNotifier()).eNotify((Notification)remove);
        }
    }

    public QueryBasedFeature(EStructuralFeature feature, boolean keepCache) {
        this.feature = feature;
        this.keepCache = keepCache;
    }

    protected ViatraQueryMatcher<IPatternMatch> getMatcher() {
        return this.matcher;
    }

    protected void setMatcher(ViatraQueryMatcher<IPatternMatch> matcher) {
        this.matcher = matcher;
    }

    protected EStructuralFeature getFeature() {
        return this.feature;
    }

    protected String getSourceParamName() {
        return this.sourceParamName;
    }

    protected void setSourceParamName(String sourceParamName) {
        this.sourceParamName = sourceParamName;
    }

    protected String getTargetParamName() {
        return this.targetParamName;
    }

    protected void setTargetParamName(String targetParamName) {
        this.targetParamName = targetParamName;
    }

    protected boolean isCached() {
        return this.keepCache;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    public abstract QueryBasedFeatureKind getKind();

    protected abstract void afterUpdate();

    protected abstract void beforeUpdate();

    protected void startMonitoring() {
        AdvancedViatraQueryEngine engine = this.engineForMatcher();
        engine.addMatchUpdateListener(this.matcher, (IMatchUpdateListener)this.matchUpdateListener, true);
        engine.addLifecycleListener((ViatraQueryEngineLifecycleListener)this.engineLifecycleListener);
        engine.addModelUpdateListener((ViatraQueryModelUpdateListener)this.listener);
        this.listener.notifyChanged(ViatraQueryModelUpdateListener.ChangeLevel.MATCHSET);
    }

    protected AdvancedViatraQueryEngine engineForMatcher() {
        return (AdvancedViatraQueryEngine)this.matcher.getEngine();
    }

    public abstract Object getValue(Object var1);

    private Collection<IPatternMatch> processNewMatches(Collection<IPatternMatch> signatures) {
        ArrayList<IPatternMatch> processed = new ArrayList<IPatternMatch>();
        for (IPatternMatch signature : signatures) {
            this.processAppearedMatch(signature);
            processed.add(signature);
        }
        return processed;
    }

    protected abstract void processAppearedMatch(IPatternMatch var1);

    protected InternalEObject getSourceValue(IPatternMatch signature) {
        return (InternalEObject)signature.get(this.sourceParamName);
    }

    protected Object getTargetValue(IPatternMatch signature) {
        return signature.get(this.targetParamName);
    }

    private Collection<IPatternMatch> processLostMatches(Collection<IPatternMatch> signatures) {
        ArrayList<IPatternMatch> processed = new ArrayList<IPatternMatch>();
        for (IPatternMatch signature : signatures) {
            this.processDisappearedMatch(signature);
            processed.add(signature);
        }
        return processed;
    }

    protected abstract void processDisappearedMatch(IPatternMatch var1);

    protected void appendNotificationToList(ENotificationImpl notification) {
        this.notifications.add(notification);
    }

    private final class EngineLifecycleListener
    implements ViatraQueryEngineLifecycleListener {
        private EngineLifecycleListener() {
        }

        public void matcherInstantiated(ViatraQueryMatcher<? extends IPatternMatch> matcher) {
        }

        public void engineWiped() {
            String patternName = QueryBasedFeature.this.matcher.getPatternName();
            try {
                IQuerySpecificationRegistry registry = QuerySpecificationRegistry.getInstance();
                IQuerySpecification querySpecification = (IQuerySpecification)registry.getDefaultView().getEntry(patternName).get();
                QueryBasedFeature.this.matcher = querySpecification.getMatcher((ViatraQueryEngine)QueryBasedFeature.this.engineForMatcher());
            }
            catch (ViatraQueryException e) {
                ViatraQueryLoggingUtil.getLogger(this.getClass()).error((Object)("[QueryBasedFeature] Exception during wipe callback: " + e.getMessage()), (Throwable)e);
            }
            QueryBasedFeature.this.matchFoundEvents.clear();
            QueryBasedFeature.this.matchLostEvents.clear();
        }

        public void engineDisposed() {
        }

        public void engineBecameTainted(String description, Throwable t) {
        }
    }

    private final class MatchUpdateListener
    implements IMatchUpdateListener<IPatternMatch> {
        private MatchUpdateListener() {
        }

        public void notifyAppearance(IPatternMatch match) {
            boolean removed = QueryBasedFeature.this.matchLostEvents.remove(match);
            if (!removed) {
                QueryBasedFeature.this.matchFoundEvents.add(match);
            }
        }

        public void notifyDisappearance(IPatternMatch match) {
            boolean removed = QueryBasedFeature.this.matchFoundEvents.remove(match);
            if (!removed) {
                QueryBasedFeature.this.matchLostEvents.add(match);
            }
        }
    }

    private final class ModelUpdateListener
    implements ViatraQueryModelUpdateListener {
        private ModelUpdateListener() {
        }

        public void notifyChanged(ViatraQueryModelUpdateListener.ChangeLevel changeLevel) {
            QueryBasedFeature.this.beforeUpdate();
            QueryBasedFeature.this.matchFoundEvents.removeAll(QueryBasedFeature.this.processNewMatches(QueryBasedFeature.this.matchFoundEvents));
            QueryBasedFeature.this.matchLostEvents.removeAll(QueryBasedFeature.this.processLostMatches(QueryBasedFeature.this.matchLostEvents));
            QueryBasedFeature.this.afterUpdate();
            QueryBasedFeature.this.sendNotfications();
        }

        public ViatraQueryModelUpdateListener.ChangeLevel getLevel() {
            return ViatraQueryModelUpdateListener.ChangeLevel.MATCHSET;
        }
    }
}

