/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.databinding;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.core.internal.databinding.property.value.SimplePropertyObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.IDataProvider;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.databinding.EventPropertyObservableValue;
import org.eclipse.xwt.databinding.TypedViewerObservableValueDecorator;
import org.eclipse.xwt.databinding.copy.SWTObservables;
import org.eclipse.xwt.databinding.copy.ViewersObservables;
import org.eclipse.xwt.internal.core.UpdateSourceTrigger;
import org.eclipse.xwt.internal.databinding.menuitem.MenuItemEnabledObservableValue;
import org.eclipse.xwt.internal.databinding.menuitem.MenuItemSelectionObservableValue;
import org.eclipse.xwt.internal.utils.LoggerManager;
import org.eclipse.xwt.internal.utils.UserData;
import org.eclipse.xwt.javabean.metadata.properties.EventProperty;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.metadata.IProperty;

public class JFaceXWTDataBinding {
    static final String ENABLED = "enabled";
    static final String SELECTION = "selection";
    static final String TEXT = "text";
    public static final Class<?>[] CONTROL_ARGUMENT_TYPES = new Class[]{Control.class};
    public static final Class<?>[] VIEWER_ARGUMENT_TYPES = new Class[]{Viewer.class};
    static String[] VIEWERS_PROPERTIES = null;

    static {
        Method[] methods = ViewerProperties.class.getDeclaredMethods();
        VIEWERS_PROPERTIES = new String[methods.length];
        int i = 0;
        while (i < methods.length) {
            JFaceXWTDataBinding.VIEWERS_PROPERTIES[i] = methods[i].getName();
            ++i;
        }
    }

    public static boolean isViewerProperty(String propertyName) {
        String[] stringArray = VIEWERS_PROPERTIES;
        int n = VIEWERS_PROPERTIES.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals(propertyName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Class<?> getValueType(Class<?> type, String propertyName) {
        if (type == null || propertyName == null || propertyName.indexOf(".") != -1) {
            return null;
        }
        try {
            IMetaclass metaclass = XWT.getMetaclass(type);
            IProperty property = metaclass.findProperty(propertyName);
            if (property != null) {
                return property.getType();
            }
        }
        catch (Exception e) {
            LoggerManager.log(e);
        }
        return null;
    }

    public static Object getValue(Object target, String propertyName) {
        if (target == null || propertyName == null || propertyName.indexOf(".") != -1) {
            return target;
        }
        Class<?> type = target.getClass();
        try {
            Field[] fields;
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors = beanInfo.getPropertyDescriptors();
            int n = propertyDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                Method readMethod;
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                if (propertyName.equalsIgnoreCase(pd.getName()) && (readMethod = pd.getReadMethod()) != null) {
                    return readMethod.invoke(target, new Object[0]);
                }
                ++n2;
            }
            Field[] fieldArray = fields = type.getDeclaredFields();
            int n3 = fields.length;
            n = 0;
            while (n < n3) {
                Field field = fieldArray[n];
                if (propertyName.equalsIgnoreCase(field.getName())) {
                    Object object = field.get(target);
                    return object;
                }
                ++n;
            }
            return UserData.getLocalData(target, propertyName);
        }
        catch (Exception e) {
            LoggerManager.log(e);
            return null;
        }
    }

    public static void setValue(Object target, String propertyName, Object value) {
        Class<?> type = target.getClass();
        try {
            Field[] fields;
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors = beanInfo.getPropertyDescriptors();
            int n = propertyDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                if (propertyName.equals(pd.getName())) {
                    Class<?>[] parameterTypes;
                    Class<?> targetType;
                    Method writeMethod = pd.getWriteMethod();
                    if (writeMethod == null) {
                        return;
                    }
                    if (!writeMethod.isAccessible()) {
                        writeMethod.setAccessible(true);
                    }
                    if ((targetType = (parameterTypes = writeMethod.getParameterTypes())[0]) != value.getClass()) {
                        IConverter c;
                        if (targetType.isEnum() && value instanceof String) {
                            try {
                                writeMethod.invoke(target, Enum.valueOf(targetType, (String)value));
                                return;
                            }
                            catch (Exception exception) {}
                        }
                        if ((c = XWT.findConvertor(value.getClass(), targetType)) != null) {
                            value = c.convert(value);
                        }
                    }
                    writeMethod.invoke(target, value);
                    return;
                }
                ++n2;
            }
            Field[] fieldArray = fields = type.getDeclaredFields();
            int n3 = fields.length;
            n = 0;
            while (n < n3) {
                Field field = fieldArray[n];
                if (propertyName.equals(field.getName())) {
                    IConverter c;
                    Class<?> fieldType;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    if ((fieldType = field.getType()).isEnum() && value instanceof String) {
                        try {
                            field.set(target, Enum.valueOf(fieldType, (String)value));
                            return;
                        }
                        catch (Exception exception) {}
                    }
                    if ((c = XWT.findConvertor(value.getClass(), fieldType)) != null) {
                        value = c.convert(value);
                    }
                    field.set(target, value);
                    return;
                }
                ++n;
            }
            IMetaclass metaclass = XWT.getMetaclass(type);
            IProperty property = metaclass.findProperty(propertyName);
            if (property != null) {
                property.setValue(target, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isPropertyReadOnly(Class<?> type, String propertyName) {
        if (type == null || propertyName == null || propertyName.indexOf(".") != -1) {
            return true;
        }
        try {
            IMetaclass metaclass = XWT.getMetaclass(type);
            IProperty property = metaclass.findProperty(propertyName);
            if (property != null) {
                return property.isReadOnly();
            }
        }
        catch (Exception e) {
            LoggerManager.log(e);
        }
        return true;
    }

    public static boolean isBeanSupport(Object target) {
        Class<?> type = JFaceXWTDataBinding.toType(target);
        Method method = null;
        try {
            try {
                method = type.getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = type.getMethod("addPropertyChangeListener", PropertyChangeListener.class);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return method != null;
    }

    public static Class<?> toType(Object target) {
        Class<?> type = null;
        if (target instanceof IObservableValue) {
            IObservableValue value = (IObservableValue)target;
            Object valueType = value.getValueType();
            if (valueType instanceof Class) {
                type = (Class<?>)valueType;
            }
        } else if (target instanceof Class) {
            type = (Class<?>)target;
        } else if (target instanceof IDataProvider) {
            IDataProvider dataProvider = (IDataProvider)target;
            type = JFaceXWTDataBinding.toType(dataProvider.getData(null));
        } else {
            type = target.getClass();
        }
        if (type == null) {
            return Object.class;
        }
        return type;
    }

    public static boolean isValueProperty(Class<?> object, String propertyName) {
        boolean isProperty;
        if (propertyName == null) {
            return false;
        }
        if (Viewer.class.isAssignableFrom(object)) {
            return JFaceXWTDataBinding.isViewerValueProperty(object, propertyName);
        }
        if (MenuItem.class.isAssignableFrom(object)) {
            if (ENABLED.equalsIgnoreCase(propertyName)) {
                return true;
            }
            if (SELECTION.equalsIgnoreCase(propertyName)) {
                return true;
            }
        }
        return isProperty = JFaceXWTDataBinding.isControlValueProperty(object, propertyName);
    }

    public static IObservable observeWidget(Object object, String propertyName, UpdateSourceTrigger updateSourceTrigger, int observedKind) {
        if (propertyName == null) {
            return null;
        }
        try {
            switch (observedKind) {
                case 0: {
                    return JFaceXWTDataBinding.observePropertyValue(object, propertyName, updateSourceTrigger);
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 1: {
                    return JFaceXWTDataBinding.observePropertyValue(object, propertyName, updateSourceTrigger);
                }
            }
        }
        catch (XWTException xWTException) {}
        return null;
    }

    protected static IObservable observePropertyValue(Object object, String propertyName, UpdateSourceTrigger updateSourceTrigger) {
        if (object instanceof Viewer) {
            if ("input".equals(propertyName)) {
                Viewer viewer = (Viewer)object;
                SimpleValueProperty property = (SimpleValueProperty)ViewerProperties.input();
                SimplePropertyObservableValue observableValue = new SimplePropertyObservableValue(XWT.getRealm(), (Object)viewer, property);
                return new TypedViewerObservableValueDecorator((IObservableValue)observableValue, viewer);
            }
            if ("singleSelection".equals(propertyName)) {
                Viewer viewer = (Viewer)object;
                SimpleValueProperty property = (SimpleValueProperty)ViewerProperties.singleSelection();
                SimplePropertyObservableValue observableValue = new SimplePropertyObservableValue(XWT.getRealm(), (Object)viewer, property);
                return new TypedViewerObservableValueDecorator((IObservableValue)observableValue, viewer);
            }
            return JFaceXWTDataBinding.observePropertyValue((Viewer)object, propertyName, updateSourceTrigger);
        }
        if (object instanceof MenuItem) {
            if (ENABLED.equalsIgnoreCase(propertyName)) {
                return new MenuItemEnabledObservableValue((MenuItem)object);
            }
            if (SELECTION.equalsIgnoreCase(propertyName)) {
                return new MenuItemSelectionObservableValue((MenuItem)object);
            }
        } else if (object instanceof Control) {
            return JFaceXWTDataBinding.observePropertyValue((Control)object, propertyName, updateSourceTrigger);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean isControlValueProperty(Class<?> type, String propertyName) {
        if (TEXT.equalsIgnoreCase(propertyName)) {
            if (Text.class.isAssignableFrom(type)) {
                return true;
            }
            if (SWT.getVersion() == 3449 && Button.class.isAssignableFrom(type)) {
                return false;
            }
        }
        String getterName = "observe" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            Method method = SWTObservables.class.getMethod(getterName, CONTROL_ARGUMENT_TYPES);
            IMetaclass mateclass = XWT.getMetaclass(type);
            IProperty property = mateclass.findProperty(propertyName);
            if (method != null) return property instanceof EventProperty;
            Method[] methodArray = SWTObservables.class.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method element = methodArray[n2];
                if (element.getParameterTypes().length == 0 && element.getName().equalsIgnoreCase(getterName)) {
                    return true;
                }
                ++n2;
            }
            mateclass = XWT.getMetaclass(type);
            property = mateclass.findProperty(propertyName);
            return property instanceof EventProperty;
        }
        catch (Exception e) {
            throw new XWTException(e);
        }
    }

    protected static IObservableValue observePropertyValue(Control control, String propertyName, UpdateSourceTrigger updateSourceTrigger) {
        block21: {
            if (TEXT.equalsIgnoreCase(propertyName)) {
                ISWTObservableValue observableValue;
                if (control instanceof Text || control instanceof StyledText) {
                    int event = 0;
                    switch (updateSourceTrigger) {
                        case Default: {
                            event = 16;
                            break;
                        }
                        case LostFocus: {
                            event = 16;
                            break;
                        }
                        case PropertyChanged: {
                            event = 24;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("UpdateSourceTrigger of value " + updateSourceTrigger.name());
                        }
                    }
                    ISWTObservableValue observableValue2 = WidgetProperties.text((int)event).observe((Widget)control);
                    if (observableValue2 != null) {
                        return observableValue2;
                    }
                }
                if (SWT.getVersion() == 3449 && control instanceof Button) {
                    return null;
                }
                if (control instanceof DateTime && (observableValue = WidgetProperties.widgetSelection().observe((Widget)control)) != null) {
                    return observableValue;
                }
                try {
                    observableValue = WidgetProperties.text().observe((Widget)control);
                    if (observableValue != null) {
                        return observableValue;
                    }
                    break block21;
                }
                catch (IllegalArgumentException e) {
                    throw new XWTException(e);
                }
            }
            if (propertyName == null) {
                return null;
            }
            String getterName = "observe" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            try {
                IObservableValue observableValue;
                Method method = SWTObservables.class.getMethod(getterName, CONTROL_ARGUMENT_TYPES);
                if (method == null) {
                    Method[] methodArray = SWTObservables.class.getMethods();
                    int n = methodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Method element = methodArray[n2];
                        if (element.getParameterTypes().length == 0 && element.getName().equalsIgnoreCase(getterName)) {
                            method = element;
                            break;
                        }
                        ++n2;
                    }
                }
                if (method != null && (observableValue = (IObservableValue)method.invoke(null, control)) != null) {
                    return observableValue;
                }
            }
            catch (Exception e) {
                throw new XWTException(e);
            }
        }
        IMetaclass mateclass = XWT.getMetaclass(control);
        IProperty property = mateclass.findProperty(propertyName);
        if (property instanceof EventProperty) {
            return new EventPropertyObservableValue(control, (EventProperty)property);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean isViewerValueProperty(Class<?> viewerType, String property) {
        String getterName = "observe" + property.substring(0, 1).toUpperCase() + property.substring(1);
        try {
            Method method = ViewersObservables.class.getMethod(getterName, VIEWER_ARGUMENT_TYPES);
            if (method != null) return false;
            Method[] methodArray = ViewersObservables.class.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                Method element = methodArray[n2];
                if (element.getParameterTypes().length == 0 && element.getName().equalsIgnoreCase(getterName)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new XWTException(e);
        }
    }

    protected static IObservable observePropertyValue(Viewer viewer, String property, UpdateSourceTrigger updateSourceTrigger) {
        String getterName = "observe" + property.substring(0, 1).toUpperCase() + property.substring(1);
        try {
            IObservable observableValue;
            Method method = ViewersObservables.class.getMethod(getterName, VIEWER_ARGUMENT_TYPES);
            if (method == null) {
                Method[] methodArray = ViewersObservables.class.getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method element = methodArray[n2];
                    if (element.getParameterTypes().length == 0 && element.getName().equalsIgnoreCase(getterName)) {
                        method = element;
                        break;
                    }
                    ++n2;
                }
            }
            if (method != null && (observableValue = (IObservable)method.invoke(null, viewer)) != null) {
                return observableValue;
            }
        }
        catch (Exception e) {
            throw new XWTException(e);
        }
        return null;
    }
}

