/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.environment;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.environment.EnvironmentUtils;

public class DefaultProcessingEnvironment {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected Map procEnvironment;
    static /* synthetic */ Class class$java$lang$System;

    public synchronized Map getProcEnvironment() throws IOException {
        if (this.procEnvironment == null) {
            this.procEnvironment = this.createProcEnvironment();
        }
        Map copy = this.createEnvironmentMap();
        copy.putAll(this.procEnvironment);
        return copy;
    }

    protected Map createProcEnvironment() throws IOException {
        if (this.procEnvironment == null) {
            try {
                Method getenvs = (class$java$lang$System == null ? (class$java$lang$System = DefaultProcessingEnvironment.class$("java.lang.System")) : class$java$lang$System).getMethod("getenv", null);
                Map env = (Map)getenvs.invoke(null, (Object[])null);
                this.procEnvironment = this.createEnvironmentMap();
                this.procEnvironment.putAll(env);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        if (this.procEnvironment == null) {
            String line;
            this.procEnvironment = this.createEnvironmentMap();
            BufferedReader in = this.runProcEnvCommand();
            String var = null;
            while ((line = in.readLine()) != null) {
                if (line.indexOf(61) == -1) {
                    if (var == null) {
                        var = LINE_SEPARATOR + line;
                        continue;
                    }
                    var = var + LINE_SEPARATOR + line;
                    continue;
                }
                if (var != null) {
                    EnvironmentUtils.addVariableToEnvironment(this.procEnvironment, var);
                }
                var = line;
            }
            if (var != null) {
                EnvironmentUtils.addVariableToEnvironment(this.procEnvironment, var);
            }
        }
        return this.procEnvironment;
    }

    protected BufferedReader runProcEnvCommand() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DefaultExecutor exe = new DefaultExecutor();
        exe.setStreamHandler(new PumpStreamHandler(out));
        exe.execute(this.getProcEnvCommand());
        return new BufferedReader(new StringReader(this.toString(out)));
    }

    protected CommandLine getProcEnvCommand() {
        String executable;
        String[] arguments = null;
        if (OS.isFamilyOS2()) {
            executable = "cmd";
            arguments = new String[]{"/c", "set"};
        } else if (OS.isFamilyWindows()) {
            executable = OS.isFamilyWin9x() ? "command.com" : "cmd";
            arguments = new String[]{"/c", "set"};
        } else {
            executable = OS.isFamilyZOS() || OS.isFamilyUnix() ? (new File("/bin/env").canRead() ? "/bin/env" : (new File("/usr/bin/env").canRead() ? "/usr/bin/env" : "env")) : (OS.isFamilyNetware() || OS.isFamilyOS400() ? "env" : null);
        }
        CommandLine commandLine = null;
        if (executable != null) {
            commandLine = new CommandLine(executable);
            commandLine.addArguments(arguments);
        }
        return commandLine;
    }

    private String toString(ByteArrayOutputStream bos) {
        if (OS.isFamilyZOS()) {
            try {
                return bos.toString("Cp1047");
            }
            catch (UnsupportedEncodingException e) {
            }
        } else if (OS.isFamilyOS400()) {
            try {
                return bos.toString("Cp500");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return bos.toString();
    }

    private Map createEnvironmentMap() {
        if (OS.isFamilyWindows()) {
            return new TreeMap(new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    String key0 = (String)arg0;
                    String key1 = (String)arg1;
                    return key0.compareToIgnoreCase(key1);
                }
            });
        }
        return new HashMap();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

