/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.eclipse.dltk.internal.testing.ui.ITraceDisplay;
import org.eclipse.dltk.testing.ITestRunnerUI;

public class TextualTrace {
    public static final int LINE_TYPE_EXCEPTION = 1;
    public static final int LINE_TYPE_NORMAL = 0;
    public static final int LINE_TYPE_STACKFRAME = 2;
    private final String fTrace;
    private final ITestRunnerUI runnerUI;

    public TextualTrace(String trace, ITestRunnerUI runnerUI) {
        this.runnerUI = runnerUI;
        this.fTrace = runnerUI.canFilterStack() && runnerUI.isFilterStack() ? runnerUI.filterStackTrace(trace) : trace;
    }

    public void display(ITraceDisplay display, int maxLabelLength) {
        StringReader stringReader = new StringReader(this.fTrace);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String line = this.readLine(bufferedReader);
            if (line == null) {
                return;
            }
            this.displayWrappedLine(display, maxLabelLength, line, 1);
            while ((line = this.readLine(bufferedReader)) != null) {
                int type = this.runnerUI.isStackFrame(line) ? 2 : 0;
                this.displayWrappedLine(display, maxLabelLength, line, type);
            }
        }
        catch (IOException e) {
            display.addTraceLine(0, this.fTrace);
        }
    }

    private void displayWrappedLine(ITraceDisplay display, int maxLabelLength, String line, int type) {
        int labelLength = line.length();
        if (labelLength < maxLabelLength) {
            display.addTraceLine(type, line);
        } else {
            display.addTraceLine(type, line.substring(0, maxLabelLength));
            int offset = maxLabelLength;
            while (offset < labelLength) {
                int nextOffset = Math.min(labelLength, offset + maxLabelLength);
                display.addTraceLine(0, line.substring(offset, nextOffset));
                offset = nextOffset;
            }
        }
    }

    private String readLine(BufferedReader bufferedReader) throws IOException {
        String readLine = bufferedReader.readLine();
        return readLine == null ? null : readLine.replace('\t', ' ');
    }
}

