/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.core.internal.controllers;

import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.EEFTextDescription;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.AbstractEEFWidgetController;
import org.eclipse.eef.core.api.controllers.IEEFTextController;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public class EEFTextController
extends AbstractEEFWidgetController
implements IEEFTextController {
    private final EEFTextDescription description;
    private Consumer<Object> newValueConsumer;

    public EEFTextController(EEFTextDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        super(variableManager, interpreter, editingContextAdapter);
        this.description = description;
    }

    @Override
    public IStatus updateValue(String text) {
        return this.editingContextAdapter.performModelChange(() -> {
            String editExpression = this.description.getEditExpression();
            EAttribute eAttribute = EefPackage.Literals.EEF_TEXT_DESCRIPTION__EDIT_EXPRESSION;
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.putAll(this.variableManager.getVariables());
            variables.put("newValue", text);
            EvalFactory.of(this.interpreter, variables).logIfBlank(eAttribute).call(editExpression);
        });
    }

    @Override
    public void refresh() {
        super.refresh();
        String valueExpression = this.description.getValueExpression();
        Optional.ofNullable(this.newValueConsumer).ifPresent(consumer -> this.newEval().call(valueExpression, (Consumer<Object>)consumer));
    }

    @Override
    public void onNewValue(Consumer<Object> consumer) {
        this.newValueConsumer = consumer;
    }

    @Override
    public void removeNewValueConsumer() {
        this.newValueConsumer = null;
    }

    @Override
    protected EEFWidgetDescription getDescription() {
        return this.description;
    }
}

