/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.initParser;

import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jem.internal.proxy.initParser.Expression;
import org.eclipse.jem.internal.proxy.initParser.MessageArgument;
import org.eclipse.jem.internal.proxy.initParser.Statement;
import org.eclipse.jem.internal.proxy.initParser.Static;

public class ArrayArguments
extends Expression {
    Static fType;
    List arguments = new ArrayList(2);
    boolean argsClosed;
    boolean insideArgsOpenedParen;
    boolean insideArgsClosedParen;

    @Override
    public Expression push(char[] token, char tokenDelimiter) {
        if (!this.argsClosed) {
            Expression openArgument;
            if (this.arguments.size() > 0 && !(openArgument = (Expression)this.arguments.get(this.arguments.size() - 1)).isComplete()) {
                openArgument.push(token, tokenDelimiter);
                if (openArgument.isComplete() && tokenDelimiter == '}') {
                    this.argsClosed = true;
                }
                return this;
            }
            Expression newArgument = null;
            if (!this.insideArgsOpenedParen && tokenDelimiter == '(') {
                this.insideArgsOpenedParen = true;
                newArgument = new Statement(this.fClassLoader).push(token, tokenDelimiter);
                newArgument = new MessageArgument(newArgument);
                this.arguments.add(newArgument);
            }
            if (token.length > 0 || tokenDelimiter == '\"' || tokenDelimiter == '\'' || tokenDelimiter == '-') {
                newArgument = new Statement(this.fClassLoader).push(token, tokenDelimiter);
                newArgument = new MessageArgument(newArgument);
                this.arguments.add(newArgument);
            }
            if (!this.insideArgsOpenedParen && tokenDelimiter == '}') {
                this.argsClosed = true;
                return this;
            }
            if (this.insideArgsOpenedParen && tokenDelimiter == '}') {
                this.insideArgsClosedParen = true;
                this.argsClosed = true;
                return this;
            }
        }
        return this;
    }

    @Override
    public Object evaluate() throws Exception {
        Object result = Array.newInstance(this.fType.getPrimitiveTypeClass(), this.arguments.size());
        int i = 0;
        while (i < this.arguments.size()) {
            Object argumentValue = ((Expression)this.arguments.get(i)).evaluate();
            Array.set(result, i, argumentValue);
            ++i;
        }
        return result;
    }

    @Override
    public Class getTypeClass() throws Exception {
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.argsClosed;
    }

    @Override
    public boolean isPrimitive() throws Exception {
        return false;
    }

    public void setType(Static type) {
        this.fType = type;
    }

    public void contributeArgumentNumber(List argumentNumberList) {
        argumentNumberList.add(new Integer(this.arguments.size()));
        if (this.arguments.size() > 0) {
            Object firstArgument = this.arguments.get(0);
            boolean cfr_ignored_0 = firstArgument instanceof ArrayArguments;
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write("Args(");
        writer.write(new Integer(this.arguments.size()).toString());
        writer.write(")-");
        writer.write(this.arguments.toString());
        return writer.toString();
    }

    @Override
    protected String getTypeClassName() {
        return "";
    }
}

