/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.console;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IStreamMonitor;

public class DSPStreamMonitor
implements IFlushableStreamMonitor {
    private final ListenerList<IStreamListener> listeners = new ListenerList();
    private final StringBuilder stream = new StringBuilder();
    private boolean buffer;

    public String getContents() {
        return this.stream.toString();
    }

    public void addListener(IStreamListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IStreamListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void append(String text) {
        if (this.buffer && text != null) {
            this.stream.append(text);
        }
        this.notifyAppend(text);
    }

    public void notifyAppend(String text) {
        if (text == null) {
            return;
        }
        for (IStreamListener listener : this.listeners) {
            SafeRunner.run(() -> listener.streamAppended(text, (IStreamMonitor)this));
        }
    }

    public void flushContents() {
        this.stream.setLength(0);
        this.stream.trimToSize();
    }

    public void setBuffered(boolean buffer) {
        this.buffer = buffer;
    }

    public boolean isBuffered() {
        return this.buffer;
    }
}

