/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.core.lm;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.tcf.te.launch.core.lm.LaunchAttribute;
import org.eclipse.tcf.te.launch.core.lm.LaunchConfigHelper;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchAttribute;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchSpecification;
import org.eclipse.tcf.te.launch.core.nls.Messages;

public class LaunchSpecification
extends PlatformObject
implements ILaunchSpecification {
    private final Map<String, ILaunchAttribute> attributes = new Hashtable<String, ILaunchAttribute>();
    private final String typeId;
    private final String mode;
    private String launchConfigName;
    private String launchActionLabel;
    private boolean readOnly;
    private boolean valid = true;
    private String errorMessage = null;

    public LaunchSpecification(String typeId, String mode) {
        this.typeId = typeId;
        this.mode = mode;
        this.attributes.clear();
        this.setReadOnly(false);
    }

    @Override
    public String getLaunchConfigurationTypeId() {
        return this.typeId;
    }

    @Override
    public String getLaunchMode() {
        return this.mode;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public void addAttribute(String key, Object value) {
        this.addAttribute(key, value, false);
    }

    @Override
    public void addAttribute(String key, Object value, boolean createOnly) {
        Assert.isNotNull((Object)key);
        if (this.isReadOnly()) {
            return;
        }
        if (value != null) {
            this.attributes.put(key, new LaunchAttribute(key, value, createOnly));
        } else {
            this.attributes.remove(key);
        }
    }

    @Override
    public boolean hasAttribute(String key) {
        Assert.isNotNull((Object)key);
        return this.attributes.containsKey(key);
    }

    @Override
    public Object removeAttribute(String key) {
        Assert.isNotNull((Object)key);
        if (this.isReadOnly()) {
            return null;
        }
        return this.attributes.remove(key);
    }

    @Override
    public boolean isCreateOnlyAttribute(String key) {
        Assert.isNotNull((Object)key);
        ILaunchAttribute attribute = this.getAttribute(key);
        return attribute != null && attribute.isCreateOnlyAttribute();
    }

    @Override
    public Object getAttribute(String key, Object defaultValue) {
        Assert.isNotNull((Object)key);
        ILaunchAttribute attribute = this.getAttribute(key);
        return attribute != null && attribute.getValue() != null ? attribute.getValue() : defaultValue;
    }

    @Override
    public void clear() {
        if (this.isReadOnly()) {
            return;
        }
        this.attributes.clear();
    }

    @Override
    public int size() {
        return this.attributes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public ILaunchAttribute getAttribute(String key) {
        Assert.isNotNull((Object)key);
        return this.attributes.get(key);
    }

    @Override
    public ILaunchAttribute[] getAllAttributes() {
        return this.attributes.values().toArray(new ILaunchAttribute[this.attributes.size()]);
    }

    @Override
    public String getLaunchActionLabel() {
        return this.launchActionLabel;
    }

    @Override
    public String getLaunchConfigName() {
        return this.launchConfigName != null ? this.launchConfigName : Messages.DefaultLaunchManagerDelegate_defaultLaunchName;
    }

    @Override
    public void setLaunchActionLabel(String launchActionLabel) {
        this.launchActionLabel = launchActionLabel;
    }

    @Override
    public void setLaunchConfigName(String launchConfigName) {
        this.launchConfigName = LaunchConfigHelper.getUniqueLaunchConfigName(launchConfigName);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setIsValid(boolean valid) {
        this.valid = valid;
        if (valid) {
            this.errorMessage = null;
        }
    }

    @Override
    public String getErrorMessage() {
        if (!this.isValid()) {
            return this.errorMessage;
        }
        return null;
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

