/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers;

import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.Attributes;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandlerUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class SchedMigrateTaskHandler
extends KernelEventHandler {
    public SchedMigrateTaskHandler(IKernelAnalysisEventLayout layout) {
        super(layout);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) throws AttributeNotFoundException {
        Long tid = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.getLayout().fieldTid()});
        Long destCpu = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.getLayout().fieldDestCpu()});
        if (tid == null || destCpu == null) {
            return;
        }
        long t = event.getTimestamp().toNanos();
        String threadAttributeName = Attributes.buildThreadAttributeName(tid.intValue(), null);
        if (threadAttributeName == null) {
            return;
        }
        int threadNode = ss.getQuarkRelativeAndAdd(KernelEventHandlerUtils.getNodeThreads(ss), new String[]{threadAttributeName});
        ss.modifyAttribute(t, ProcessStatus.WAIT_CPU.getStateValue().unboxValue(), threadNode);
        int quark = ss.getQuarkRelativeAndAdd(threadNode, new String[]{"Current_cpu_rq"});
        ss.modifyAttribute(t, (Object)destCpu.intValue(), quark);
    }
}

