import { DebugProtocol } from 'vscode-debugprotocol';
import { ISetBreakpointsArgs, ILaunchRequestArgs, IAttachRequestArgs, IInternalStackTraceResponseBody, IScopesResponseBody, IInternalStackFrame } from '../debugAdapterInterfaces';
import { MappedPosition, ISourcePathDetails } from '../sourceMaps/sourceMap';
import { SourceMaps } from '../sourceMaps/sourceMaps';
import { ScriptContainer } from '../chrome/scripts';
export interface ISourceLocation {
    source: DebugProtocol.Source;
    line: number;
    column: number;
    isSourceMapped?: boolean;
}
/**
 * If sourcemaps are enabled, converts from source files on the client side to runtime files on the target side
 */
export declare class BaseSourceMapTransformer {
    protected _sourceMaps: SourceMaps;
    protected _scriptContainer: ScriptContainer;
    private _enableSourceMapCaching;
    private _requestSeqToSetBreakpointsArgs;
    private _allRuntimeScriptPaths;
    private _authoredPathsToMappedBPs;
    private _authoredPathsToClientBreakpointIds;
    protected _preLoad: Promise<void>;
    private _processingNewSourceMap;
    caseSensitivePaths: boolean;
    protected _isVSClient: boolean;
    constructor(sourceHandles: ScriptContainer);
    readonly sourceMaps: SourceMaps;
    isVSClient: boolean;
    launch(args: ILaunchRequestArgs): void;
    attach(args: IAttachRequestArgs): void;
    protected init(args: ILaunchRequestArgs | IAttachRequestArgs): void;
    clearTargetContext(): void;
    /**
     * Apply sourcemapping to the setBreakpoints request path/lines.
     * Returns true if completed successfully, and setBreakpoint should continue.
     */
    setBreakpoints(args: ISetBreakpointsArgs, requestSeq: number, ids?: number[]): {
        args: ISetBreakpointsArgs;
        ids: number[];
    };
    /**
     * Apply sourcemapping back to authored files from the response
     */
    setBreakpointsResponse(breakpoints: DebugProtocol.Breakpoint[], shouldFilter: boolean, requestSeq: number): DebugProtocol.Breakpoint[];
    /**
     * Apply sourcemapping to the stacktrace response
     */
    stackTraceResponse(response: IInternalStackTraceResponseBody): Promise<void>;
    fixSourceLocation(sourceLocation: ISourceLocation | IInternalStackFrame): Promise<void>;
    scriptParsed(pathToGenerated: string, originalUrlToGenerated: string | undefined, sourceMapURL: string): Promise<string[]>;
    breakpointResolved(bp: DebugProtocol.Breakpoint, scriptPath: string): void;
    scopesResponse(pathToGenerated: string, scopesResponse: IScopesResponseBody): void;
    private mapScopeLocations(pathToGenerated, scope);
    mapToGenerated(authoredPath: string, line: number, column: number): Promise<MappedPosition>;
    mapToAuthored(pathToGenerated: string, line: number, column: number): Promise<MappedPosition>;
    getGeneratedPathFromAuthoredPath(authoredPath: string): Promise<string>;
    allSources(pathToGenerated: string): Promise<string[]>;
    allSourcePathDetails(pathToGenerated: string): Promise<ISourcePathDetails[]>;
    private wait();
    private isRuntimeScript(scriptPath);
    private fixPathCasing(str);
}
