package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Immutable implementation of {@link ConfigCreateResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConfigCreateResponse.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableConfigCreateResponse
    implements ConfigCreateResponse {
  private final String id;

  private ImmutableConfigCreateResponse(String id) {
    this.id = id;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("ID")
  @Override
  public String id() {
    return id;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfigCreateResponse#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfigCreateResponse withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableConfigCreateResponse(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConfigCreateResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConfigCreateResponse
        && equalTo((ImmutableConfigCreateResponse) another);
  }

  private boolean equalTo(ImmutableConfigCreateResponse another) {
    return id.equals(another.id);
  }

  /**
   * Computes a hash code from attributes: {@code id}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConfigCreateResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ConfigCreateResponse{"
        + "id=" + id
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ConfigCreateResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConfigCreateResponse instance
   */
  public static ImmutableConfigCreateResponse copyOf(ConfigCreateResponse instance) {
    if (instance instanceof ImmutableConfigCreateResponse) {
      return (ImmutableConfigCreateResponse) instance;
    }
    return ImmutableConfigCreateResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConfigCreateResponse ImmutableConfigCreateResponse}.
   * <pre>
   * ImmutableConfigCreateResponse.builder()
   *    .id(String) // required {@link ConfigCreateResponse#id() id}
   *    .build();
   * </pre>
   * @return A new ImmutableConfigCreateResponse builder
   */
  public static ImmutableConfigCreateResponse.Builder builder() {
    return new ImmutableConfigCreateResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableConfigCreateResponse ImmutableConfigCreateResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private String id;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConfigCreateResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConfigCreateResponse instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.id());
      return this;
    }

    /**
     * Initializes the value for the {@link ConfigCreateResponse#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ID")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableConfigCreateResponse ImmutableConfigCreateResponse}.
     * @return An immutable instance of ConfigCreateResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConfigCreateResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableConfigCreateResponse(id);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build ConfigCreateResponse, some of required attributes are not set " + attributes;
    }
  }
}
