/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.internal.parser.ast.CST2ASTConverterWithDocumentationResolver;
import org.eclipse.acceleo.internal.parser.ast.IASTProvider;
import org.eclipse.acceleo.internal.parser.ast.ocl.OCLParser;
import org.eclipse.acceleo.internal.parser.cst.CSTParser;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.acceleo.internal.parser.documentation.IDocumentationProvider;
import org.eclipse.acceleo.parser.AcceleoFile;
import org.eclipse.acceleo.parser.AcceleoParserInfos;
import org.eclipse.acceleo.parser.AcceleoParserProblems;
import org.eclipse.acceleo.parser.AcceleoParserWarnings;
import org.eclipse.acceleo.parser.cst.CstFactory;
import org.eclipse.acceleo.parser.cst.Module;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.Environment;

public class AcceleoSourceBuffer
implements IASTProvider,
IDocumentationProvider {
    protected org.eclipse.acceleo.model.mtl.Module ast;
    protected CST2ASTConverterWithDocumentationResolver astCreator;
    private final AcceleoFile acceleoFile;
    private final StringBuffer buffer;
    private final List<Integer> lines = new ArrayList<Integer>();
    private final AcceleoParserProblems problems;
    private final AcceleoParserWarnings warnings;
    private final AcceleoParserInfos infos;
    private final String encoding;
    private Module cst;

    public AcceleoSourceBuffer(AcceleoFile acceleoFile) {
        this.acceleoFile = acceleoFile;
        this.buffer = FileContent.getFileContent(this.getFile());
        this.encoding = FileContent.getEncoding(this.buffer);
        this.problems = new AcceleoParserProblems();
        this.warnings = new AcceleoParserWarnings();
        this.infos = new AcceleoParserInfos();
        this.init();
    }

    public AcceleoSourceBuffer(File file) {
        this(new AcceleoFile(file, AcceleoFile.simpleModuleName(file)));
    }

    public AcceleoSourceBuffer(StringBuffer buffer) {
        this.acceleoFile = null;
        this.buffer = buffer;
        this.encoding = FileContent.getEncoding(buffer);
        this.problems = new AcceleoParserProblems();
        this.warnings = new AcceleoParserWarnings();
        this.infos = new AcceleoParserInfos();
        this.init();
    }

    private void init() {
        this.lines.add(0);
        int offset = 0;
        while (offset < this.buffer.length()) {
            if (this.buffer.charAt(offset) == '\n') {
                this.lines.add(offset);
            } else if (this.buffer.charAt(offset) == '\r') {
                this.lines.add(offset);
                if (this.buffer.length() > offset + 1 && this.buffer.charAt(offset + 1) == '\n') {
                    ++offset;
                }
            }
            ++offset;
        }
    }

    @Override
    public int getLineOfOffset(int offset) {
        int soughtLine = -1;
        if (offset == 0) {
            soughtLine = 0;
        }
        if (offset == this.buffer.length()) {
            soughtLine = this.lines.size();
        }
        if (soughtLine == -1) {
            int i = 0;
            while (i < this.lines.size()) {
                if (this.lines.get(i) > offset) {
                    soughtLine = i;
                    break;
                }
                ++i;
            }
        }
        if (soughtLine == -1) {
            soughtLine = this.lines.size();
        }
        return soughtLine;
    }

    public File getFile() {
        if (this.acceleoFile != null) {
            return this.acceleoFile.getMtlFile();
        }
        return null;
    }

    public AcceleoParserProblems getProblems() {
        return this.problems;
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public org.eclipse.acceleo.model.mtl.Module getAST() {
        return this.ast;
    }

    public Module getCST() {
        return this.cst;
    }

    @Deprecated
    public OCLParser getOCL() {
        if (this.astCreator != null) {
            return this.astCreator.getOCL();
        }
        return null;
    }

    public Environment<?, EClassifier, EOperation, EStructuralFeature, ?, ?, ?, ?, ?, ?, ?, ?> getOCLEnvironment() {
        if (this.astCreator != null && this.astCreator.getOCL() != null) {
            return this.astCreator.getOCL().getOCLEnvironment();
        }
        return null;
    }

    @Override
    public void createAST(Resource resource) {
        if (this.cst == null) {
            this.createCST();
        }
        this.astCreator = new CST2ASTConverterWithDocumentationResolver();
        this.astCreator.setASTProvider(this);
        this.astCreator.createAST(this.cst, resource);
        if (resource.getContents().size() > 0 && resource.getContents().get(0) instanceof org.eclipse.acceleo.model.mtl.Module) {
            this.ast = (org.eclipse.acceleo.model.mtl.Module)resource.getContents().get(0);
            if (this.ast != null && this.acceleoFile != null) {
                this.ast.setNsURI(this.acceleoFile.getFullModuleName());
            }
        } else {
            this.ast = null;
        }
    }

    public void refreshAST() {
        this.ast = null;
    }

    @Override
    public void resolveAST() {
        if (this.astCreator != null) {
            this.astCreator.resolveAST(this.cst);
        }
    }

    public void resolveAST(int posBegin, int posEnd) {
        if (this.astCreator != null) {
            this.astCreator.resolveAST(this.cst, posBegin, posEnd);
        }
    }

    @Override
    public void createCST() {
        this.ast = null;
        CSTParser parser = new CSTParser(this);
        this.cst = parser.parse();
        if (this.cst == null) {
            this.cst = CstFactory.eINSTANCE.createModule();
        }
    }

    @Override
    @Deprecated
    public void log(String message, int posBegin, int posEnd) {
        this.logProblem(message, posBegin, posEnd);
    }

    @Override
    public void logProblem(String message, int posBegin, int posEnd) {
        int[] pos = this.trim(posBegin, posEnd);
        int line = FileContent.lineNumber(this.buffer, pos[0]);
        this.problems.addProblem(this.getFile(), message, line, pos[0], pos[1]);
    }

    @Override
    public void logWarning(String message, int posBegin, int posEnd) {
        int[] pos = this.trim(posBegin, posEnd);
        int line = FileContent.lineNumber(this.buffer, pos[0]);
        this.warnings.addWarning(message, line, pos[0], pos[1]);
    }

    @Override
    public void logInfo(String message, int posBegin, int posEnd) {
        int[] pos = this.trim(posBegin, posEnd);
        int line = FileContent.lineNumber(this.buffer, pos[0]);
        this.infos.addInfo(message, line, pos[0], pos[1]);
    }

    public AcceleoParserWarnings getWarnings() {
        return this.warnings;
    }

    public AcceleoParserInfos getInfos() {
        return this.infos;
    }

    public int[] trim(int posBegin, int posEnd) {
        int b = posBegin < 0 ? 0 : posBegin;
        int e = posEnd < 0 || posEnd > this.buffer.length() ? this.buffer.length() : posEnd;
        while (b < e && Character.isWhitespace(this.buffer.charAt(b))) {
            ++b;
        }
        if (posEnd >= 0 && b != e || b + 1 >= this.buffer.length()) {
            while (e > b + 1 && Character.isWhitespace(this.buffer.charAt(e - 1))) {
                --e;
            }
        }
        return new int[]{b, e};
    }

    @Override
    public void resolveASTDocumentation() {
        if (this.astCreator != null && this.ast != null) {
            this.astCreator.resolveASTDocumentation(this.ast, this.buffer);
        }
    }
}

