/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.doxygen.internal.core;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.cdt.doxygen.DoxygenMetadata;
import org.eclipse.cdt.doxygen.DoxygenOptions;
import org.eclipse.cdt.doxygen.core.DoxygenConfiguration;
import org.eclipse.cdt.doxygen.core.DoxygenPreferences;
import org.eclipse.cdt.doxygen.internal.core.DoxygenCoreMessages;
import org.eclipse.cdt.doxygen.internal.core.DoxygenMetadataDefaults;
import org.eclipse.cdt.doxygen.internal.core.DoxygenOptionsAccess;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceMetadataStore;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.runtime.preferences.OsgiPreferenceMetadataStore;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.component.annotations.Component;

@Component
public class DoxygenPreferenceAccess
implements DoxygenConfiguration,
DoxygenPreferences {
    private final DoxygenMetadata doxygenMetadata = new DoxygenMetadataDefaults();

    @Override
    public IPreferenceMetadataStore workspaceStorage() {
        return new OsgiPreferenceMetadataStore(this.preferences(InstanceScope.INSTANCE));
    }

    @Override
    public IPreferenceMetadataStore projectStorage(IProject project) {
        Objects.requireNonNull(DoxygenCoreMessages.DoxygenPreferenceAccess_e_null_project);
        return new OsgiPreferenceMetadataStore(this.preferences((IScopeContext)new ProjectScope(project)));
    }

    @Override
    public DoxygenMetadata metadata() {
        return this.doxygenMetadata;
    }

    @Override
    public DoxygenOptions workspaceOptions() {
        return new DoxygenOptionsAccess(this.workspaceStorage(), this.doxygenMetadata);
    }

    @Override
    public DoxygenOptions projectOptions(IProject project) {
        Objects.requireNonNull(DoxygenCoreMessages.DoxygenPreferenceAccess_e_null_project);
        return new DoxygenOptionsAccess(this.projectStorage(project), this.doxygenMetadata);
    }

    private IEclipsePreferences preferences(IScopeContext scope) {
        return Optional.ofNullable(scope.getNode(this.nodeQualifier())).map(n -> n.node(this.nodePath())).filter(IEclipsePreferences.class::isInstance).map(IEclipsePreferences.class::cast).orElseThrow(() -> new IllegalStateException(NLS.bind((String)DoxygenCoreMessages.DoxygenPreferenceAccess_e_get_preferences, (Object)this.nodeQualifier(), (Object)this.nodePath())));
    }

    private String nodeQualifier() {
        return "org.eclipse.cdt.core";
    }

    private String nodePath() {
        return "doxygen";
    }
}

