/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.dltk.dbgp.IDbgpProperty;
import org.eclipse.dltk.dbgp.commands.IDbgpCoreCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.model.IRefreshableScriptVariable;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.core.model.IScriptVariable;
import org.eclipse.dltk.internal.debug.core.model.DebugEventHelper;
import org.eclipse.dltk.internal.debug.core.model.Messages;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugElement;
import org.eclipse.dltk.internal.debug.core.model.ScriptStackFrame;
import org.eclipse.dltk.internal.debug.core.model.ScriptThread;
import org.eclipse.dltk.internal.debug.core.model.ScriptValue;
import org.eclipse.dltk.internal.debug.core.model.StrUtils;

public class ScriptVariable
extends ScriptDebugElement
implements IScriptVariable,
IRefreshableScriptVariable {
    private final IScriptStackFrame frame;
    private final String name;
    private IDbgpProperty property;
    private IValue value;
    private boolean isValueChanged = false;

    public ScriptVariable(IScriptStackFrame frame, String name, IDbgpProperty property) {
        this.frame = frame;
        this.name = name;
        this.property = property;
    }

    public IDebugTarget getDebugTarget() {
        return this.frame.getDebugTarget();
    }

    public synchronized IValue getValue() throws DebugException {
        if (this.value == null) {
            this.value = ScriptValue.createValue(this.frame, this.property);
        }
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.property.getType();
    }

    public boolean hasValueChanged() throws DebugException {
        return this.isValueChanged;
    }

    public synchronized void setValue(String expression) throws DebugException {
        try {
            if (!(!"String".equals(this.property.getType()) || expression.startsWith("'") && expression.endsWith("'") || expression.startsWith("\"") && expression.endsWith("\""))) {
                expression = "\"" + expression.replaceAll("\\\"", "\\\\\"") + "\"";
            }
            if (this.getCoreCommands().setProperty(this.property.getEvalName(), this.frame.getLevel(), expression)) {
                this.clearEvaluationManagerCache();
                this.update();
            }
        }
        catch (DbgpException e) {
            throw this.wrapDbgpException(Messages.ScriptVariable_cantAssignVariable, e);
        }
    }

    private IDbgpCoreCommands getCoreCommands() {
        return ((IScriptThread)this.frame.getThread()).getDbgpSession().getCoreCommands();
    }

    private void clearEvaluationManagerCache() {
        ScriptThread thread = (ScriptThread)this.frame.getThread();
        thread.notifyModified();
    }

    private void update() throws DbgpException {
        this.value = null;
        String name = this.property.getEvalName();
        this.property = this.getCoreCommands().getProperty(name, this.frame.getLevel());
        DebugEventHelper.fireChangeEvent(this);
    }

    public void setValue(IValue value) throws DebugException {
        this.setValue(value.getValueString());
    }

    public boolean supportsValueModification() {
        return !this.property.isConstant();
    }

    public boolean verifyValue(String expression) throws DebugException {
        return expression != null;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return this.verifyValue(value.getValueString());
    }

    @Override
    public boolean isConstant() {
        return this.property.isConstant();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getId() {
        return this.property.getKey();
    }

    @Override
    public IVariable refreshVariable(IVariable newVariable) throws DebugException {
        if (newVariable instanceof ScriptVariable) {
            ScriptVariable v = (ScriptVariable)newVariable;
            if (this.property.hasChildren() && v.property.hasChildren()) {
                this.isValueChanged = false;
                if (this.value != null && ((ScriptValue)this.value).hasChildrenValuesLoaded()) {
                    ScriptStackFrame.refreshVariables(v.getValue().getVariables(), ((ScriptValue)this.value).variables);
                }
            }
            this.isValueChanged = !ScriptVariable.equals(this.property, v.property);
            this.value = v.value;
            this.property = v.property;
            return this;
        }
        return newVariable;
    }

    private static boolean equals(IDbgpProperty p1, IDbgpProperty p2) {
        if (p1.hasChildren() != p2.hasChildren()) {
            return false;
        }
        if (!StrUtils.equals(p1.getType(), p2.getType())) {
            return false;
        }
        if (!StrUtils.equals(p1.getValue(), p2.getValue())) {
            return false;
        }
        if (StrUtils.isNotEmpty(p1.getKey()) && StrUtils.isNotEmpty(p2.getKey())) {
            return p1.getKey().equals(p2.getKey());
        }
        return true;
    }
}

