package org.eclipse.gef.dot.internal.ide.language.contentassist.antlr.internal;
import java.util.Map;
import java.util.HashMap;

import java.io.InputStream;
import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.DFA;
import org.eclipse.gef.dot.internal.language.services.DotRecordLabelGrammarAccess;



import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class InternalDotRecordLabelParser extends AbstractInternalContentAssistParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "LessThanSign", "GreaterThanSign", "LeftCurlyBracket", "VerticalLine", "RightCurlyBracket", "RULE_NON_WS_STRING", "RULE_WS"
    };
    public static final int GreaterThanSign=5;
    public static final int RULE_WS=10;
    public static final int LeftCurlyBracket=6;
    public static final int LessThanSign=4;
    public static final int VerticalLine=7;
    public static final int RULE_NON_WS_STRING=9;
    public static final int RightCurlyBracket=8;
    public static final int EOF=-1;

    // delegates
    // delegators


        public InternalDotRecordLabelParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public InternalDotRecordLabelParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return InternalDotRecordLabelParser.tokenNames; }
    public String getGrammarFileName() { return "InternalDotRecordLabelParser.g"; }


    	private DotRecordLabelGrammarAccess grammarAccess;
    	private final Map<String, String> tokenNameToValue = new HashMap<String, String>();
    	
    	{
    		tokenNameToValue.put("LessThanSign", "'<'");
    		tokenNameToValue.put("GreaterThanSign", "'>'");
    		tokenNameToValue.put("LeftCurlyBracket", "'{'");
    		tokenNameToValue.put("VerticalLine", "'|'");
    		tokenNameToValue.put("RightCurlyBracket", "'}'");
    	}

    	public void setGrammarAccess(DotRecordLabelGrammarAccess grammarAccess) {
    		this.grammarAccess = grammarAccess;
    	}

    	@Override
    	protected Grammar getGrammar() {
    		return grammarAccess.getGrammar();
    	}

    	@Override
    	protected String getValueForTokenName(String tokenName) {
    		String result = tokenNameToValue.get(tokenName);
    		if (result == null)
    			result = tokenName;
    		return result;
    	}



    // $ANTLR start "entryRuleRLabel"
    // InternalDotRecordLabelParser.g:60:1: entryRuleRLabel : ruleRLabel EOF ;
    public final void entryRuleRLabel() throws RecognitionException {
        try {
            // InternalDotRecordLabelParser.g:61:1: ( ruleRLabel EOF )
            // InternalDotRecordLabelParser.g:62:1: ruleRLabel EOF
            {
             before(grammarAccess.getRLabelRule()); 
            pushFollow(FOLLOW_1);
            ruleRLabel();

            state._fsp--;

             after(grammarAccess.getRLabelRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleRLabel"


    // $ANTLR start "ruleRLabel"
    // InternalDotRecordLabelParser.g:69:1: ruleRLabel : ( ( rule__RLabel__Group__0 ) ) ;
    public final void ruleRLabel() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:73:2: ( ( ( rule__RLabel__Group__0 ) ) )
            // InternalDotRecordLabelParser.g:74:2: ( ( rule__RLabel__Group__0 ) )
            {
            // InternalDotRecordLabelParser.g:74:2: ( ( rule__RLabel__Group__0 ) )
            // InternalDotRecordLabelParser.g:75:3: ( rule__RLabel__Group__0 )
            {
             before(grammarAccess.getRLabelAccess().getGroup()); 
            // InternalDotRecordLabelParser.g:76:3: ( rule__RLabel__Group__0 )
            // InternalDotRecordLabelParser.g:76:4: rule__RLabel__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__RLabel__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getRLabelAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleRLabel"


    // $ANTLR start "entryRuleField"
    // InternalDotRecordLabelParser.g:85:1: entryRuleField : ruleField EOF ;
    public final void entryRuleField() throws RecognitionException {
        try {
            // InternalDotRecordLabelParser.g:86:1: ( ruleField EOF )
            // InternalDotRecordLabelParser.g:87:1: ruleField EOF
            {
             before(grammarAccess.getFieldRule()); 
            pushFollow(FOLLOW_1);
            ruleField();

            state._fsp--;

             after(grammarAccess.getFieldRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleField"


    // $ANTLR start "ruleField"
    // InternalDotRecordLabelParser.g:94:1: ruleField : ( ( rule__Field__Alternatives ) ) ;
    public final void ruleField() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:98:2: ( ( ( rule__Field__Alternatives ) ) )
            // InternalDotRecordLabelParser.g:99:2: ( ( rule__Field__Alternatives ) )
            {
            // InternalDotRecordLabelParser.g:99:2: ( ( rule__Field__Alternatives ) )
            // InternalDotRecordLabelParser.g:100:3: ( rule__Field__Alternatives )
            {
             before(grammarAccess.getFieldAccess().getAlternatives()); 
            // InternalDotRecordLabelParser.g:101:3: ( rule__Field__Alternatives )
            // InternalDotRecordLabelParser.g:101:4: rule__Field__Alternatives
            {
            pushFollow(FOLLOW_2);
            rule__Field__Alternatives();

            state._fsp--;


            }

             after(grammarAccess.getFieldAccess().getAlternatives()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleField"


    // $ANTLR start "entryRuleFieldID"
    // InternalDotRecordLabelParser.g:110:1: entryRuleFieldID : ruleFieldID EOF ;
    public final void entryRuleFieldID() throws RecognitionException {
        try {
            // InternalDotRecordLabelParser.g:111:1: ( ruleFieldID EOF )
            // InternalDotRecordLabelParser.g:112:1: ruleFieldID EOF
            {
             before(grammarAccess.getFieldIDRule()); 
            pushFollow(FOLLOW_1);
            ruleFieldID();

            state._fsp--;

             after(grammarAccess.getFieldIDRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleFieldID"


    // $ANTLR start "ruleFieldID"
    // InternalDotRecordLabelParser.g:119:1: ruleFieldID : ( ( rule__FieldID__Group__0 ) ) ;
    public final void ruleFieldID() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:123:2: ( ( ( rule__FieldID__Group__0 ) ) )
            // InternalDotRecordLabelParser.g:124:2: ( ( rule__FieldID__Group__0 ) )
            {
            // InternalDotRecordLabelParser.g:124:2: ( ( rule__FieldID__Group__0 ) )
            // InternalDotRecordLabelParser.g:125:3: ( rule__FieldID__Group__0 )
            {
             before(grammarAccess.getFieldIDAccess().getGroup()); 
            // InternalDotRecordLabelParser.g:126:3: ( rule__FieldID__Group__0 )
            // InternalDotRecordLabelParser.g:126:4: rule__FieldID__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__FieldID__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getFieldIDAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleFieldID"


    // $ANTLR start "entryRuleString"
    // InternalDotRecordLabelParser.g:135:1: entryRuleString : ruleString EOF ;
    public final void entryRuleString() throws RecognitionException {
        try {
            // InternalDotRecordLabelParser.g:136:1: ( ruleString EOF )
            // InternalDotRecordLabelParser.g:137:1: ruleString EOF
            {
             before(grammarAccess.getStringRule()); 
            pushFollow(FOLLOW_1);
            ruleString();

            state._fsp--;

             after(grammarAccess.getStringRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleString"


    // $ANTLR start "ruleString"
    // InternalDotRecordLabelParser.g:144:1: ruleString : ( ( ( RULE_NON_WS_STRING ) ) ( ( RULE_NON_WS_STRING )* ) ) ;
    public final void ruleString() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:148:2: ( ( ( ( RULE_NON_WS_STRING ) ) ( ( RULE_NON_WS_STRING )* ) ) )
            // InternalDotRecordLabelParser.g:149:2: ( ( ( RULE_NON_WS_STRING ) ) ( ( RULE_NON_WS_STRING )* ) )
            {
            // InternalDotRecordLabelParser.g:149:2: ( ( ( RULE_NON_WS_STRING ) ) ( ( RULE_NON_WS_STRING )* ) )
            // InternalDotRecordLabelParser.g:150:3: ( ( RULE_NON_WS_STRING ) ) ( ( RULE_NON_WS_STRING )* )
            {
            // InternalDotRecordLabelParser.g:150:3: ( ( RULE_NON_WS_STRING ) )
            // InternalDotRecordLabelParser.g:151:4: ( RULE_NON_WS_STRING )
            {
             before(grammarAccess.getStringAccess().getNON_WS_STRINGTerminalRuleCall()); 
            // InternalDotRecordLabelParser.g:152:4: ( RULE_NON_WS_STRING )
            // InternalDotRecordLabelParser.g:152:5: RULE_NON_WS_STRING
            {
            match(input,RULE_NON_WS_STRING,FOLLOW_3); 

            }

             after(grammarAccess.getStringAccess().getNON_WS_STRINGTerminalRuleCall()); 

            }

            // InternalDotRecordLabelParser.g:155:3: ( ( RULE_NON_WS_STRING )* )
            // InternalDotRecordLabelParser.g:156:4: ( RULE_NON_WS_STRING )*
            {
             before(grammarAccess.getStringAccess().getNON_WS_STRINGTerminalRuleCall()); 
            // InternalDotRecordLabelParser.g:157:4: ( RULE_NON_WS_STRING )*
            loop1:
            do {
                int alt1=2;
                int LA1_0 = input.LA(1);

                if ( (LA1_0==RULE_NON_WS_STRING) ) {
                    alt1=1;
                }


                switch (alt1) {
            	case 1 :
            	    // InternalDotRecordLabelParser.g:157:5: RULE_NON_WS_STRING
            	    {
            	    match(input,RULE_NON_WS_STRING,FOLLOW_3); 

            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);

             after(grammarAccess.getStringAccess().getNON_WS_STRINGTerminalRuleCall()); 

            }


            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleString"


    // $ANTLR start "rule__Field__Alternatives"
    // InternalDotRecordLabelParser.g:166:1: rule__Field__Alternatives : ( ( ( rule__Field__FieldIDAssignment_0 ) ) | ( ( rule__Field__Group_1__0 ) ) );
    public final void rule__Field__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:170:1: ( ( ( rule__Field__FieldIDAssignment_0 ) ) | ( ( rule__Field__Group_1__0 ) ) )
            int alt2=2;
            int LA2_0 = input.LA(1);

            if ( (LA2_0==EOF||LA2_0==LessThanSign||(LA2_0>=VerticalLine && LA2_0<=RULE_NON_WS_STRING)) ) {
                alt2=1;
            }
            else if ( (LA2_0==LeftCurlyBracket) ) {
                alt2=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 2, 0, input);

                throw nvae;
            }
            switch (alt2) {
                case 1 :
                    // InternalDotRecordLabelParser.g:171:2: ( ( rule__Field__FieldIDAssignment_0 ) )
                    {
                    // InternalDotRecordLabelParser.g:171:2: ( ( rule__Field__FieldIDAssignment_0 ) )
                    // InternalDotRecordLabelParser.g:172:3: ( rule__Field__FieldIDAssignment_0 )
                    {
                     before(grammarAccess.getFieldAccess().getFieldIDAssignment_0()); 
                    // InternalDotRecordLabelParser.g:173:3: ( rule__Field__FieldIDAssignment_0 )
                    // InternalDotRecordLabelParser.g:173:4: rule__Field__FieldIDAssignment_0
                    {
                    pushFollow(FOLLOW_2);
                    rule__Field__FieldIDAssignment_0();

                    state._fsp--;


                    }

                     after(grammarAccess.getFieldAccess().getFieldIDAssignment_0()); 

                    }


                    }
                    break;
                case 2 :
                    // InternalDotRecordLabelParser.g:177:2: ( ( rule__Field__Group_1__0 ) )
                    {
                    // InternalDotRecordLabelParser.g:177:2: ( ( rule__Field__Group_1__0 ) )
                    // InternalDotRecordLabelParser.g:178:3: ( rule__Field__Group_1__0 )
                    {
                     before(grammarAccess.getFieldAccess().getGroup_1()); 
                    // InternalDotRecordLabelParser.g:179:3: ( rule__Field__Group_1__0 )
                    // InternalDotRecordLabelParser.g:179:4: rule__Field__Group_1__0
                    {
                    pushFollow(FOLLOW_2);
                    rule__Field__Group_1__0();

                    state._fsp--;


                    }

                     after(grammarAccess.getFieldAccess().getGroup_1()); 

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Field__Alternatives"


    // $ANTLR start "rule__RLabel__Group__0"
    // InternalDotRecordLabelParser.g:187:1: rule__RLabel__Group__0 : rule__RLabel__Group__0__Impl rule__RLabel__Group__1 ;
    public final void rule__RLabel__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:191:1: ( rule__RLabel__Group__0__Impl rule__RLabel__Group__1 )
            // InternalDotRecordLabelParser.g:192:2: rule__RLabel__Group__0__Impl rule__RLabel__Group__1
            {
            pushFollow(FOLLOW_4);
            rule__RLabel__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__RLabel__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RLabel__Group__0"


    // $ANTLR start "rule__RLabel__Group__0__Impl"
    // InternalDotRecordLabelParser.g:199:1: rule__RLabel__Group__0__Impl : ( ( rule__RLabel__FieldsAssignment_0 ) ) ;
    public final void rule__RLabel__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:203:1: ( ( ( rule__RLabel__FieldsAssignment_0 ) ) )
            // InternalDotRecordLabelParser.g:204:1: ( ( rule__RLabel__FieldsAssignment_0 ) )
            {
            // InternalDotRecordLabelParser.g:204:1: ( ( rule__RLabel__FieldsAssignment_0 ) )
            // InternalDotRecordLabelParser.g:205:2: ( rule__RLabel__FieldsAssignment_0 )
            {
             before(grammarAccess.getRLabelAccess().getFieldsAssignment_0()); 
            // InternalDotRecordLabelParser.g:206:2: ( rule__RLabel__FieldsAssignment_0 )
            // InternalDotRecordLabelParser.g:206:3: rule__RLabel__FieldsAssignment_0
            {
            pushFollow(FOLLOW_2);
            rule__RLabel__FieldsAssignment_0();

            state._fsp--;


            }

             after(grammarAccess.getRLabelAccess().getFieldsAssignment_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RLabel__Group__0__Impl"


    // $ANTLR start "rule__RLabel__Group__1"
    // InternalDotRecordLabelParser.g:214:1: rule__RLabel__Group__1 : rule__RLabel__Group__1__Impl ;
    public final void rule__RLabel__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:218:1: ( rule__RLabel__Group__1__Impl )
            // InternalDotRecordLabelParser.g:219:2: rule__RLabel__Group__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__RLabel__Group__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RLabel__Group__1"


    // $ANTLR start "rule__RLabel__Group__1__Impl"
    // InternalDotRecordLabelParser.g:225:1: rule__RLabel__Group__1__Impl : ( ( rule__RLabel__Group_1__0 )* ) ;
    public final void rule__RLabel__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:229:1: ( ( ( rule__RLabel__Group_1__0 )* ) )
            // InternalDotRecordLabelParser.g:230:1: ( ( rule__RLabel__Group_1__0 )* )
            {
            // InternalDotRecordLabelParser.g:230:1: ( ( rule__RLabel__Group_1__0 )* )
            // InternalDotRecordLabelParser.g:231:2: ( rule__RLabel__Group_1__0 )*
            {
             before(grammarAccess.getRLabelAccess().getGroup_1()); 
            // InternalDotRecordLabelParser.g:232:2: ( rule__RLabel__Group_1__0 )*
            loop3:
            do {
                int alt3=2;
                int LA3_0 = input.LA(1);

                if ( (LA3_0==VerticalLine) ) {
                    alt3=1;
                }


                switch (alt3) {
            	case 1 :
            	    // InternalDotRecordLabelParser.g:232:3: rule__RLabel__Group_1__0
            	    {
            	    pushFollow(FOLLOW_5);
            	    rule__RLabel__Group_1__0();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop3;
                }
            } while (true);

             after(grammarAccess.getRLabelAccess().getGroup_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RLabel__Group__1__Impl"


    // $ANTLR start "rule__RLabel__Group_1__0"
    // InternalDotRecordLabelParser.g:241:1: rule__RLabel__Group_1__0 : rule__RLabel__Group_1__0__Impl rule__RLabel__Group_1__1 ;
    public final void rule__RLabel__Group_1__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:245:1: ( rule__RLabel__Group_1__0__Impl rule__RLabel__Group_1__1 )
            // InternalDotRecordLabelParser.g:246:2: rule__RLabel__Group_1__0__Impl rule__RLabel__Group_1__1
            {
            pushFollow(FOLLOW_6);
            rule__RLabel__Group_1__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__RLabel__Group_1__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RLabel__Group_1__0"


    // $ANTLR start "rule__RLabel__Group_1__0__Impl"
    // InternalDotRecordLabelParser.g:253:1: rule__RLabel__Group_1__0__Impl : ( VerticalLine ) ;
    public final void rule__RLabel__Group_1__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:257:1: ( ( VerticalLine ) )
            // InternalDotRecordLabelParser.g:258:1: ( VerticalLine )
            {
            // InternalDotRecordLabelParser.g:258:1: ( VerticalLine )
            // InternalDotRecordLabelParser.g:259:2: VerticalLine
            {
             before(grammarAccess.getRLabelAccess().getVerticalLineKeyword_1_0()); 
            match(input,VerticalLine,FOLLOW_2); 
             after(grammarAccess.getRLabelAccess().getVerticalLineKeyword_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RLabel__Group_1__0__Impl"


    // $ANTLR start "rule__RLabel__Group_1__1"
    // InternalDotRecordLabelParser.g:268:1: rule__RLabel__Group_1__1 : rule__RLabel__Group_1__1__Impl ;
    public final void rule__RLabel__Group_1__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:272:1: ( rule__RLabel__Group_1__1__Impl )
            // InternalDotRecordLabelParser.g:273:2: rule__RLabel__Group_1__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__RLabel__Group_1__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RLabel__Group_1__1"


    // $ANTLR start "rule__RLabel__Group_1__1__Impl"
    // InternalDotRecordLabelParser.g:279:1: rule__RLabel__Group_1__1__Impl : ( ( rule__RLabel__FieldsAssignment_1_1 ) ) ;
    public final void rule__RLabel__Group_1__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:283:1: ( ( ( rule__RLabel__FieldsAssignment_1_1 ) ) )
            // InternalDotRecordLabelParser.g:284:1: ( ( rule__RLabel__FieldsAssignment_1_1 ) )
            {
            // InternalDotRecordLabelParser.g:284:1: ( ( rule__RLabel__FieldsAssignment_1_1 ) )
            // InternalDotRecordLabelParser.g:285:2: ( rule__RLabel__FieldsAssignment_1_1 )
            {
             before(grammarAccess.getRLabelAccess().getFieldsAssignment_1_1()); 
            // InternalDotRecordLabelParser.g:286:2: ( rule__RLabel__FieldsAssignment_1_1 )
            // InternalDotRecordLabelParser.g:286:3: rule__RLabel__FieldsAssignment_1_1
            {
            pushFollow(FOLLOW_2);
            rule__RLabel__FieldsAssignment_1_1();

            state._fsp--;


            }

             after(grammarAccess.getRLabelAccess().getFieldsAssignment_1_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RLabel__Group_1__1__Impl"


    // $ANTLR start "rule__Field__Group_1__0"
    // InternalDotRecordLabelParser.g:295:1: rule__Field__Group_1__0 : rule__Field__Group_1__0__Impl rule__Field__Group_1__1 ;
    public final void rule__Field__Group_1__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:299:1: ( rule__Field__Group_1__0__Impl rule__Field__Group_1__1 )
            // InternalDotRecordLabelParser.g:300:2: rule__Field__Group_1__0__Impl rule__Field__Group_1__1
            {
            pushFollow(FOLLOW_6);
            rule__Field__Group_1__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Field__Group_1__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Field__Group_1__0"


    // $ANTLR start "rule__Field__Group_1__0__Impl"
    // InternalDotRecordLabelParser.g:307:1: rule__Field__Group_1__0__Impl : ( LeftCurlyBracket ) ;
    public final void rule__Field__Group_1__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:311:1: ( ( LeftCurlyBracket ) )
            // InternalDotRecordLabelParser.g:312:1: ( LeftCurlyBracket )
            {
            // InternalDotRecordLabelParser.g:312:1: ( LeftCurlyBracket )
            // InternalDotRecordLabelParser.g:313:2: LeftCurlyBracket
            {
             before(grammarAccess.getFieldAccess().getLeftCurlyBracketKeyword_1_0()); 
            match(input,LeftCurlyBracket,FOLLOW_2); 
             after(grammarAccess.getFieldAccess().getLeftCurlyBracketKeyword_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Field__Group_1__0__Impl"


    // $ANTLR start "rule__Field__Group_1__1"
    // InternalDotRecordLabelParser.g:322:1: rule__Field__Group_1__1 : rule__Field__Group_1__1__Impl rule__Field__Group_1__2 ;
    public final void rule__Field__Group_1__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:326:1: ( rule__Field__Group_1__1__Impl rule__Field__Group_1__2 )
            // InternalDotRecordLabelParser.g:327:2: rule__Field__Group_1__1__Impl rule__Field__Group_1__2
            {
            pushFollow(FOLLOW_7);
            rule__Field__Group_1__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Field__Group_1__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Field__Group_1__1"


    // $ANTLR start "rule__Field__Group_1__1__Impl"
    // InternalDotRecordLabelParser.g:334:1: rule__Field__Group_1__1__Impl : ( ( rule__Field__LabelAssignment_1_1 ) ) ;
    public final void rule__Field__Group_1__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:338:1: ( ( ( rule__Field__LabelAssignment_1_1 ) ) )
            // InternalDotRecordLabelParser.g:339:1: ( ( rule__Field__LabelAssignment_1_1 ) )
            {
            // InternalDotRecordLabelParser.g:339:1: ( ( rule__Field__LabelAssignment_1_1 ) )
            // InternalDotRecordLabelParser.g:340:2: ( rule__Field__LabelAssignment_1_1 )
            {
             before(grammarAccess.getFieldAccess().getLabelAssignment_1_1()); 
            // InternalDotRecordLabelParser.g:341:2: ( rule__Field__LabelAssignment_1_1 )
            // InternalDotRecordLabelParser.g:341:3: rule__Field__LabelAssignment_1_1
            {
            pushFollow(FOLLOW_2);
            rule__Field__LabelAssignment_1_1();

            state._fsp--;


            }

             after(grammarAccess.getFieldAccess().getLabelAssignment_1_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Field__Group_1__1__Impl"


    // $ANTLR start "rule__Field__Group_1__2"
    // InternalDotRecordLabelParser.g:349:1: rule__Field__Group_1__2 : rule__Field__Group_1__2__Impl ;
    public final void rule__Field__Group_1__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:353:1: ( rule__Field__Group_1__2__Impl )
            // InternalDotRecordLabelParser.g:354:2: rule__Field__Group_1__2__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Field__Group_1__2__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Field__Group_1__2"


    // $ANTLR start "rule__Field__Group_1__2__Impl"
    // InternalDotRecordLabelParser.g:360:1: rule__Field__Group_1__2__Impl : ( RightCurlyBracket ) ;
    public final void rule__Field__Group_1__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:364:1: ( ( RightCurlyBracket ) )
            // InternalDotRecordLabelParser.g:365:1: ( RightCurlyBracket )
            {
            // InternalDotRecordLabelParser.g:365:1: ( RightCurlyBracket )
            // InternalDotRecordLabelParser.g:366:2: RightCurlyBracket
            {
             before(grammarAccess.getFieldAccess().getRightCurlyBracketKeyword_1_2()); 
            match(input,RightCurlyBracket,FOLLOW_2); 
             after(grammarAccess.getFieldAccess().getRightCurlyBracketKeyword_1_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Field__Group_1__2__Impl"


    // $ANTLR start "rule__FieldID__Group__0"
    // InternalDotRecordLabelParser.g:376:1: rule__FieldID__Group__0 : rule__FieldID__Group__0__Impl rule__FieldID__Group__1 ;
    public final void rule__FieldID__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:380:1: ( rule__FieldID__Group__0__Impl rule__FieldID__Group__1 )
            // InternalDotRecordLabelParser.g:381:2: rule__FieldID__Group__0__Impl rule__FieldID__Group__1
            {
            pushFollow(FOLLOW_8);
            rule__FieldID__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__FieldID__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__FieldID__Group__0"


    // $ANTLR start "rule__FieldID__Group__0__Impl"
    // InternalDotRecordLabelParser.g:388:1: rule__FieldID__Group__0__Impl : ( () ) ;
    public final void rule__FieldID__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:392:1: ( ( () ) )
            // InternalDotRecordLabelParser.g:393:1: ( () )
            {
            // InternalDotRecordLabelParser.g:393:1: ( () )
            // InternalDotRecordLabelParser.g:394:2: ()
            {
             before(grammarAccess.getFieldIDAccess().getFieldIDAction_0()); 
            // InternalDotRecordLabelParser.g:395:2: ()
            // InternalDotRecordLabelParser.g:395:3: 
            {
            }

             after(grammarAccess.getFieldIDAccess().getFieldIDAction_0()); 

            }


            }

        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__FieldID__Group__0__Impl"


    // $ANTLR start "rule__FieldID__Group__1"
    // InternalDotRecordLabelParser.g:403:1: rule__FieldID__Group__1 : rule__FieldID__Group__1__Impl rule__FieldID__Group__2 ;
    public final void rule__FieldID__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:407:1: ( rule__FieldID__Group__1__Impl rule__FieldID__Group__2 )
            // InternalDotRecordLabelParser.g:408:2: rule__FieldID__Group__1__Impl rule__FieldID__Group__2
            {
            pushFollow(FOLLOW_8);
            rule__FieldID__Group__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__FieldID__Group__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__FieldID__Group__1"


    // $ANTLR start "rule__FieldID__Group__1__Impl"
    // InternalDotRecordLabelParser.g:415:1: rule__FieldID__Group__1__Impl : ( ( rule__FieldID__Group_1__0 )? ) ;
    public final void rule__FieldID__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:419:1: ( ( ( rule__FieldID__Group_1__0 )? ) )
            // InternalDotRecordLabelParser.g:420:1: ( ( rule__FieldID__Group_1__0 )? )
            {
            // InternalDotRecordLabelParser.g:420:1: ( ( rule__FieldID__Group_1__0 )? )
            // InternalDotRecordLabelParser.g:421:2: ( rule__FieldID__Group_1__0 )?
            {
             before(grammarAccess.getFieldIDAccess().getGroup_1()); 
            // InternalDotRecordLabelParser.g:422:2: ( rule__FieldID__Group_1__0 )?
            int alt4=2;
            int LA4_0 = input.LA(1);

            if ( (LA4_0==LessThanSign) ) {
                alt4=1;
            }
            switch (alt4) {
                case 1 :
                    // InternalDotRecordLabelParser.g:422:3: rule__FieldID__Group_1__0
                    {
                    pushFollow(FOLLOW_2);
                    rule__FieldID__Group_1__0();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getFieldIDAccess().getGroup_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__FieldID__Group__1__Impl"


    // $ANTLR start "rule__FieldID__Group__2"
    // InternalDotRecordLabelParser.g:430:1: rule__FieldID__Group__2 : rule__FieldID__Group__2__Impl ;
    public final void rule__FieldID__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:434:1: ( rule__FieldID__Group__2__Impl )
            // InternalDotRecordLabelParser.g:435:2: rule__FieldID__Group__2__Impl
            {
            pushFollow(FOLLOW_2);
            rule__FieldID__Group__2__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__FieldID__Group__2"


    // $ANTLR start "rule__FieldID__Group__2__Impl"
    // InternalDotRecordLabelParser.g:441:1: rule__FieldID__Group__2__Impl : ( ( rule__FieldID__NameAssignment_2 )? ) ;
    public final void rule__FieldID__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:445:1: ( ( ( rule__FieldID__NameAssignment_2 )? ) )
            // InternalDotRecordLabelParser.g:446:1: ( ( rule__FieldID__NameAssignment_2 )? )
            {
            // InternalDotRecordLabelParser.g:446:1: ( ( rule__FieldID__NameAssignment_2 )? )
            // InternalDotRecordLabelParser.g:447:2: ( rule__FieldID__NameAssignment_2 )?
            {
             before(grammarAccess.getFieldIDAccess().getNameAssignment_2()); 
            // InternalDotRecordLabelParser.g:448:2: ( rule__FieldID__NameAssignment_2 )?
            int alt5=2;
            int LA5_0 = input.LA(1);

            if ( (LA5_0==RULE_NON_WS_STRING) ) {
                alt5=1;
            }
            switch (alt5) {
                case 1 :
                    // InternalDotRecordLabelParser.g:448:3: rule__FieldID__NameAssignment_2
                    {
                    pushFollow(FOLLOW_2);
                    rule__FieldID__NameAssignment_2();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getFieldIDAccess().getNameAssignment_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__FieldID__Group__2__Impl"


    // $ANTLR start "rule__FieldID__Group_1__0"
    // InternalDotRecordLabelParser.g:457:1: rule__FieldID__Group_1__0 : rule__FieldID__Group_1__0__Impl rule__FieldID__Group_1__1 ;
    public final void rule__FieldID__Group_1__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:461:1: ( rule__FieldID__Group_1__0__Impl rule__FieldID__Group_1__1 )
            // InternalDotRecordLabelParser.g:462:2: rule__FieldID__Group_1__0__Impl rule__FieldID__Group_1__1
            {
            pushFollow(FOLLOW_9);
            rule__FieldID__Group_1__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__FieldID__Group_1__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__FieldID__Group_1__0"


    // $ANTLR start "rule__FieldID__Group_1__0__Impl"
    // InternalDotRecordLabelParser.g:469:1: rule__FieldID__Group_1__0__Impl : ( ( rule__FieldID__PortNamedAssignment_1_0 ) ) ;
    public final void rule__FieldID__Group_1__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:473:1: ( ( ( rule__FieldID__PortNamedAssignment_1_0 ) ) )
            // InternalDotRecordLabelParser.g:474:1: ( ( rule__FieldID__PortNamedAssignment_1_0 ) )
            {
            // InternalDotRecordLabelParser.g:474:1: ( ( rule__FieldID__PortNamedAssignment_1_0 ) )
            // InternalDotRecordLabelParser.g:475:2: ( rule__FieldID__PortNamedAssignment_1_0 )
            {
             before(grammarAccess.getFieldIDAccess().getPortNamedAssignment_1_0()); 
            // InternalDotRecordLabelParser.g:476:2: ( rule__FieldID__PortNamedAssignment_1_0 )
            // InternalDotRecordLabelParser.g:476:3: rule__FieldID__PortNamedAssignment_1_0
            {
            pushFollow(FOLLOW_2);
            rule__FieldID__PortNamedAssignment_1_0();

            state._fsp--;


            }

             after(grammarAccess.getFieldIDAccess().getPortNamedAssignment_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__FieldID__Group_1__0__Impl"


    // $ANTLR start "rule__FieldID__Group_1__1"
    // InternalDotRecordLabelParser.g:484:1: rule__FieldID__Group_1__1 : rule__FieldID__Group_1__1__Impl rule__FieldID__Group_1__2 ;
    public final void rule__FieldID__Group_1__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:488:1: ( rule__FieldID__Group_1__1__Impl rule__FieldID__Group_1__2 )
            // InternalDotRecordLabelParser.g:489:2: rule__FieldID__Group_1__1__Impl rule__FieldID__Group_1__2
            {
            pushFollow(FOLLOW_9);
            rule__FieldID__Group_1__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__FieldID__Group_1__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__FieldID__Group_1__1"


    // $ANTLR start "rule__FieldID__Group_1__1__Impl"
    // InternalDotRecordLabelParser.g:496:1: rule__FieldID__Group_1__1__Impl : ( ( rule__FieldID__PortAssignment_1_1 )? ) ;
    public final void rule__FieldID__Group_1__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:500:1: ( ( ( rule__FieldID__PortAssignment_1_1 )? ) )
            // InternalDotRecordLabelParser.g:501:1: ( ( rule__FieldID__PortAssignment_1_1 )? )
            {
            // InternalDotRecordLabelParser.g:501:1: ( ( rule__FieldID__PortAssignment_1_1 )? )
            // InternalDotRecordLabelParser.g:502:2: ( rule__FieldID__PortAssignment_1_1 )?
            {
             before(grammarAccess.getFieldIDAccess().getPortAssignment_1_1()); 
            // InternalDotRecordLabelParser.g:503:2: ( rule__FieldID__PortAssignment_1_1 )?
            int alt6=2;
            int LA6_0 = input.LA(1);

            if ( (LA6_0==RULE_NON_WS_STRING) ) {
                alt6=1;
            }
            switch (alt6) {
                case 1 :
                    // InternalDotRecordLabelParser.g:503:3: rule__FieldID__PortAssignment_1_1
                    {
                    pushFollow(FOLLOW_2);
                    rule__FieldID__PortAssignment_1_1();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getFieldIDAccess().getPortAssignment_1_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__FieldID__Group_1__1__Impl"


    // $ANTLR start "rule__FieldID__Group_1__2"
    // InternalDotRecordLabelParser.g:511:1: rule__FieldID__Group_1__2 : rule__FieldID__Group_1__2__Impl ;
    public final void rule__FieldID__Group_1__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:515:1: ( rule__FieldID__Group_1__2__Impl )
            // InternalDotRecordLabelParser.g:516:2: rule__FieldID__Group_1__2__Impl
            {
            pushFollow(FOLLOW_2);
            rule__FieldID__Group_1__2__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__FieldID__Group_1__2"


    // $ANTLR start "rule__FieldID__Group_1__2__Impl"
    // InternalDotRecordLabelParser.g:522:1: rule__FieldID__Group_1__2__Impl : ( GreaterThanSign ) ;
    public final void rule__FieldID__Group_1__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:526:1: ( ( GreaterThanSign ) )
            // InternalDotRecordLabelParser.g:527:1: ( GreaterThanSign )
            {
            // InternalDotRecordLabelParser.g:527:1: ( GreaterThanSign )
            // InternalDotRecordLabelParser.g:528:2: GreaterThanSign
            {
             before(grammarAccess.getFieldIDAccess().getGreaterThanSignKeyword_1_2()); 
            match(input,GreaterThanSign,FOLLOW_2); 
             after(grammarAccess.getFieldIDAccess().getGreaterThanSignKeyword_1_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__FieldID__Group_1__2__Impl"


    // $ANTLR start "rule__RLabel__FieldsAssignment_0"
    // InternalDotRecordLabelParser.g:538:1: rule__RLabel__FieldsAssignment_0 : ( ruleField ) ;
    public final void rule__RLabel__FieldsAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:542:1: ( ( ruleField ) )
            // InternalDotRecordLabelParser.g:543:2: ( ruleField )
            {
            // InternalDotRecordLabelParser.g:543:2: ( ruleField )
            // InternalDotRecordLabelParser.g:544:3: ruleField
            {
             before(grammarAccess.getRLabelAccess().getFieldsFieldParserRuleCall_0_0()); 
            pushFollow(FOLLOW_2);
            ruleField();

            state._fsp--;

             after(grammarAccess.getRLabelAccess().getFieldsFieldParserRuleCall_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RLabel__FieldsAssignment_0"


    // $ANTLR start "rule__RLabel__FieldsAssignment_1_1"
    // InternalDotRecordLabelParser.g:553:1: rule__RLabel__FieldsAssignment_1_1 : ( ruleField ) ;
    public final void rule__RLabel__FieldsAssignment_1_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:557:1: ( ( ruleField ) )
            // InternalDotRecordLabelParser.g:558:2: ( ruleField )
            {
            // InternalDotRecordLabelParser.g:558:2: ( ruleField )
            // InternalDotRecordLabelParser.g:559:3: ruleField
            {
             before(grammarAccess.getRLabelAccess().getFieldsFieldParserRuleCall_1_1_0()); 
            pushFollow(FOLLOW_2);
            ruleField();

            state._fsp--;

             after(grammarAccess.getRLabelAccess().getFieldsFieldParserRuleCall_1_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RLabel__FieldsAssignment_1_1"


    // $ANTLR start "rule__Field__FieldIDAssignment_0"
    // InternalDotRecordLabelParser.g:568:1: rule__Field__FieldIDAssignment_0 : ( ruleFieldID ) ;
    public final void rule__Field__FieldIDAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:572:1: ( ( ruleFieldID ) )
            // InternalDotRecordLabelParser.g:573:2: ( ruleFieldID )
            {
            // InternalDotRecordLabelParser.g:573:2: ( ruleFieldID )
            // InternalDotRecordLabelParser.g:574:3: ruleFieldID
            {
             before(grammarAccess.getFieldAccess().getFieldIDFieldIDParserRuleCall_0_0()); 
            pushFollow(FOLLOW_2);
            ruleFieldID();

            state._fsp--;

             after(grammarAccess.getFieldAccess().getFieldIDFieldIDParserRuleCall_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Field__FieldIDAssignment_0"


    // $ANTLR start "rule__Field__LabelAssignment_1_1"
    // InternalDotRecordLabelParser.g:583:1: rule__Field__LabelAssignment_1_1 : ( ruleRLabel ) ;
    public final void rule__Field__LabelAssignment_1_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:587:1: ( ( ruleRLabel ) )
            // InternalDotRecordLabelParser.g:588:2: ( ruleRLabel )
            {
            // InternalDotRecordLabelParser.g:588:2: ( ruleRLabel )
            // InternalDotRecordLabelParser.g:589:3: ruleRLabel
            {
             before(grammarAccess.getFieldAccess().getLabelRLabelParserRuleCall_1_1_0()); 
            pushFollow(FOLLOW_2);
            ruleRLabel();

            state._fsp--;

             after(grammarAccess.getFieldAccess().getLabelRLabelParserRuleCall_1_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Field__LabelAssignment_1_1"


    // $ANTLR start "rule__FieldID__PortNamedAssignment_1_0"
    // InternalDotRecordLabelParser.g:598:1: rule__FieldID__PortNamedAssignment_1_0 : ( ( LessThanSign ) ) ;
    public final void rule__FieldID__PortNamedAssignment_1_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:602:1: ( ( ( LessThanSign ) ) )
            // InternalDotRecordLabelParser.g:603:2: ( ( LessThanSign ) )
            {
            // InternalDotRecordLabelParser.g:603:2: ( ( LessThanSign ) )
            // InternalDotRecordLabelParser.g:604:3: ( LessThanSign )
            {
             before(grammarAccess.getFieldIDAccess().getPortNamedLessThanSignKeyword_1_0_0()); 
            // InternalDotRecordLabelParser.g:605:3: ( LessThanSign )
            // InternalDotRecordLabelParser.g:606:4: LessThanSign
            {
             before(grammarAccess.getFieldIDAccess().getPortNamedLessThanSignKeyword_1_0_0()); 
            match(input,LessThanSign,FOLLOW_2); 
             after(grammarAccess.getFieldIDAccess().getPortNamedLessThanSignKeyword_1_0_0()); 

            }

             after(grammarAccess.getFieldIDAccess().getPortNamedLessThanSignKeyword_1_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__FieldID__PortNamedAssignment_1_0"


    // $ANTLR start "rule__FieldID__PortAssignment_1_1"
    // InternalDotRecordLabelParser.g:617:1: rule__FieldID__PortAssignment_1_1 : ( ruleString ) ;
    public final void rule__FieldID__PortAssignment_1_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:621:1: ( ( ruleString ) )
            // InternalDotRecordLabelParser.g:622:2: ( ruleString )
            {
            // InternalDotRecordLabelParser.g:622:2: ( ruleString )
            // InternalDotRecordLabelParser.g:623:3: ruleString
            {
             before(grammarAccess.getFieldIDAccess().getPortStringParserRuleCall_1_1_0()); 
            pushFollow(FOLLOW_2);
            ruleString();

            state._fsp--;

             after(grammarAccess.getFieldIDAccess().getPortStringParserRuleCall_1_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__FieldID__PortAssignment_1_1"


    // $ANTLR start "rule__FieldID__NameAssignment_2"
    // InternalDotRecordLabelParser.g:632:1: rule__FieldID__NameAssignment_2 : ( ruleString ) ;
    public final void rule__FieldID__NameAssignment_2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotRecordLabelParser.g:636:1: ( ( ruleString ) )
            // InternalDotRecordLabelParser.g:637:2: ( ruleString )
            {
            // InternalDotRecordLabelParser.g:637:2: ( ruleString )
            // InternalDotRecordLabelParser.g:638:3: ruleString
            {
             before(grammarAccess.getFieldIDAccess().getNameStringParserRuleCall_2_0()); 
            pushFollow(FOLLOW_2);
            ruleString();

            state._fsp--;

             after(grammarAccess.getFieldIDAccess().getNameStringParserRuleCall_2_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__FieldID__NameAssignment_2"

    // Delegated rules


 

    public static final BitSet FOLLOW_1 = new BitSet(new long[]{0x0000000000000000L});
    public static final BitSet FOLLOW_2 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_3 = new BitSet(new long[]{0x0000000000000202L});
    public static final BitSet FOLLOW_4 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_5 = new BitSet(new long[]{0x0000000000000082L});
    public static final BitSet FOLLOW_6 = new BitSet(new long[]{0x0000000000000250L});
    public static final BitSet FOLLOW_7 = new BitSet(new long[]{0x0000000000000100L});
    public static final BitSet FOLLOW_8 = new BitSet(new long[]{0x0000000000000210L});
    public static final BitSet FOLLOW_9 = new BitSet(new long[]{0x0000000000000220L});

}