/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.actions;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.jobs.MavenWorkspaceJob;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ChangeNatureAction
implements IObjectActionDelegate,
IExecutableExtension {
    public static final String ID_ENABLE_WORKSPACE = "org.eclipse.m2e.enableWorkspaceResolutionAction";
    public static final String ID_DISABLE_WORKSPACE = "org.eclipse.m2e.disableWorkspaceResolutionAction";
    public static final int ENABLE_WORKSPACE = 1;
    public static final int DISABLE_WORKSPACE = 2;
    private ISelection selection;
    private int option;

    public ChangeNatureAction() {
        this(1);
    }

    public ChangeNatureAction(int option) {
        this.option = option;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        if (data != null) {
            if ("enableWorkspaceResolution".equals(data)) {
                this.option = 1;
            }
            if ("disableWorkspaceResolution".equals(data)) {
                this.option = 2;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        ISelection iSelection = this.selection;
        if (iSelection instanceof IStructuredSelection var2_3) {
            LinkedHashSet<IProject> projects = new LinkedHashSet<IProject>();
            for (Object element : structuredSelection) {
                IProject project = null;
                if (element instanceof IProject var9_8) {
                    project = p;
                } else {
                    if (element instanceof IAdaptable var12_10) {
                        project = (IProject)adaptable.getAdapter(IProject.class);
                    }
                }
                if (project == null) continue;
                projects.add(project);
            }
            new UpdateJob(projects, this.option).schedule();
        }
    }

    static class UpdateJob
    extends MavenWorkspaceJob {
        private final Set<IProject> projects;
        private final int option;
        private final IProjectConfigurationManager importManager;
        private final IMavenProjectRegistry projectManager;
        private final IMavenConfiguration mavenConfiguration;

        public UpdateJob(Set<IProject> projects, int option) {
            super(Messages.ChangeNatureAction_job_changing);
            this.projects = projects;
            this.option = option;
            this.importManager = MavenPlugin.getProjectConfigurationManager();
            this.projectManager = MavenPlugin.getMavenProjectRegistry();
            this.mavenConfiguration = MavenPlugin.getMavenConfiguration();
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            IStatus status = null;
            for (IProject project : this.projects) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                monitor.subTask(project.getName());
                try {
                    this.changeNature(project, monitor);
                }
                catch (CoreException ex) {
                    if (status == null) {
                        status = new MultiStatus("org.eclipse.m2e.core", 4, Messages.ChangeNatureAction_status_error, null);
                    }
                    status.add(ex.getStatus());
                }
            }
            boolean offline = this.mavenConfiguration.isOffline();
            boolean updateSnapshots = false;
            this.projectManager.refresh(new MavenUpdateRequest(this.projects, offline, updateSnapshots));
            return status != null ? status : Status.OK_STATUS;
        }

        private void changeNature(IProject project, IProgressMonitor monitor) throws CoreException {
            IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
            ResolverConfiguration configuration = new ResolverConfiguration(configurationManager.getProjectConfiguration(project));
            boolean updateSourceFolders = false;
            switch (this.option) {
                case 1: {
                    configuration.setResolveWorkspaceProjects(true);
                    break;
                }
                case 2: {
                    configuration.setResolveWorkspaceProjects(false);
                }
            }
            configurationManager.setResolverConfiguration(project, configuration);
            if (updateSourceFolders) {
                this.importManager.updateProjectConfiguration(project, monitor);
            }
        }
    }
}

