/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.internal.architecture.merger;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureFactory;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.ArchitectureContextInheritanceRule;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.ArchitectureContextRule;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.ArchitectureExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class ArchitectureDomainRule {
    @Extension
    private static ArchitectureFactory factory = ArchitectureFactory.eINSTANCE;
    @Inject
    @Extension
    private ArchitectureExtensions _architectureExtensions;
    @Inject
    @Extension
    private ArchitectureContextRule _architectureContextRule;
    @Inject
    @Extension
    private ArchitectureContextInheritanceRule _architectureContextInheritanceRule;
    private final HashMap<ArrayList<?>, ArchitectureDomain> _createCache_inherit = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, ArchitectureDomain> _createCache_merged = CollectionLiterals.newHashMap();

    public boolean hasExtensions(ArchitectureDomain domain) {
        Functions.Function1 _function = it -> this._architectureContextRule.hasExtensions((ArchitectureContext)it);
        return IterableExtensions.exists((Iterable)domain.getContexts(), (Functions.Function1)_function);
    }

    public boolean isExtension(ArchitectureDomain domain) {
        Functions.Function1 _function = it -> it.isExtension();
        return IterableExtensions.exists((Iterable)domain.getContexts(), (Functions.Function1)_function);
    }

    public boolean hasInheritance(ArchitectureDomain domain) {
        Functions.Function1 _function = it -> this._architectureContextInheritanceRule.hasGeneral((ArchitectureContext)it) || this._architectureContextInheritanceRule.hasSpecializations((ArchitectureContext)it);
        return IterableExtensions.exists((Iterable)domain.getContexts(), (Functions.Function1)_function);
    }

    public boolean hasContexts(ArchitectureDomain domain) {
        boolean _isEmpty = domain.getContexts().isEmpty();
        return !_isEmpty;
    }

    public Iterable<ArchitectureContext> allContexts(ArchitectureDomain domain) {
        EList _contexts = domain.getContexts();
        Functions.Function1 _function = it -> it.getContexts();
        Iterable _flatMap = IterableExtensions.flatMap(this.allExtensions(domain), (Functions.Function1)_function);
        return Iterables.concat((Iterable)_contexts, (Iterable)_flatMap);
    }

    public Iterable<ArchitectureDomain> extensions(ArchitectureDomain extended) {
        Iterable<Object> _xifexpression = null;
        boolean _inExtensionsPhase = this._architectureExtensions.inExtensionsPhase();
        if (_inExtensionsPhase) {
            Functions.Function1 _function = it -> this._architectureContextRule.extensions(it);
            Functions.Function1 _function_1 = it -> it.getDomain();
            _xifexpression = this._architectureExtensions.mapUnique(IterableExtensions.flatMap((Iterable)extended.getContexts(), (Functions.Function1)_function), _function_1);
        } else {
            _xifexpression = CollectionLiterals.emptyList();
        }
        return _xifexpression;
    }

    public Iterable<ArchitectureDomain> allExtensions(ArchitectureDomain extended) {
        Iterable<Object> _xifexpression = null;
        boolean _inExtensionsPhase = this._architectureExtensions.inExtensionsPhase();
        if (_inExtensionsPhase) {
            Functions.Function1 _function = it -> this._architectureContextRule.allExtensions(it);
            Functions.Function1 _function_1 = it -> it.getDomain();
            _xifexpression = this._architectureExtensions.mapUnique(IterableExtensions.flatMap((Iterable)extended.getContexts(), (Functions.Function1)_function), _function_1);
        } else {
            _xifexpression = CollectionLiterals.emptyList();
        }
        return _xifexpression;
    }

    public Iterable<ArchitectureDomain> generals(ArchitectureDomain specific) {
        Iterable<Object> _xifexpression = null;
        boolean _inInheritancePhase = this._architectureExtensions.inInheritancePhase();
        if (_inInheritancePhase) {
            Functions.Function1 _function = it -> this._architectureContextInheritanceRule.general((ArchitectureContext)it);
            Functions.Function1 _function_1 = it -> it.getDomain();
            _xifexpression = this._architectureExtensions.excluding(this._architectureExtensions.unique(IterableExtensions.map((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)specific.getContexts(), (Functions.Function1)_function)), (Functions.Function1)_function_1)), specific);
        } else {
            _xifexpression = CollectionLiterals.emptyList();
        }
        return _xifexpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchitectureDomain inherit(ArchitectureDomain domain) {
        ArchitectureDomain _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new ArchitectureDomain[]{domain});
        HashMap<ArrayList<?>, ArchitectureDomain> hashMap = this._createCache_inherit;
        synchronized (hashMap) {
            if (this._createCache_inherit.containsKey(_cacheKey)) {
                return this._createCache_inherit.get(_cacheKey);
            }
            _result = domain;
            this._createCache_inherit.put(_cacheKey, _result);
        }
        this._init_inherit(_result, domain);
        return _result;
    }

    private void _init_inherit(ArchitectureDomain it, ArchitectureDomain domain) {
        Functions.Function1 _function = it_1 -> this.inherit((ArchitectureDomain)it_1);
        Functions.Function0 _function_1 = () -> {
            boolean _xblockexpression = false;
            EList _concerns = domain.getConcerns();
            Functions.Function1 _function_2 = it_1 -> it_1.getConcerns();
            Functions.Function1 _function_3 = it_1 -> it_1.getName();
            Functions.Function1 _function_4 = it_1 -> this._architectureExtensions.mergedConcern((String)it_1);
            Iterable _map = IterableExtensions.map(this._architectureExtensions.mapUnique(IterableExtensions.flatMap(this._architectureExtensions.currentScope(), (Functions.Function1)_function_2), _function_3), (Functions.Function1)_function_4);
            Iterables.addAll((Collection)_concerns, (Iterable)_map);
            EList _stakeholders = domain.getStakeholders();
            Functions.Function1 _function_5 = it_1 -> it_1.getStakeholders();
            Functions.Function1 _function_6 = it_1 -> it_1.getName();
            Functions.Function1 _function_7 = it_1 -> this._architectureExtensions.mergedStakeholder((String)it_1);
            Iterable _map_1 = IterableExtensions.map(this._architectureExtensions.mapUnique(IterableExtensions.flatMap(this._architectureExtensions.currentScope(), (Functions.Function1)_function_5), _function_6), (Functions.Function1)_function_7);
            _xblockexpression = Iterables.addAll((Collection)_stakeholders, (Iterable)_map_1);
            return _xblockexpression;
        };
        this._architectureExtensions.withScope((Iterable<? extends ArchitectureDomain>)IterableExtensions.map(this.generals(domain), (Functions.Function1)_function), _function_1);
        boolean _inInheritancePhase = this._architectureExtensions.inInheritancePhase();
        if (_inInheritancePhase) {
            Consumer<ArchitectureContext> _function_2 = it_1 -> this._architectureContextInheritanceRule.inherit((ArchitectureContext)it_1);
            domain.getContexts().forEach(_function_2);
        }
    }

    public void finalizeInheritance(ArchitectureDomain domain) {
        Consumer<ArchitectureContext> _function = it -> this._architectureContextInheritanceRule.finalizeInheritance((ArchitectureContext)it);
        domain.getContexts().forEach(_function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchitectureDomain merged(ArchitectureDomain domain) {
        ArchitectureDomain _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new ArchitectureDomain[]{domain});
        HashMap<ArrayList<?>, ArchitectureDomain> hashMap = this._createCache_merged;
        synchronized (hashMap) {
            ArchitectureDomain _createArchitectureDomain;
            if (this._createCache_merged.containsKey(_cacheKey)) {
                return this._createCache_merged.get(_cacheKey);
            }
            _result = _createArchitectureDomain = factory.createArchitectureDomain();
            this._createCache_merged.put(_cacheKey, _result);
        }
        this._init_merged(_result, domain);
        return _result;
    }

    private void _init_merged(ArchitectureDomain it, ArchitectureDomain domain) {
        Set<ArchitectureDomain> _of = Set.of(domain);
        Iterable<ArchitectureDomain> _allExtensions = this.allExtensions(domain);
        Functions.Function0 _function = () -> {
            ArchitectureDomain _copy = this._architectureExtensions.copy(it, domain);
            Procedures.Procedure1 _function_1 = result -> {
                EList _concerns = it.getConcerns();
                Functions.Function1 _function_2 = it_1 -> it_1.getConcerns();
                Functions.Function1 _function_3 = it_1 -> it_1.getName();
                Functions.Function1 _function_4 = it_1 -> this._architectureExtensions.mergedConcern((String)it_1);
                Iterable _map = IterableExtensions.map(this._architectureExtensions.mapUnique(IterableExtensions.flatMap(this._architectureExtensions.currentScope(), (Functions.Function1)_function_2), _function_3), (Functions.Function1)_function_4);
                Iterables.addAll((Collection)_concerns, (Iterable)_map);
                EList _stakeholders = it.getStakeholders();
                Functions.Function1 _function_5 = it_1 -> it_1.getStakeholders();
                Functions.Function1 _function_6 = it_1 -> it_1.getName();
                Functions.Function1 _function_7 = it_1 -> this._architectureExtensions.mergedStakeholder((String)it_1);
                Iterable _map_1 = IterableExtensions.map(this._architectureExtensions.mapUnique(IterableExtensions.flatMap(this._architectureExtensions.currentScope(), (Functions.Function1)_function_5), _function_6), (Functions.Function1)_function_7);
                Iterables.addAll((Collection)_stakeholders, (Iterable)_map_1);
                EList _contexts = it.getContexts();
                Functions.Function1 _function_8 = it_1 -> it_1.isExtension();
                Functions.Function1 _function_9 = it_1 -> this._architectureContextRule.merged((ArchitectureContext)it_1);
                Iterable _map_2 = IterableExtensions.map((Iterable)IterableExtensions.reject(this.allContexts(domain), (Functions.Function1)_function_8), (Functions.Function1)_function_9);
                Iterables.addAll((Collection)_contexts, (Iterable)_map_2);
                Consumer<ArchitectureDomain> _function_10 = it_1 -> this._architectureExtensions.traceTo(result, it_1);
                this.allExtensions(domain).forEach(_function_10);
            };
            return (ArchitectureDomain)ObjectExtensions.operator_doubleArrow((Object)_copy, (Procedures.Procedure1)_function_1);
        };
        this._architectureExtensions.withScope((Iterable<? extends ArchitectureDomain>)Iterables.concat(_of, _allExtensions), _function);
    }

    public void inferExtensions(ArchitectureDomain domain) {
        Functions.Function1 _function = it -> this._architectureContextInheritanceRule.legacyContext((ArchitectureContext)it);
        Consumer<ArchitectureContext> _function_1 = it -> this._architectureContextRule.inferExtensions((ArchitectureContext)it);
        IterableExtensions.filter((Iterable)domain.getContexts(), (Functions.Function1)_function).forEach(_function_1);
    }
}

