/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.handler;

import org.eclipse.php.composer.core.launch.execution.ExecutionResponseAdapter;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConsoleResponseHandler
extends ExecutionResponseAdapter {
    private MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole console = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{console});
        return console;
    }

    public void executionAboutToStart() {
        MessageConsole console = this.findConsole("Composer");
        console.clearConsole();
    }

    public void executionMessage(String message) {
        MessageConsole console = this.findConsole("Composer");
        MessageConsoleStream out = console.newMessageStream();
        out.println(message);
    }

    public void executionFailed(String response, Exception e) {
        Logger.log((int)4, (String)response);
        Logger.logException((Throwable)e);
    }
}

