/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.util.compression.huffmancoder;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.ptp.proxy.util.compression.BitUtils;
import org.eclipse.ptp.proxy.util.compression.huffmancoder.ISymbolDefiner;
import org.eclipse.ptp.proxy.util.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HuffmanCoder {
    private HuffmanTree huffTree;
    private final Symbol[] symbols;
    private ByteBuffer encoding;
    private final int[] freqtable;
    private final ISymbolDefiner symbolTable;
    private static final int CACHE_TRIGGER = 3;
    private static final int CACHE_SIZE_LIMIT = 16;
    private static final int BYTE_MASK = 255;
    private static final int LARGE_MESSAGE = 8192;

    private static final int getSomeBits(byte[] in, int currentBytePos, int at, int limit) {
        int ret = 0;
        int pos = currentBytePos;
        ret |= in[pos++] & 0xFF;
        if (pos < limit) {
            ret |= (in[pos++] & 0xFF) << 8;
        }
        if (pos < limit) {
            ret |= (in[pos] & 0xFF) << 16;
        }
        return ret >> at;
    }

    HuffmanCoder(ISymbolDefiner sTable, int[] frequencies) {
        this.symbolTable = sTable;
        this.freqtable = frequencies;
        this.symbols = new Symbol[frequencies.length];
        int i = 0;
        while (i < this.symbols.length) {
            this.symbols[i] = new Symbol();
            ++i;
        }
    }

    final void assignHuffmanCodes() {
        if (this.huffTree == null) {
            throw new RuntimeException(Messages.getString("HuffmanCoder.0"));
        }
        int encodinglen = (this.huffTree.treeHeight >> 3) + 1;
        ByteBuffer pattern = ByteBuffer.allocate(encodinglen);
        this.encoding = ByteBuffer.allocate(encodinglen * this.symbols.length);
        this.assignHuffmanCodesHelper(this.huffTree, pattern, 0, 0);
    }

    private int assignHuffmanCodesHelper(HuffmanTree node, ByteBuffer pattern, int len, int encodingindex) {
        if (node.left != null) {
            BitUtils.resetBit(pattern, len);
            encodingindex = this.assignHuffmanCodesHelper(node.left, pattern, len + 1, encodingindex);
            BitUtils.setBit(pattern, len);
            encodingindex = this.assignHuffmanCodesHelper(node.right, pattern, len + 1, encodingindex);
        } else {
            this.symbols[node.symbolIndex].encodingindex = encodingindex;
            this.symbols[node.symbolIndex].len = len;
            this.encoding.put(pattern.array(), 0, (len >> 3) + 1);
            encodingindex += (len >> 3) + 1;
        }
        return encodingindex;
    }

    final void buildHuffmanTree() {
        ArrayList<HuffmanTree> queue1 = new ArrayList<HuffmanTree>(this.symbols.length * 2);
        ArrayList<HuffmanTree> queue2 = new ArrayList<HuffmanTree>(this.symbols.length * 2);
        int[] indices = new int[4];
        int i = 0;
        while (i < this.symbols.length) {
            HuffmanTree t = new HuffmanTree(this.freqtable[i], i);
            queue1.add(t);
            ++i;
        }
        Collections.sort(queue1, new FrequencyCompare());
        int lowindex1 = i = 0;
        int lowindex2 = 0;
        int highindex1 = this.symbols.length;
        int highindex2 = 0;
        int nodesleft = highindex1 - lowindex1 + highindex2 - lowindex2;
        while (nodesleft > 1) {
            indices[0] = lowindex1;
            indices[1] = lowindex2;
            indices[2] = highindex1;
            indices[3] = highindex2;
            this.combineNodes(queue1, queue2, highindex1 - lowindex1, highindex2 - lowindex2, indices);
            lowindex1 = indices[0];
            lowindex2 = indices[1];
            highindex1 = indices[2];
            highindex2 = indices[3];
            --nodesleft;
        }
        this.huffTree = highindex1 - lowindex1 > 0 ? (HuffmanTree)queue1.get(lowindex1) : (HuffmanTree)queue2.get(lowindex2);
    }

    private final void combineNodes(ArrayList<HuffmanTree> q1, ArrayList<HuffmanTree> q2, int len1, int len2, int[] indices) {
        HuffmanTree n2;
        HuffmanTree n1;
        HuffmanTree n3 = null;
        int lowindex1 = indices[0];
        int lowindex2 = indices[1];
        int highindex1 = indices[2];
        int highindex2 = indices[3];
        if (len1 > 0) {
            if (len2 > 0) {
                int freqcomp = q1.get((int)lowindex1).frequency - q2.get((int)lowindex2).frequency;
                if (freqcomp < 0) {
                    n1 = q1.get(lowindex1);
                    n2 = q2.get(lowindex2);
                    if (len1 > 1) {
                        n3 = q1.get(lowindex1 + 1);
                    }
                    ++lowindex1;
                } else {
                    n1 = q2.get(lowindex2);
                    n2 = q1.get(lowindex1);
                    if (len2 > 1) {
                        n3 = q2.get(lowindex2 + 1);
                    }
                    ++lowindex2;
                }
                if (n3 == null) {
                    if (freqcomp < 0) {
                        ++lowindex2;
                    } else {
                        ++lowindex1;
                    }
                } else if (n2.frequency - n3.frequency > 0) {
                    n2 = n3;
                    if (freqcomp < 0) {
                        ++lowindex1;
                    } else {
                        ++lowindex2;
                    }
                } else if (freqcomp < 0) {
                    ++lowindex2;
                } else {
                    ++lowindex1;
                }
            } else {
                n1 = q1.get(lowindex1);
                n2 = q1.get(lowindex1 + 1);
                lowindex1 += 2;
            }
        } else {
            n1 = q2.get(lowindex2);
            n2 = q2.get(lowindex2 + 1);
            lowindex2 += 2;
        }
        int totalfreq = n1.frequency + n2.frequency;
        HuffmanTree parent = new HuffmanTree(n1, n2, totalfreq);
        if (highindex1 - lowindex1 == 0 || totalfreq > q1.get((int)(highindex1 - 1)).frequency) {
            q1.add(parent);
        } else {
            q2.add(parent);
        }
        indices[0] = lowindex1;
        indices[1] = lowindex2;
        indices[2] = ++highindex1;
        indices[3] = ++highindex2;
    }

    ByteBuffer decode(ByteBuffer in, int origlen) {
        if (this.huffTree == null) {
            throw new RuntimeException(Messages.getString("HuffmanCoder.1"));
        }
        if (this.huffTree.minEncodingLen > 3 && this.huffTree.minEncodingLen < 16 && in.limit() > 8192) {
            return this.decodeCached(in, origlen);
        }
        int currentbitpos = 0;
        int len = 0;
        byte[] resultBuffer = new byte[origlen];
        ByteBuffer result = ByteBuffer.wrap(resultBuffer);
        byte[] inBuffer = in.array();
        int currentbytepos = in.arrayOffset();
        byte currentByte = inBuffer[currentbytepos++];
        HuffmanTree node = this.huffTree;
        while (true) {
            if (node.left != null) {
                if (currentbitpos == 8) {
                    currentbitpos = 0;
                    currentByte = inBuffer[currentbytepos++];
                }
                node = (currentByte & 1 << currentbitpos) != 0 ? node.right : node.left;
                ++currentbitpos;
                continue;
            }
            byte[] symbolrep = this.symbolTable.getSymbolRepresentation(node.symbolIndex);
            if (symbolrep.length == 1) {
                resultBuffer[len++] = symbolrep[0];
            } else {
                System.arraycopy(symbolrep, 0, resultBuffer, len, symbolrep.length);
                len += symbolrep.length;
            }
            if (len >= origlen) break;
            node = this.huffTree;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private ByteBuffer decodeCached(ByteBuffer in, int origlen) {
        node = this.huffTree;
        currentbitpos = 0;
        len = 0;
        resultBuffer = new byte[origlen];
        result = ByteBuffer.wrap(resultBuffer);
        cache = null;
        cacheSize = 0;
        bitLen = 0;
        cacheFilled = 0;
        partBits = 0x7FFFFFFF;
        limit = in.limit();
        inBuffer = in.array();
        currentBytePos = offset = in.arrayOffset();
        cacheBits = 0;
        currentByte = inBuffer[currentBytePos++];
        cacheBits = this.huffTree.minEncodingLen < 16 ? this.huffTree.minEncodingLen : 15;
        cacheSize = 1 << cacheBits;
        cache = new HuffmanTree[cacheSize];
        while (true) {
            if (node.left != null) {
                if (currentbitpos == 8) {
                    currentbitpos = 0;
                    currentByte = inBuffer[currentBytePos++];
                }
                node = (currentByte & 1 << currentbitpos) != 0 ? node.right : node.left;
                ++currentbitpos;
                if (++bitLen != cacheBits || partBits == 0x7FFFFFFF) continue;
                cache[partBits] = node;
                ++cacheFilled;
                continue;
            }
            symbolrep = this.symbolTable.getSymbolRepresentation(node.symbolIndex);
            if (symbolrep.length == 1) {
                resultBuffer[len++] = symbolrep[0];
            } else {
                System.arraycopy(symbolrep, 0, resultBuffer, len, symbolrep.length);
                len += symbolrep.length;
            }
            if (len >= origlen) break;
            node = this.huffTree;
            bitLen = 0;
            if (cacheFilled == cacheSize) break;
            partBits = HuffmanCoder.getSomeBits(inBuffer, currentBytePos - 1, currentbitpos, limit + offset) % cacheSize;
            if (cache[partBits] == null) continue;
            node = cache[partBits];
            currentbitpos += cacheBits;
            while (currentbitpos >= 8) {
                currentbitpos -= 8;
                currentByte = inBuffer[currentBytePos++];
            }
            bitLen = cacheBits;
        }
        if (len < origlen) {
            block2: while (true) {
                if (node.left != null) {
                    if (currentbitpos == 8) {
                        currentbitpos = 0;
                        currentByte = inBuffer[currentBytePos++];
                    }
                    node = (currentByte & 1 << currentbitpos) != 0 ? node.right : node.left;
                    ++currentbitpos;
                    continue;
                }
                symbolrep = this.symbolTable.getSymbolRepresentation(node.symbolIndex);
                if (symbolrep.length == 1) {
                    resultBuffer[len++] = symbolrep[0];
                } else {
                    System.arraycopy(symbolrep, 0, resultBuffer, len, symbolrep.length);
                    len += symbolrep.length;
                }
                if (len >= origlen) break;
                node = this.huffTree;
                partBits = HuffmanCoder.getSomeBits(inBuffer, currentBytePos - 1, currentbitpos, limit + offset) % cacheSize;
                node = cache[partBits];
                currentbitpos += cacheBits;
                while (true) {
                    if (currentbitpos >= 8) ** break;
                    continue block2;
                    currentbitpos -= 8;
                    currentByte = inBuffer[currentBytePos++];
                }
                break;
            }
        }
        return result;
    }

    ByteBuffer encode(ByteBuffer in) {
        if (this.huffTree == null) {
            throw new RuntimeException(Messages.getString("HuffmanCoder.2"));
        }
        int allocsize = in.capacity();
        int destbitpos = 0;
        byte[] encodedbytearray = new byte[allocsize];
        ByteBuffer encodedbuffer = ByteBuffer.wrap(encodedbytearray);
        byte[] stable = this.encoding.array();
        int stableoffset = this.encoding.arrayOffset();
        byte[] inbuffer = in.array();
        int inoffset = in.arrayOffset();
        int bitssize = (allocsize - 2 << 3) - this.huffTree.treeHeight;
        int symbolId = this.symbolTable.nextSymbol(inbuffer, inoffset);
        while (symbolId >= 0) {
            Symbol symbol = this.symbols[symbolId];
            int slen = symbol.len;
            if (destbitpos >= bitssize) {
                allocsize += allocsize + symbol.len;
                bitssize = (allocsize - 2 << 3) - this.huffTree.treeHeight;
                byte[] newbytearray = new byte[allocsize];
                encodedbuffer = ByteBuffer.wrap(newbytearray);
                encodedbuffer.put(encodedbytearray);
                encodedbytearray = newbytearray;
            }
            BitUtils.packBits(encodedbytearray, destbitpos, stable, stableoffset + symbol.encodingindex, slen);
            destbitpos += slen;
            symbolId = this.symbolTable.nextSymbol(inbuffer);
        }
        encodedbuffer.limit(destbitpos != 0 ? 1 + (destbitpos >> 3) : 0);
        return encodedbuffer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FrequencyCompare
    implements Comparator<HuffmanTree> {
        @Override
        public int compare(HuffmanTree f1, HuffmanTree f2) {
            return f1.frequency - f2.frequency;
        }
    }

    private static final class HuffmanTree {
        int symbolIndex;
        int treeHeight;
        HuffmanTree left;
        HuffmanTree right;
        int minEncodingLen;
        final int frequency;

        public HuffmanTree(HuffmanTree n1, HuffmanTree n2, int totalFreq) {
            this.left = n1;
            this.right = n2;
            this.frequency = totalFreq;
            this.treeHeight = (n1.treeHeight > n2.treeHeight ? n1.treeHeight : n2.treeHeight) + 1;
            this.minEncodingLen = 1 + (n1.minEncodingLen < n2.minEncodingLen ? n1.minEncodingLen : n2.minEncodingLen);
        }

        public HuffmanTree(int freq, int sIndex) {
            this.symbolIndex = sIndex;
            this.frequency = freq;
        }
    }

    private static final class Symbol {
        int encodingindex;
        int len;
    }
}

