/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.migration.description;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.business.api.migration.AbstractVSMMigrationParticipant;
import org.eclipse.sirius.common.tools.api.interpreter.StandardServices;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.table.metamodel.table.description.CreateTool;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.JavaExtension;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.osgi.framework.Version;

public class InitializeCreationToolElementsToSelectExpressionParticipant
extends AbstractVSMMigrationParticipant {
    public static final Version MIGRATION_VERSION = new Version("10.1.0.201507271600");
    public static final String ELEMENTS_TO_SELECT_EXPRESSION = "service:stdEmptyCollection";
    private static final String JAVA_EXTENSION_QUALIFIED_NAME = StandardServices.class.getName();

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    protected void postLoad(Group group, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            EList ownedViewpoints = group.getOwnedViewpoints();
            for (Viewpoint viewpoint : ownedViewpoints) {
                boolean atLeastOneChange = false;
                for (TableDescription tableDescription : Iterables.filter((Iterable)viewpoint.getOwnedRepresentations(), TableDescription.class)) {
                    UnmodifiableIterator creationTools = Iterators.filter((Iterator)tableDescription.eAllContents(), CreateTool.class);
                    while (creationTools.hasNext()) {
                        CreateTool tool = (CreateTool)creationTools.next();
                        if (!StringUtil.isEmpty((String)tool.getElementsToSelect())) continue;
                        tool.setElementsToSelect(ELEMENTS_TO_SELECT_EXPRESSION);
                        atLeastOneChange = true;
                    }
                }
                if (!atLeastOneChange || Iterables.any((Iterable)viewpoint.getOwnedJavaExtensions(), (Predicate)new Predicate<JavaExtension>(){

                    public boolean apply(JavaExtension input) {
                        return JAVA_EXTENSION_QUALIFIED_NAME.equals(input.getQualifiedClassName());
                    }
                })) continue;
                JavaExtension javaExtension = DescriptionFactory.eINSTANCE.createJavaExtension();
                javaExtension.setQualifiedClassName(JAVA_EXTENSION_QUALIFIED_NAME);
                viewpoint.getOwnedJavaExtensions().add((Object)javaExtension);
            }
        }
    }
}

