/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.launch;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.internal.debug.Activator;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILocator;
import org.eclipse.tcf.util.TCFTask;
import org.osgi.framework.Bundle;

public class TCFLocalAgent {
    public static final String LOCAL_HOST = "127.0.0.1";
    public static final String AGENT_NAME = "agent";
    public static final String SERVER_NAME = "server";
    private static final Map<String, String> ports = new HashMap<String, String>();
    private static final Map<String, Process> agents = new HashMap<String, Process>();
    private static boolean destroed;

    static {
        ports.put(AGENT_NAME, "1534");
        ports.put(SERVER_NAME, "1535");
    }

    private static String getSysName() {
        String os = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        if (arch.equals("x86")) {
            arch = "i386";
        }
        if (arch.equals("i686")) {
            arch = "i386";
        }
        if (os.startsWith("Windows")) {
            os = "Windows";
        }
        if (os.equals("Linux")) {
            os = "GNU/Linux";
        }
        return String.valueOf(os) + "/" + arch;
    }

    private static Path getDevelAgentFileName(String nm) {
        File agent;
        block4: {
            try {
                Bundle bundle;
                File plugin;
                String fnm = nm;
                String sys = TCFLocalAgent.getSysName();
                if (sys.startsWith("Windows")) {
                    sys = "MSVC/Win32";
                    fnm = String.valueOf(fnm) + ".exe";
                }
                if ((agent = new File(plugin = FileLocator.getBundleFile((Bundle)(bundle = Platform.getBundle((String)"org.eclipse.tcf.debug"))), "../../../org.eclipse.tcf.agent/" + nm + "/obj/" + sys + "/Debug/" + fnm)).exists()) break block4;
                return null;
            }
            catch (Exception x) {
                Activator.log("Cannot find bundle location", x);
                return null;
            }
        }
        return new Path(agent.getAbsolutePath());
    }

    private static Path getAgentFileName(String fnm) {
        String sys = TCFLocalAgent.getSysName();
        if (sys.startsWith("Windows")) {
            fnm = String.valueOf(fnm) + ".exe";
        }
        return new Path("agent/" + sys + "/" + fnm);
    }

    public static synchronized String runLocalAgent(final String nm) throws CoreException {
        Path fnm;
        if (destroed) {
            return null;
        }
        String id = TCFLocalAgent.getLocalAgentID(nm);
        if (id != null) {
            return id;
        }
        if (agents.containsKey(nm)) {
            agents.remove(nm).destroy();
        }
        if ((fnm = TCFLocalAgent.getDevelAgentFileName(nm)) == null) {
            fnm = TCFLocalAgent.getAgentFileName(nm);
        }
        try {
            Bundle bundle;
            URL url;
            if (!fnm.isAbsolute() && (url = FileLocator.find((Bundle)(bundle = Platform.getBundle((String)"org.eclipse.tcf.debug")), (IPath)fnm, null)) != null) {
                URLConnection ucn = url.openConnection();
                ucn.setRequestProperty("Method", "HEAD");
                ucn.connect();
                long mtime = ucn.getLastModified();
                File f = Activator.getDefault().getStateLocation().append((IPath)fnm).toFile();
                if (!f.exists() || mtime != f.lastModified()) {
                    int len;
                    f.getParentFile().mkdirs();
                    InputStream inp = url.openStream();
                    FileOutputStream out = new FileOutputStream(f);
                    byte[] buf = new byte[4096];
                    while ((len = inp.read(buf)) >= 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                    ((OutputStream)out).close();
                    inp.close();
                    if (!"exe".equals(fnm.getFileExtension())) {
                        String[] cmd = new String[]{"chmod", "a+x", f.getAbsolutePath()};
                        Runtime.getRuntime().exec(cmd).waitFor();
                    }
                    f.setLastModified(mtime);
                    fnm = new Path(f.getAbsolutePath());
                }
            }
            String[] cmd = new String[]{fnm.toOSString(), "-s", "TCP:127.0.0.1:" + ports.get(nm)};
            final Process prs = Runtime.getRuntime().exec(cmd);
            agents.put(nm, prs);
            final TCFTask<String> waiting = TCFLocalAgent.waitAgentReady(nm);
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        int n = prs.waitFor();
                        final StringBuffer sbf = new StringBuffer();
                        if (n != 0) {
                            char[] cbf = new char[256];
                            InputStreamReader r = new InputStreamReader(prs.getErrorStream());
                            try {
                                int rd;
                                while ((rd = r.read(cbf)) >= 0) {
                                    sbf.append(cbf, 0, rd);
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            try {
                                r.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            sbf.append("TCF " + nm + " exited with code ");
                            sbf.append(n);
                            Protocol.invokeLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (waiting.isDone()) {
                                        return;
                                    }
                                    waiting.error((Throwable)new IOException(sbf.toString()));
                                }
                            });
                        }
                        Class<TCFLocalAgent> clazz = TCFLocalAgent.class;
                        synchronized (TCFLocalAgent.class) {
                            if (agents.get(nm) == prs) {
                                if (n != 0 && !destroed) {
                                    Activator.log(sbf.toString(), null);
                                }
                                agents.remove(nm);
                            }
                            // ** MonitorExit[var3_4] (shouldn't be in output)
                        }
                    }
                    catch (InterruptedException x) {
                        Activator.log("TCF " + nm + " monitor interrupted", x);
                    }
                    {
                        return;
                    }
                }
            };
            t.setDaemon(true);
            t.setName("TCF Agent Monitor");
            t.start();
            return (String)waiting.getIO();
        }
        catch (Throwable x) {
            agents.remove(nm);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tcf.debug", 0, "Cannot start local TCF " + nm + ".", x));
        }
    }

    private static boolean isLocalAgent(IPeer p, String nm) {
        String prot = p.getTransportName();
        if (prot.equals("PIPE")) {
            return true;
        }
        if (prot.equals("UNIX")) {
            String port = (String)p.getAttributes().get("Port");
            return ports.get(nm).equals(port);
        }
        String host = (String)p.getAttributes().get("Host");
        String port = (String)p.getAttributes().get("Port");
        return LOCAL_HOST.equals(host) && ports.get(nm).equals(port);
    }

    public static synchronized String getLocalAgentID(final String nm) {
        return (String)new TCFTask<String>(){
            int cnt;

            public void run() {
                ILocator locator = Protocol.getLocator();
                for (IPeer p : locator.getPeers().values()) {
                    if (!TCFLocalAgent.isLocalAgent(p, nm)) continue;
                    this.done(p.getID());
                    return;
                }
                if (this.cnt++ < 10) {
                    Protocol.invokeLater((long)100L, (Runnable)((Object)this));
                } else {
                    this.done(null);
                }
            }
        }.getE();
    }

    private static TCFTask<String> waitAgentReady(final String nm) {
        return new TCFTask<String>(){

            public void run() {
                final ILocator locator = Protocol.getLocator();
                for (IPeer p : locator.getPeers().values()) {
                    if (!TCFLocalAgent.isLocalAgent(p, nm)) continue;
                    this.done(p.getID());
                    return;
                }
                final ILocator.LocatorListener listener = new ILocator.LocatorListener(){

                    public void peerAdded(IPeer p) {
                        if (!this.isDone() && TCFLocalAgent.isLocalAgent(p, nm)) {
                            this.done(p.getID());
                            locator.removeListener((ILocator.LocatorListener)this);
                        }
                    }

                    public void peerChanged(IPeer peer) {
                    }

                    public void peerHeartBeat(String id) {
                    }

                    public void peerRemoved(String id) {
                    }
                };
                locator.addListener(listener);
                Protocol.invokeLater((long)30000L, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!this.isDone()) {
                            this.error(new Exception("Timeout waiting for TCF Agent to start"));
                            locator.removeListener(listener);
                        }
                    }
                });
            }
        };
    }

    public static synchronized void destroy() {
        destroed = true;
        for (Process prs : agents.values()) {
            prs.destroy();
        }
        agents.clear();
    }
}

