/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.building;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.building.ITmfGraphProvider;
import org.eclipse.tracecompass.analysis.graph.core.building.ITraceEventHandler;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class AbstractTmfGraphProvider
implements ITmfGraphProvider {
    private static final Comparator<ITraceEventHandler> HANDLER_COMPARATOR = (o1, o2) -> {
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        int res = Integer.compare(o1.getPriority(), o2.getPriority());
        return res != 0 ? res : o1.getClass().getName().compareTo(o2.getClass().getName());
    };
    private final ITmfTrace fTrace;
    private final List<ITraceEventHandler> fHandlers;
    private boolean fGraphAssigned;
    private @Nullable TmfGraph fGraph = null;
    private @Nullable ITmfGraph fNewGraph = null;

    public AbstractTmfGraphProvider(ITmfTrace trace, String id) {
        this.fTrace = trace;
        this.fGraphAssigned = false;
        this.fHandlers = new ArrayList<ITraceEventHandler>();
    }

    @Override
    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    @Override
    public long getStartTime() {
        return this.fTrace.getStartTime().toNanos();
    }

    @Override
    @Deprecated
    public void assignTargetGraph(TmfGraph graph) {
        this.fGraph = graph;
        this.fGraphAssigned = true;
    }

    @Override
    @Deprecated
    public @Nullable TmfGraph getAssignedGraph() {
        return this.fGraph;
    }

    @Override
    public void assignGraph(@NonNull ITmfGraph graph) {
        this.fNewGraph = graph;
        this.fGraphAssigned = true;
    }

    @Override
    public @Nullable ITmfGraph getGraph() {
        return this.fNewGraph;
    }

    @Override
    public void processEvent(ITmfEvent event) {
        if (!this.fGraphAssigned) {
            return;
        }
        this.eventHandle(event);
    }

    @Override
    public void dispose() {
        this.fGraphAssigned = false;
        this.fGraph = null;
        this.fNewGraph = null;
    }

    @Override
    public void done() {
    }

    protected void eventHandle(ITmfEvent event) {
        for (ITraceEventHandler handler : this.fHandlers) {
            handler.handleEvent(event);
        }
    }

    @Override
    public void handleCancel() {
    }

    public void registerHandler(ITraceEventHandler handler) {
        int pos = Collections.binarySearch(this.fHandlers, handler, HANDLER_COMPARATOR);
        if (pos < 0) {
            this.fHandlers.add(-pos - 1, handler);
        }
    }

    @VisibleForTesting
    protected List<ITraceEventHandler> getHandlers() {
        return ImmutableList.copyOf(this.fHandlers);
    }
}

