/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.figure;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.draw2d.border.CompoundBorder;
import org.eclipse.wb.draw2d.border.LineBorder;
import org.eclipse.wb.draw2d.border.MarginBorder;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.draw2d.Label;
import org.eclipse.wb.internal.draw2d.VerticalLabel;

public final class TextFeedback {
    private final Layer m_layer;
    private final Label m_label;
    private Dimension m_size;

    public TextFeedback(Layer layer, boolean isHorizontal) {
        this.m_layer = layer;
        this.m_label = isHorizontal ? new Label() : new VerticalLabel();
        this.m_label.setOpaque(true);
        this.m_label.setBackground(IColorConstants.tooltipBackground);
        this.m_label.setForeground(IColorConstants.tooltipForeground);
        LineBorder outer = new LineBorder(IColorConstants.tooltipForeground);
        MarginBorder inner = new MarginBorder(2);
        this.m_label.setBorder(new CompoundBorder(outer, inner));
    }

    public TextFeedback(Layer layer) {
        this(layer, true);
    }

    public void add() {
        this.m_layer.add(this.m_label);
    }

    public void remove() {
        this.m_layer.remove(this.m_label);
    }

    public Dimension getSize() {
        return this.m_label.getSize().getCopy();
    }

    public void setText(String text) {
        this.m_label.setText(text);
        this.m_label.setSize(this.m_label.getPreferredSize());
        this.m_size = this.m_label.getSize();
    }

    public void setBackground(Color color) {
        this.m_label.setBackground(color);
    }

    public void setLocation(Point location) {
        this.m_label.setLocation(location);
    }

    public void setData(Object data) {
        this.m_label.setData(data);
    }

    public void centerHorizontallyAbove(Rectangle target, int shift) {
        int x = target.x + (target.width - this.m_size.width) / 2;
        int y = target.y - this.m_size.height - shift;
        y = Math.max(y, 1);
        this.m_label.setLocation(x, y);
    }

    public void moveRightOuter(Rectangle target, int shift) {
        int x = target.right() + shift;
        int y = target.bottom() - this.m_size.height;
        this.m_label.setLocation(x, y);
    }

    public void moveTopLeftCenter(Point location) {
        int x = location.x - this.m_size.width / 2;
        int y = location.y - this.m_size.height / 2;
        this.m_label.setLocation(x, y);
    }
}

