/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.gef.header.edit;

import com.jgoodies.forms.layout.ColumnSpec;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.Graphics;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.swing.FormLayout.Activator;
import org.eclipse.wb.internal.swing.FormLayout.gef.GefMessages;
import org.eclipse.wb.internal.swing.FormLayout.gef.header.actions.DimensionHeaderAction;
import org.eclipse.wb.internal.swing.FormLayout.gef.header.actions.SetAlignmentAction;
import org.eclipse.wb.internal.swing.FormLayout.gef.header.actions.SetGrowAction;
import org.eclipse.wb.internal.swing.FormLayout.gef.header.edit.DimensionHeaderEditPart;
import org.eclipse.wb.internal.swing.FormLayout.model.FormColumnInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.ui.ColumnEditDialog;

public class ColumnHeaderEditPart
extends DimensionHeaderEditPart<FormColumnInfo> {
    private final FormColumnInfo m_column;

    public ColumnHeaderEditPart(FormLayoutInfo layout, FormColumnInfo column, Figure containerFigure) {
        super(layout, column, containerFigure);
        this.m_column = column;
    }

    protected Figure createFigure() {
        Figure newFigure = new Figure(){

            protected void paintClientArea(Graphics graphics) {
                Image image;
                Rectangle r = this.getClientArea();
                graphics.setForegroundColor(IColorConstants.buttonDarker);
                graphics.drawLine(r.x, r.y, r.x, r.bottom());
                graphics.drawLine(r.right() - 1, r.y, r.right() - 1, r.bottom());
                String title = "" + (1 + ColumnHeaderEditPart.this.getIndex());
                Dimension textExtents = graphics.getTextExtent(title);
                if (r.width < 3 + textExtents.width + 3) {
                    return;
                }
                int titleLeft = r.x + (r.width - textExtents.width) / 2;
                int titleRight = titleLeft + textExtents.width;
                int y = r.y + (r.height - textExtents.height) / 2;
                graphics.setForegroundColor(IColorConstants.black);
                graphics.drawText(title, titleLeft, y);
                if (titleLeft - r.x > 13) {
                    image = ColumnHeaderEditPart.this.m_column.getAlignment() == ColumnSpec.LEFT ? this.getImage("left.gif") : (ColumnHeaderEditPart.this.m_column.getAlignment() == ColumnSpec.RIGHT ? this.getImage("right.gif") : (ColumnHeaderEditPart.this.m_column.getAlignment() == ColumnSpec.CENTER ? this.getImage("center.gif") : this.getImage("fill.gif")));
                    int x = r.x + 2;
                    this.drawCentered(graphics, image, x);
                }
                if (ColumnHeaderEditPart.this.m_column.hasGrow() && titleRight + 3 + 7 + 3 < r.right()) {
                    image = this.getImage("grow.gif");
                    this.drawCentered(graphics, image, r.right() - 3 - image.getBounds().width);
                }
            }

            private Image getImage(String name) {
                return ColumnHeaderEditPart.this.getImage("alignment/h/" + name);
            }

            private void drawCentered(Graphics graphics, Image image, int x) {
                int y = (this.getBounds().height - image.getBounds().height) / 2;
                graphics.drawImage(image, x, y);
            }
        };
        newFigure.setFont(DEFAULT_FONT);
        newFigure.setOpaque(true);
        return newFigure;
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        int index = this.getIndex();
        Interval interval = this.m_layout.getGridInfo().getColumnIntervals()[index];
        Rectangle bounds = new Rectangle(interval.begin(), 0, interval.length() + 1, ((GraphicalEditPart)this.getParent()).getFigure().getSize().height);
        bounds.performTranslate(this.getOffset().x, 0);
        this.getFigure().setBounds(bounds);
    }

    @Override
    public int getIndex() {
        return this.m_layout.getColumns().indexOf(this.m_column);
    }

    public void buildContextMenu(IMenuManager manager) {
        if (!this.m_layout.canChangeDimensions()) {
            return;
        }
        manager.add((IAction)new DimensionHeaderAction<FormColumnInfo>((DimensionHeaderEditPart)this, GefMessages.ColumnHeaderEditPart_insertColumn){

            @Override
            protected void run(FormColumnInfo dimension) throws Exception {
                int index = ColumnHeaderEditPart.this.m_layout.getColumns().indexOf(dimension);
                ColumnHeaderEditPart.this.m_layout.insertColumn(index);
            }
        });
        manager.add((IAction)new DimensionHeaderAction<FormColumnInfo>((DimensionHeaderEditPart)this, GefMessages.ColumnHeaderEditPart_appendColumn){

            @Override
            protected void run(FormColumnInfo dimension) throws Exception {
                int index = ColumnHeaderEditPart.this.m_layout.getColumns().indexOf(dimension);
                ColumnHeaderEditPart.this.m_layout.insertColumn(index + 1);
            }
        });
        manager.add((IAction)new DimensionHeaderAction<FormColumnInfo>((DimensionHeaderEditPart)this, GefMessages.ColumnHeaderEditPart_deleteColumn){

            @Override
            protected void run(FormColumnInfo dimension) throws Exception {
                int index = ColumnHeaderEditPart.this.m_layout.getColumns().indexOf(dimension);
                ColumnHeaderEditPart.this.m_layout.deleteColumn(index);
            }
        });
        manager.add((IAction)new DimensionHeaderAction<FormColumnInfo>((DimensionHeaderEditPart)this, GefMessages.ColumnHeaderEditPart_DeleteContents){

            @Override
            protected void run(FormColumnInfo dimension) throws Exception {
                int index = ColumnHeaderEditPart.this.m_layout.getColumns().indexOf(dimension);
                ColumnHeaderEditPart.this.m_layout.deleteColumnContents(index);
            }
        });
        manager.add((IAction)new DimensionHeaderAction<FormColumnInfo>((DimensionHeaderEditPart)this, GefMessages.ColumnHeaderEditPart_splitColumn){

            @Override
            protected void run(FormColumnInfo dimension) throws Exception {
                int index = ColumnHeaderEditPart.this.m_layout.getColumns().indexOf(dimension);
                ColumnHeaderEditPart.this.m_layout.splitColumn(index);
            }
        });
        manager.add((IContributionItem)new Separator());
        manager.add(new SetAlignmentAction<FormColumnInfo>(this, GefMessages.ColumnHeaderEditPart_haLeft, Activator.getImageDescriptor("alignment/h/menu/left.gif"), ColumnSpec.LEFT));
        manager.add(new SetAlignmentAction<FormColumnInfo>(this, GefMessages.ColumnHeaderEditPart_haFill, Activator.getImageDescriptor("alignment/h/menu/fill.gif"), ColumnSpec.FILL));
        manager.add(new SetAlignmentAction<FormColumnInfo>(this, GefMessages.ColumnHeaderEditPart_haCenter, Activator.getImageDescriptor("alignment/h/menu/center.gif"), ColumnSpec.CENTER));
        manager.add(new SetAlignmentAction<FormColumnInfo>(this, GefMessages.ColumnHeaderEditPart_haRight, Activator.getImageDescriptor("alignment/h/menu/right.gif"), ColumnSpec.RIGHT));
        manager.add((IContributionItem)new Separator());
        manager.add(new SetGrowAction<FormColumnInfo>(this, GefMessages.ColumnHeaderEditPart_grow, Activator.getImageDescriptor("alignment/h/menu/grow.gif")));
        manager.add((IContributionItem)new Separator());
        this.addTemplateActions(manager, ((FormColumnInfo)this.m_dimension).getTemplates(true));
        MenuManager otherManager = new MenuManager(GefMessages.ColumnHeaderEditPart_otherTemplates);
        manager.add((IContributionItem)otherManager);
        this.addTemplateActions((IMenuManager)otherManager, ((FormColumnInfo)this.m_dimension).getTemplates(false));
        manager.add((IContributionItem)new Separator());
        DimensionHeaderAction<FormColumnInfo> action = new DimensionHeaderAction<FormColumnInfo>((DimensionHeaderEditPart)this, GefMessages.ColumnHeaderEditPart_group){

            @Override
            protected void run(List<FormColumnInfo> dimensions) throws Exception {
                ColumnHeaderEditPart.this.m_layout.groupColumns(dimensions);
            }
        };
        action.setEnabled(this.getViewer().getSelectedEditParts().size() >= 2);
        manager.add((IAction)action);
        action = new DimensionHeaderAction<FormColumnInfo>((DimensionHeaderEditPart)this, GefMessages.ColumnHeaderEditPart_unGroup){

            @Override
            protected void run(List<FormColumnInfo> dimensions) throws Exception {
                ColumnHeaderEditPart.this.m_layout.unGroupColumns(dimensions);
            }
        };
        manager.add((IAction)action);
        boolean hasGroup = false;
        for (EditPart editPart : this.getViewer().getSelectedEditParts()) {
            ColumnHeaderEditPart headerEditPart = (ColumnHeaderEditPart)editPart;
            if (this.m_layout.getColumnGroup(headerEditPart.m_column) == null) continue;
            hasGroup = true;
            break;
        }
        action.setEnabled(hasGroup);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new ObjectInfoAction((ObjectInfo)this.m_layout, GefMessages.ColumnHeaderEditPart_properties){

            protected void runEx() throws Exception {
                ColumnHeaderEditPart.this.editDimension();
            }
        });
    }

    @Override
    protected void editDimension() {
        new ColumnEditDialog(DesignerPlugin.getShell(), this.m_layout, this.m_column).open();
    }
}

