/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.msw.build;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.cdt.internal.msw.build.MSVCToolChainInfo;
import org.eclipse.cdt.internal.msw.build.VSInstallation;
import org.eclipse.cdt.internal.msw.build.VSInstallationRegistry;
import org.eclipse.cdt.internal.msw.build.VSVersionNumber;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.envvar.IProjectEnvironmentVariableSupplier;
import org.eclipse.cdt.utils.envvar.EnvVarOperationProcessor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class WinEnvironmentVariableSupplier
implements IConfigurationEnvironmentVariableSupplier,
IProjectEnvironmentVariableSupplier {
    private static Map<String, IBuildEnvironmentVariable> envvars;

    public WinEnvironmentVariableSupplier() {
        WinEnvironmentVariableSupplier.initvars();
    }

    public IBuildEnvironmentVariable getVariable(String variableName, IManagedProject project, IEnvironmentVariableProvider provider) {
        return envvars.get(variableName);
    }

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        return envvars.get(variableName);
    }

    public IBuildEnvironmentVariable[] getVariables(IManagedProject project, IEnvironmentVariableProvider provider) {
        return envvars.values().toArray(new IBuildEnvironmentVariable[envvars.size()]);
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        return envvars.values().toArray(new IBuildEnvironmentVariable[envvars.size()]);
    }

    public static IPath[] getIncludePath() {
        if (envvars == null) {
            return new IPath[0];
        }
        IBuildEnvironmentVariable var = envvars.get("INCLUDE");
        if (var == null) {
            return new IPath[0];
        }
        return EnvVarOperationProcessor.convertToList((String)var.getValue(), (String)var.getDelimiter()).stream().map(val -> Path.fromOSString((String)val)).collect(Collectors.toList()).toArray(new IPath[0]);
    }

    private static void addvar(IBuildEnvironmentVariable var) {
        envvars.put(var.getName(), var);
    }

    private static synchronized void initvars() {
        List<MSVCToolChainInfo> toolchains;
        if (envvars != null) {
            return;
        }
        envvars = new HashMap<String, IBuildEnvironmentVariable>();
        Map.Entry<VSVersionNumber, VSInstallation> vsInstallationEntry = VSInstallationRegistry.getVsInstallations().lastEntry();
        if (vsInstallationEntry != null && (toolchains = vsInstallationEntry.getValue().getToolchains()).size() != 0) {
            MSVCToolChainInfo toolChainInfo = toolchains.get(0);
            WinEnvironmentVariableSupplier.addvar(new WindowsBuildEnvironmentVariable("INCLUDE", toolChainInfo.getIncludeEnvVar(), 3));
            WinEnvironmentVariableSupplier.addvar(new WindowsBuildEnvironmentVariable("PATH", toolChainInfo.getPathEnvVar(), 3));
            WinEnvironmentVariableSupplier.addvar(new WindowsBuildEnvironmentVariable("LIB", toolChainInfo.getLibEnvVar(), 3));
        }
    }

    private static class WindowsBuildEnvironmentVariable
    implements IBuildEnvironmentVariable {
        private final String name;
        private final String value;
        private final int operation;

        public WindowsBuildEnvironmentVariable(String name, String value, int operation) {
            this.name = name;
            this.value = value;
            this.operation = operation;
        }

        public String getDelimiter() {
            return ";";
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public int getOperation() {
            return this.operation;
        }
    }
}

