/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.util.CDTListComparator;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.newui.Messages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.newui.AbstractPage;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExcludeFromBuildHandler
extends AbstractHandler {
    protected ArrayList<IResource> objects;
    protected ArrayList<String> cfgNames;

    public void setEnabled(Object context) {
        ISelection selection = this.getSelection(context);
        this.setEnabledFromSelection(selection);
    }

    protected ISelection getSelection(Object context) {
        Object s = HandlerUtil.getVariable((Object)context, (String)"activeMenuSelection");
        if (s instanceof ISelection) {
            return (ISelection)s;
        }
        return null;
    }

    public void setEnabledFromSelection(ISelection selection) {
        this.objects = null;
        this.cfgNames = null;
        boolean cfgsOK = true;
        if (selection != null && !selection.isEmpty()) {
            IFile file;
            Object[] obs = null;
            if (selection instanceof IStructuredSelection) {
                obs = ((IStructuredSelection)selection).toArray();
            } else if (selection instanceof ITextSelection && (file = this.getFileFromActiveEditor()) != null) {
                obs = Collections.singletonList(file).toArray();
            }
            if (obs != null && obs.length > 0) {
                int i = 0;
                while (i < obs.length && cfgsOK) {
                    ICConfigurationDescription[] cfgds;
                    if (obs[i] instanceof IProject || obs[i] instanceof ICProject) {
                        cfgsOK = false;
                        break;
                    }
                    IResource res = null;
                    if (obs[i] instanceof ICContainer || obs[i] instanceof ITranslationUnit) {
                        res = ((ICElement)obs[i]).getResource();
                    } else if (obs[i] instanceof IResource) {
                        res = (IResource)obs[i];
                    }
                    if (res != null && (cfgds = this.getCfgsRead(res)) != null && cfgds.length != 0) {
                        if (this.objects == null) {
                            this.objects = new ArrayList();
                        }
                        this.objects.add(res);
                        if (this.cfgNames == null) {
                            this.cfgNames = new ArrayList(cfgds.length);
                            j = 0;
                            while (j < cfgds.length) {
                                if (!this.canExclude(res, cfgds[j])) {
                                    this.cfgNames = null;
                                    cfgsOK = false;
                                    break;
                                }
                                this.cfgNames.add(cfgds[j].getName());
                                ++j;
                            }
                        } else if (this.cfgNames.size() != cfgds.length) {
                            cfgsOK = false;
                        } else {
                            j = 0;
                            while (j < cfgds.length) {
                                if (!this.canExclude(res, cfgds[j]) || !this.cfgNames.contains(cfgds[j].getName())) {
                                    cfgsOK = false;
                                    break;
                                }
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        this.setBaseEnabled(cfgsOK && this.objects != null);
    }

    private IFile getFileFromActiveEditor() {
        IEditorInput input;
        IEditorPart editor;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (editor = page.getActiveEditor()) != null && (input = editor.getEditorInput()) != null) {
            return (IFile)input.getAdapter(IFile.class);
        }
        return null;
    }

    private boolean canExclude(IResource res, ICConfigurationDescription cfg) {
        IPath p = res.getFullPath();
        ICSourceEntry[] ent = cfg.getSourceEntries();
        boolean state = CDataUtil.isExcluded((IPath)p, (ICSourceEntry[])ent);
        return CDataUtil.canExclude((IPath)p, (boolean)(res instanceof IFolder), (!state ? 1 : 0) != 0, (ICSourceEntry[])ent);
    }

    private void setExclude(IResource res, ICConfigurationDescription cfg, boolean exclude) {
        try {
            ICSourceEntry[] newEntries = CDataUtil.setExcluded((IPath)res.getFullPath(), (boolean)(res instanceof IFolder), (boolean)exclude, (ICSourceEntry[])cfg.getSourceEntries());
            cfg.setSourceEntries(newEntries);
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.openDialog();
        return null;
    }

    private ICConfigurationDescription[] getCfgsRead(IResource res) {
        IProject p = res.getProject();
        if (!p.isOpen()) {
            return null;
        }
        if (!CoreModel.getDefault().isNewStyleProject(p)) {
            return null;
        }
        ICProjectDescription prjd = CoreModel.getDefault().getProjectDescription(p, false);
        if (prjd == null) {
            return null;
        }
        ICConfigurationDescription[] cfgs = prjd.getConfigurations();
        Arrays.sort(cfgs, CDTListComparator.getInstance());
        return cfgs;
    }

    private void openDialog() {
        if (this.objects == null || this.objects.size() == 0) {
            return;
        }
        ListSelectionDialog dialog = new ListSelectionDialog(CUIPlugin.getActiveWorkbenchShell(), this.cfgNames, this.createSelectionDialogContentProvider(), (ILabelProvider)new LabelProvider(){}, ActionMessages.ExcludeFromBuildAction_0);
        dialog.setTitle(ActionMessages.ExcludeFromBuildAction_1);
        boolean[] status = new boolean[this.cfgNames.size()];
        for (IResource res : this.objects) {
            ICConfigurationDescription[] cfgds = this.getCfgsRead(res);
            IPath p = res.getFullPath();
            int i = 0;
            while (i < cfgds.length) {
                boolean b = CDataUtil.isExcluded((IPath)p, (ICSourceEntry[])cfgds[i].getSourceEntries());
                if (b) {
                    status[i] = true;
                }
                ++i;
            }
        }
        ArrayList<String> lst = new ArrayList<String>();
        int i = 0;
        while (i < status.length) {
            if (status[i]) {
                lst.add(this.cfgNames.get(i));
            }
            ++i;
        }
        if (lst.size() > 0) {
            dialog.setInitialElementSelections(lst);
        }
        if (dialog.open() == 0) {
            Object[] selected = dialog.getResult();
            for (IResource res : this.objects) {
                ICProjectDescription prjd;
                IProject p = res.getProject();
                if (!p.isOpen() || (prjd = CoreModel.getDefault().getProjectDescription(p, true)) == null) continue;
                ICConfigurationDescription[] cfgds = prjd.getConfigurations();
                int i2 = 0;
                while (i2 < cfgds.length) {
                    boolean exclude = false;
                    int j = 0;
                    while (j < selected.length) {
                        if (cfgds[i2].getName().equals(selected[j])) {
                            exclude = true;
                            break;
                        }
                        ++j;
                    }
                    this.setExclude(res, cfgds[i2], exclude);
                    ++i2;
                }
                try {
                    CoreModel.getDefault().setProjectDescription(p, prjd);
                }
                catch (CoreException e) {
                    CUIPlugin.logError(String.valueOf(Messages.AbstractPage_11) + e.getLocalizedMessage());
                }
                AbstractPage.updateViews(res);
            }
        }
    }

    private IStructuredContentProvider createSelectionDialogContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ExcludeFromBuildHandler.this.cfgNames.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }
}

