/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;

public class TextUtilities {
    public static TextUtilities INSTANCE = new TextUtilities();

    public Dimension getStringExtents(String s, Font f) {
        return FigureUtilities.getStringExtents(s, f);
    }

    public Dimension getTextExtents(String s, Font f) {
        return FigureUtilities.getTextExtents(s, f);
    }

    public int getAscent(Font font) {
        FontMetrics fm = FigureUtilities.getFontMetrics(font);
        return fm.getHeight() - fm.getDescent();
    }

    public int getDescent(Font font) {
        return FigureUtilities.getFontMetrics(font).getDescent();
    }

    public int getLargestSubstringConfinedTo(String s, Font f, int availableWidth) {
        FontMetrics metrics = FigureUtilities.getFontMetrics(f);
        float avg = metrics.getAverageCharWidth();
        int min = 0;
        int max = s.length() + 1;
        int guess = 0;
        int guessSize = 0;
        while (max - min > 1) {
            if ((guess += (int)((float)(availableWidth - guessSize) / avg)) >= max) {
                guess = max - 1;
            }
            if (guess <= min) {
                guess = min + 1;
            }
            if ((guessSize = this.getTextExtents((String)s.substring((int)0, (int)guess), (Font)f).width) < availableWidth) {
                min = guess;
                continue;
            }
            max = guess;
        }
        return min;
    }
}

