/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.net4j.util.concurrent.IRWLockManager;

public class LockObjectsRequest
extends CDOClientRequest<CDOSessionProtocol.LockObjectsResult> {
    private int viewID;
    private IRWLockManager.LockType lockType;
    private long timeout;
    private List<CDORevisionKey> revisionKeys;
    private boolean recursive;

    public LockObjectsRequest(CDOClientProtocol protocol, List<CDORevisionKey> revisionKeys, int viewID, IRWLockManager.LockType lockType, boolean recursive, long timeout) {
        this(protocol, 24, revisionKeys, viewID, lockType, recursive, timeout);
    }

    protected LockObjectsRequest(CDOClientProtocol protocol, short signalID, List<CDORevisionKey> revisionKeys, int viewID, IRWLockManager.LockType lockType, boolean recursive, long timeout) {
        super(protocol, signalID);
        this.viewID = viewID;
        this.lockType = lockType;
        this.timeout = timeout;
        this.revisionKeys = revisionKeys;
        this.recursive = recursive;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeXInt(this.viewID);
        out.writeCDOLockType(this.lockType);
        out.writeBoolean(this.recursive);
        out.writeXLong(this.timeout);
        out.writeXInt(this.revisionKeys.size());
        for (CDORevisionKey revKey : this.revisionKeys) {
            out.writeCDORevisionKey(revKey);
        }
    }

    @Override
    protected CDOSessionProtocol.LockObjectsResult confirming(CDODataInput in) throws IOException {
        boolean succesful = in.readBoolean();
        boolean timeout = in.readBoolean();
        boolean waitForUpdate = in.readBoolean();
        long timestamp = in.readXLong();
        long requiredTimestamp = in.readXLong();
        int nStaleRevisions = in.readXInt();
        CDORevisionKey[] staleRevisions = new CDORevisionKey[nStaleRevisions];
        int i = 0;
        while (i < nStaleRevisions) {
            staleRevisions[i] = in.readCDORevisionKey();
            ++i;
        }
        List lockDeltas = in.readCDOLockDeltas();
        List lockStates = in.readCDOLockStates();
        return new CDOSessionProtocol.LockObjectsResult(succesful, timeout, waitForUpdate, requiredTimestamp, staleRevisions, lockDeltas, lockStates, timestamp);
    }

    protected String getAdditionalInfo() {
        return "viewID=" + this.viewID + ", lockType=" + this.lockType + ", timeout=" + this.timeout + ", revisionKeys=" + this.revisionKeys + ", recursive=" + this.recursive;
    }
}

