/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.installer.ui;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.installer.Messages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class ProxiesDialog {
    private IProxyData data;
    private Label typeLabel;
    private Combo typeCombo;
    private Label hostLabel;
    private Text hostText;
    private Label portLabel;
    private Text portText;
    private Label userIdLabel;
    private Text userIdText;
    private Label passwordLabel;
    private Text passwordText;
    private Button okButton;
    private Button cancelButton;
    private final IProxyService service;
    private Shell shell;
    private List<String> types;
    private Label statuslabel;

    public ProxiesDialog(IProxyService service) {
        if (service == null) {
            throw new IllegalArgumentException();
        }
        this.service = service;
        this.initTypes();
    }

    public IProxyData getValue() {
        return this.data;
    }

    public void open() {
        this.data = this.service.getProxyData("HTTP");
        if (this.data == null) {
            this.openMessage(Messages.ProxiesDialog_FailedToReadProxySettingsMessage, 33);
            return;
        }
        Shell activeShell = Display.getDefault().getActiveShell();
        this.shell = new Shell(activeShell, 67824);
        Rectangle bounds = null;
        if (activeShell == null) {
            bounds = new Rectangle(300, 200, 600, 400);
        } else {
            Rectangle parentBounds = activeShell.getBounds();
            bounds = new Rectangle(parentBounds.x + 100, parentBounds.y + 100, 600, 400);
        }
        this.shell.setBounds(bounds);
        this.shell.setText(Messages.ProxiesDialog_DialogTitle);
        this.shell.setLayout((Layout)new GridLayout());
        this.createDialogArea((Composite)this.shell);
        this.createButtonBar((Composite)this.shell);
        this.shell.pack();
        this.shell.open();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.typeLabel = new Label(composite, 0);
        this.typeLabel.setText(Messages.ProxiesDialog_ShemaLabel);
        this.typeLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.typeCombo = new Combo(composite, 2048);
        this.typeCombo.setLayoutData((Object)new GridData(16384, 128, false, false, 3, 1));
        for (String type : this.types) {
            this.typeCombo.add(type);
        }
        this.typeCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String selection = this.typeCombo.getText();
            IProxyData selectedProxy = this.service.getProxyData(selection);
            if (selectedProxy == null) {
                this.updateStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.installer", 0, Messages.ProxiesDialog_UnknownProxyTypeMessage, null));
            } else {
                this.data = selectedProxy;
                this.applyData();
            }
        }));
        this.hostLabel = new Label(composite, 0);
        this.hostLabel.setText(Messages.ProxiesDialog_HostLabel);
        this.hostLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.hostText = new Text(composite, 2048);
        GridData gdata = new GridData(4, 128, true, false);
        gdata.widthHint = 250;
        this.hostText.setLayoutData((Object)gdata);
        this.portLabel = new Label(composite, 0);
        this.portLabel.setText(Messages.ProxiesDialog_PortLabel);
        this.portText = new Text(composite, 2048);
        gdata = new GridData();
        gdata.widthHint = 30;
        this.portText.setLayoutData((Object)gdata);
        this.userIdLabel = new Label(composite, 0);
        this.userIdLabel.setText(Messages.ProxiesDialog_UserLabel);
        this.userIdLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.userIdText = new Text(composite, 2048);
        this.userIdText.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        this.passwordLabel = new Label(composite, 0);
        this.passwordLabel.setLayoutData((Object)new GridData(16384, 128, false, true, 1, 1));
        this.passwordLabel.setText(Messages.ProxiesDialog_PasswordLabel);
        this.passwordText = new Text(composite, 2048);
        this.passwordText.setEchoChar('*');
        this.passwordText.setLayoutData((Object)new GridData(4, 128, true, true, 3, 1));
        ModifyListener validationListener = e -> this.updateStatus();
        this.typeCombo.addModifyListener(validationListener);
        this.hostText.addModifyListener(validationListener);
        this.portText.addModifyListener(validationListener);
        this.userIdText.addModifyListener(validationListener);
        this.passwordText.addModifyListener(validationListener);
        this.applyData();
        this.hostText.setFocus();
        this.updateStatus();
        return composite;
    }

    private void createButtonBar(Composite parent) {
        Composite buttonBar = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 131072;
        buttonBar.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonBar.setLayout((Layout)layout);
        this.statuslabel = new Label(buttonBar, 0);
        gridData = new GridData(300, -1);
        this.statuslabel.setLayoutData((Object)gridData);
        this.okButton = new Button(buttonBar, 8);
        gridData = new GridData(100, -1);
        this.okButton.setLayoutData((Object)gridData);
        this.okButton.setText(Messages.ProxiesDialog_OkLabel);
        this.okButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.okPressed();
            this.shell.dispose();
        }));
        this.cancelButton = new Button(buttonBar, 8);
        this.cancelButton.setLayoutData((Object)gridData);
        this.cancelButton.setText(Messages.Dialog_CancelButton);
        this.cancelButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.shell.dispose()));
    }

    public void create() {
        this.validateHostName();
    }

    private String toString(String str) {
        return str == null ? "" : str;
    }

    private void applyData() {
        this.typeCombo.setText(this.toString(this.data.getType()));
        this.hostText.setText(this.toString(this.data.getHost()));
        if (this.data.getPort() != -1) {
            this.portText.setText(this.toString(Integer.toString(this.data.getPort())));
        } else {
            this.portText.setText("");
        }
        this.userIdText.setText(this.toString(this.data.getUserId()));
        this.passwordText.setText(this.toString(this.data.getPassword()));
    }

    private boolean validateHostName() {
        try {
            new URI(this.hostText.getText());
        }
        catch (URISyntaxException uRISyntaxException) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.installer", 0, Messages.ProxiesDialog_InvalitHostMessage, null));
            return false;
        }
        return true;
    }

    protected void okPressed() {
        this.data.setHost(this.hostText.getText());
        this.data.setPort(Integer.parseInt(this.portText.getText()));
        this.data.setUserid(this.userIdText.getText());
        this.data.setPassword(this.passwordText.getText());
        try {
            if (this.service != null) {
                this.service.setProxyData(new IProxyData[]{this.data});
            } else {
                this.openMessage(Messages.ProxiesDialog_ServiceNotAvailableMessage, 33);
            }
        }
        catch (Exception e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.installer", e.getMessage(), (Throwable)e));
            this.openMessage(Messages.ProxiesDialog_FailedToSetProxyMessage + e.getLocalizedMessage(), 33);
        }
    }

    protected void updateStatus() {
        if (!this.validateHostName()) {
            return;
        }
        if (this.hostText.getText().length() == 0) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.installer", 0, Messages.ProxiesDialog_EmptyHostMessage, null));
            return;
        }
        if (this.userIdText.getText().length() == 0) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.installer", 0, Messages.ProxiesDialog_EmptyUserMessage, null));
            return;
        }
        if (this.passwordText.getText().length() == 0) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.installer", 0, Messages.ProxiesDialog_EmptyPasswordMessage, null));
            return;
        }
        try {
            String portAsString = this.portText.getText();
            if (portAsString == null || portAsString.length() == 0) {
                this.updateStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.installer", 0, Messages.ProxiesDialog_EmptyProtMessage, null));
                return;
            }
            int port = Integer.parseInt(portAsString);
            if (port < 0) {
                this.updateStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.installer", 0, Messages.ProxiesDialog_NegativValue, null));
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.installer", 0, Messages.ProxiesDialog_WrongFormat, null));
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }

    private void updateStatus(IStatus status) {
        if (this.okButton != null) {
            this.okButton.setEnabled(status.isOK());
        }
        if (this.statuslabel != null) {
            String statusText = status.isOK() ? "" : Messages.ProxiesDialog_StatusPrefix + status.getMessage();
            this.statuslabel.setText(statusText);
        }
    }

    private void openMessage(String msg, int style) {
        MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), style);
        messageBox.setMessage(msg);
        messageBox.open();
    }

    private void initTypes() {
        this.types = new ArrayList<String>();
        this.types.add("HTTP");
        this.types.add("HTTPS");
        this.types.add("SOCKS");
    }
}

