/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dtmanager.converter.internal;

import java.net.URL;
import java.util.HashMap;
import javax.servlet.jsp.el.ELException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IImageDescriptorProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IResourceURLProvider;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.converter.ITagConverter;
import org.eclipse.jst.pagedesigner.dtmanager.DTManager;
import org.eclipse.jst.pagedesigner.dtmanager.IDTInfo;
import org.eclipse.jst.pagedesigner.dtmanager.converter.ITagConverterDecorator;
import org.eclipse.jst.pagedesigner.dtmanager.converter.internal.AttributeValueResolverRegistryReader;
import org.eclipse.jst.pagedesigner.dtmanager.converter.internal.DTTagConverter;
import org.eclipse.jst.pagedesigner.dtmanager.converter.internal.IAttributeValueResolver;
import org.eclipse.jst.pagedesigner.dtmanager.dtinfo.ResolveAttributeValue;
import org.eclipse.jst.pagedesigner.dtmanager.dtinfo.TagDecorateInfo;
import org.eclipse.jst.pagedesigner.preview.PageExpressionContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DTTagConverterDecorator
implements ITagConverterDecorator {
    private static final String DECORATE_INFO_ID_DESIGN = "vpd-decorate-design";
    private static final String DECORATE_INFO_ID_PREVIEW = "vpd-decorate-preview";
    private static final String MD_PLUGIN_LOCATION = "$metadata-plugin-location$";

    @Override
    public void decorate(ITagConverter tagConverter) {
        if (!(tagConverter instanceof DTTagConverter)) {
            throw new IllegalArgumentException("ITagConverter argument must be an instance of DTTagConverter");
        }
        DTTagConverter dtTagConverter = (DTTagConverter)tagConverter;
        if (dtTagConverter.getMode() == 0) {
            this.decorateFromDTInfo(dtTagConverter, DECORATE_INFO_ID_DESIGN);
        } else if (dtTagConverter.getMode() == 1) {
            this.decorateFromDTInfo(dtTagConverter, DECORATE_INFO_ID_PREVIEW);
        }
        if (tagConverter.getResultElement() == null && tagConverter.isVisualByHTML()) {
            this.createUnknownTagRepresentation(dtTagConverter);
        }
    }

    protected void decorateFromDTInfo(DTTagConverter dtTagConverter, String tagDecorateInfoID) {
        TagDecorateInfo tdInfo;
        Element srcElement = dtTagConverter.getHostElement();
        DTManager dtManager = DTManager.getInstance();
        IDTInfo dtInfo = dtManager.getDTInfo(srcElement);
        if (dtInfo != null && (tdInfo = dtInfo.getTagDecorateInfo(tagDecorateInfoID)) != null) {
            String attributeName;
            dtTagConverter.setMultiLevel(tdInfo.isMultiLevel());
            dtTagConverter.setNeedBorderDecorator(tdInfo.isNeedBorderDecorator());
            dtTagConverter.setNeedTableDecorator(tdInfo.isNeedTableDecorator());
            if (tdInfo.isNonVisual()) {
                this.setNonVisual(dtTagConverter, dtInfo, tdInfo.getNonVisualImagePath());
            }
            if (tdInfo.isResolveChildText()) {
                this.resolveChildText(dtTagConverter.getResultElement(), dtInfo);
            }
            if (tdInfo.isSetNonVisualChildElements()) {
                this.setNonVisualChildElements(dtTagConverter, srcElement);
            }
            dtTagConverter.setWidget(tdInfo.isWidget());
            dtTagConverter.setMinHeight(tdInfo.getMinHeight());
            dtTagConverter.setMinWidth(tdInfo.getMinWidth());
            ResolveAttributeValue resAttrValue = tdInfo.getResolveAttributeValue();
            if (resAttrValue != null && (attributeName = resAttrValue.getAttributeName()) != null && attributeName.length() > 0) {
                this.resolveAttributeValue(dtTagConverter.getHostElement(), dtTagConverter.getResultElement(), attributeName, dtInfo, tagDecorateInfoID);
            }
        }
    }

    protected void createUnknownTagRepresentation(DTTagConverter dtTagConverter) {
        Element element = dtTagConverter.createElement("span");
        element.setAttribute("style", "color:red;font-weight:bold;");
        Text text = dtTagConverter.createText("<" + dtTagConverter.getHostElement().getTagName() + "/>");
        element.appendChild(text);
        dtTagConverter.setResultElement(element);
        dtTagConverter.setWidget(true);
    }

    protected void setNonVisualChildElements(DTTagConverter dtTagConverter, Element srcElement) {
        NodeList childNodes = srcElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node curNode = childNodes.item(i);
            if (curNode.getNodeType() == 1) {
                dtTagConverter.addNonVisualChildElement((Element)curNode);
            }
            ++i;
        }
    }

    protected void resolveChildText(Element srcElement, IDTInfo dtInfo) {
        if (srcElement != null) {
            NodeList childNodes = srcElement.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node childNode = childNodes.item(i);
                if (childNode.getNodeType() == 3) {
                    Text textNode = (Text)childNode;
                    String textNodeValue = textNode.getNodeValue();
                    try {
                        String newTextNodeValue;
                        if (textNodeValue.contains(MD_PLUGIN_LOCATION)) {
                            newTextNodeValue = this.resolveMDPluginLocation(textNodeValue, dtInfo);
                        } else {
                            HashMap<String, Element> options = new HashMap<String, Element>();
                            options.put("ELEMENT", srcElement);
                            newTextNodeValue = (String)PageExpressionContext.getCurrent().evaluateExpression(textNodeValue, String.class, options);
                        }
                        if (newTextNodeValue != null && !textNodeValue.equals(newTextNodeValue)) {
                            textNode.setNodeValue(newTextNodeValue);
                        }
                    }
                    catch (Exception exception) {}
                }
                ++i;
            }
        }
    }

    protected void resolveAttributeValue(Element srcElement, Element targetElement, String attributeName, IDTInfo dtInfo, String tagDecorateInfoID) {
        if (targetElement != null) {
            String newAttributeValue;
            String oldAttributeValue = null;
            String targetAttributeName = attributeName;
            if (attributeName.contains("/")) {
                int lastSlashPos = attributeName.lastIndexOf("/");
                String xPathExpression = attributeName.substring(0, lastSlashPos);
                XPath xPath = XPathFactory.newInstance().newXPath();
                try {
                    Node parentNode;
                    Object resultObject = xPath.evaluate(xPathExpression, targetElement, XPathConstants.NODE);
                    if (resultObject instanceof Element) {
                        targetElement = (Element)resultObject;
                        targetAttributeName = attributeName.substring(lastSlashPos + 1);
                    } else if (resultObject instanceof Text && (parentNode = ((Text)resultObject).getParentNode()) instanceof Element) {
                        parentNode.normalize();
                        targetAttributeName = "#text";
                        oldAttributeValue = ((Text)resultObject).getNodeValue();
                    }
                }
                catch (XPathExpressionException xPathExpressionException) {}
            }
            if (!"#text".equals(targetAttributeName)) {
                oldAttributeValue = targetElement.getAttribute(targetAttributeName);
            }
            if (oldAttributeValue != null && oldAttributeValue.length() > 0 && (newAttributeValue = oldAttributeValue.contains(MD_PLUGIN_LOCATION) ? this.resolveMDPluginLocation(oldAttributeValue, dtInfo) : this.resolveAttributeValue(srcElement, targetElement, targetAttributeName, oldAttributeValue, tagDecorateInfoID)) != null && !oldAttributeValue.equals(newAttributeValue)) {
                if ("#text".equals(targetAttributeName)) {
                    int i = targetElement.getChildNodes().getLength() - 1;
                    while (i >= 0) {
                        Node childNode = targetElement.getChildNodes().item(i);
                        if (childNode.getNodeType() == 3) {
                            targetElement.removeChild(childNode);
                        }
                        --i;
                    }
                    targetElement.appendChild(targetElement.getOwnerDocument().createTextNode(newAttributeValue));
                } else {
                    targetElement.setAttribute(targetAttributeName, newAttributeValue);
                }
            }
        }
    }

    private String resolveAttributeValue(final Element originalElement, final Element convertedElement, final String convertedAttributeName, final String oldAttributeValue, String tagDecorateInfoID) {
        String newValue = null;
        boolean valueResolved = false;
        final String[] result = new String[1];
        for (final IAttributeValueResolver resolver : AttributeValueResolverRegistryReader.getInstance().getExtensions()) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    PDPlugin.log("While resolving attribute in converter decorator", exception);
                }

                public void run() throws Exception {
                    if (resolver.canResolve(originalElement, convertedElement, convertedAttributeName, oldAttributeValue)) {
                        result[0] = resolver.resolveAttribute(originalElement, convertedElement, convertedAttributeName, oldAttributeValue);
                    }
                }
            });
            if (result[0] == null) continue;
            newValue = result[0];
            valueResolved = true;
            break;
        }
        if (!valueResolved && tagDecorateInfoID.equals(DECORATE_INFO_ID_PREVIEW)) {
            try {
                PageExpressionContext current = PageExpressionContext.getCurrent();
                if (current != null) {
                    HashMap<String, Element> options = new HashMap<String, Element>();
                    options.put("ELEMENT", originalElement);
                    return (String)current.evaluateExpression(oldAttributeValue, String.class, options);
                }
            }
            catch (ELException eLException) {}
        }
        return newValue;
    }

    protected String resolveMDPluginLocation(String input, IDTInfo dtInfo) {
        String output = input;
        if (input != null && input.contains(MD_PLUGIN_LOCATION)) {
            int tokenStart = input.indexOf(MD_PLUGIN_LOCATION);
            int tokenEnd = tokenStart + MD_PLUGIN_LOCATION.length();
            String prefix = input.substring(0, tokenStart);
            String suffix = input.substring(tokenEnd);
            Trait trait = dtInfo.getTrait();
            IMetaDataSourceModelProvider mdSourceModelProvider = trait.getSourceModelProvider();
            IResourceURLProvider resourceURLProvider = (IResourceURLProvider)mdSourceModelProvider.getAdapter(IResourceURLProvider.class);
            URL url = resourceURLProvider.getResourceURL("/META-INF/");
            String resolvedToken = url.toExternalForm();
            resolvedToken = resolvedToken.substring(0, resolvedToken.length() - 10);
            output = String.valueOf(prefix) + resolvedToken + suffix;
        }
        return output;
    }

    protected void setNonVisual(DTTagConverter dtTagConverter, IDTInfo dtInfo, String imagePath) {
        Trait trait;
        IImageDescriptorProvider imgDescProvider;
        dtTagConverter.setVisualByHTML(false);
        if (imagePath != null && imagePath.length() > 0 && (imgDescProvider = (IImageDescriptorProvider)(trait = dtInfo.getTrait()).getSourceModelProvider().getAdapter(IImageDescriptorProvider.class)) != null) {
            ImageDescriptor imageDescriptor = imgDescProvider.getImageDescriptor(imagePath);
            dtTagConverter.setVisualImageDescriptor(imageDescriptor);
        }
    }
}

