/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.ui.views;

import java.util.List;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.linuxtools.internal.vagrant.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.vagrant.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.vagrant.ui.views.VagrantVMComparator;
import org.eclipse.linuxtools.internal.vagrant.ui.views.VagrantVMContentProvider;
import org.eclipse.linuxtools.vagrant.core.EnumVMStatus;
import org.eclipse.linuxtools.vagrant.core.IVagrantConnection;
import org.eclipse.linuxtools.vagrant.core.IVagrantVM;
import org.eclipse.linuxtools.vagrant.core.IVagrantVMListener;
import org.eclipse.linuxtools.vagrant.core.VagrantService;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public class VagrantVMView
extends ViewPart
implements IVagrantVMListener {
    public static final String VIEW_ID = "org.eclipse.linuxtools.vagrant.ui.vagrantVMView";
    private static final String DaemonMissing = "ViewerDaemonMissing.msg";
    private Form form;
    private Text search;
    private TableViewer viewer;
    private IVagrantConnection connection;

    public void setFocus() {
    }

    public void dispose() {
        this.connection.removeVMListener((IVagrantVMListener)this);
        super.dispose();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.form = toolkit.createForm(parent);
        this.form.setText(DVMessages.getString(DaemonMissing));
        Composite container = this.form.getBody();
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)container);
        this.createTableViewer(container);
        this.getSite().registerContextMenu(new MenuManager(), null);
        this.hookContextMenu();
    }

    private void createTableViewer(Composite container) {
        this.search = new Text(container, 640);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.search);
        this.search.addModifyListener(this.onSearch());
        Composite tableArea = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).applyTo(tableArea);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)tableArea);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableArea.setLayout((Layout)tableLayout);
        this.viewer = new TableViewer(tableArea, 66306);
        this.viewer.setContentProvider((IContentProvider)new VagrantVMContentProvider());
        Table table = this.viewer.getTable();
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).applyTo((Composite)table);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)table);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableViewerColumn nameColumn = this.createColumn(DVMessages.getString("NAME"));
        this.setLayout(nameColumn, tableLayout, 150);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IVagrantVM) {
                    return ((IVagrantVM)element).name();
                }
                return super.getText(element);
            }

            /*
             * WARNING - void declaration
             */
            public Image getImage(Object element) {
                Object object = element;
                if (object instanceof IVagrantVM) {
                    void container;
                    IVagrantVM iVagrantVM = (IVagrantVM)object;
                    IVagrantVM cfr_ignored_0 = (IVagrantVM)object;
                    String state = container.state();
                    if (EnumVMStatus.RUNNING.equals((Object)EnumVMStatus.fromStatusMessage((String)state))) {
                        return SWTImagesFactory.DESC_CONTAINER_STARTED.createImage();
                    }
                    return SWTImagesFactory.DESC_CONTAINER_STOPPED.createImage();
                }
                return super.getImage(element);
            }
        });
        TableViewerColumn imageColumn = this.createColumn(DVMessages.getString("PROVIDER"));
        this.setLayout(imageColumn, tableLayout, 150);
        imageColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IVagrantVM) {
                    return ((IVagrantVM)element).provider();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn creationDateColumn = this.createColumn(DVMessages.getString("STATE"));
        this.setLayout(creationDateColumn, tableLayout, 150);
        creationDateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IVagrantVM) {
                    return ((IVagrantVM)element).state();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn commandColumn = this.createColumn(DVMessages.getString("STATE_DESC"));
        this.setLayout(commandColumn, tableLayout, 150);
        commandColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IVagrantVM) {
                    return ((IVagrantVM)element).state_desc();
                }
                return super.getText(element);
            }
        });
        VagrantVMComparator comparator = new VagrantVMComparator(this.viewer);
        this.viewer.setComparator((ViewerComparator)comparator);
        this.viewer.addFilter(this.getContainersFilter());
        this.setConnection(VagrantService.getInstance());
        this.connection.addVMListener((IVagrantVMListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private TableViewerColumn createColumn(String title) {
        TableViewerColumn propertyColumn = new TableViewerColumn(this.viewer, 2048);
        propertyColumn.getColumn().setText(title);
        propertyColumn.getColumn().addSelectionListener(this.onColumnSelected());
        return propertyColumn;
    }

    private SelectionListener onColumnSelected() {
        return SelectionListener.widgetSelectedAdapter(e -> {
            TableColumn sortColumn = (TableColumn)e.getSource();
            VagrantVMComparator comparator = (VagrantVMComparator)this.viewer.getComparator();
            comparator.setColumn(sortColumn);
            this.viewer.refresh();
        });
    }

    private void setLayout(TableViewerColumn viewerColumn, TableColumnLayout tableLayout, int weight) {
        tableLayout.setColumnData((Widget)viewerColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(weight, true));
    }

    private ModifyListener onSearch() {
        return e -> this.viewer.refresh();
    }

    private ViewerFilter getContainersFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IVagrantVM) {
                    return element.toString().contains(VagrantVMView.this.search.getText());
                }
                return false;
            }
        };
    }

    public void listChanged(IVagrantConnection connection, List<IVagrantVM> containers) {
        if (!this.viewer.getControl().isDisposed()) {
            Display.getDefault().asyncExec(() -> {
                ISelection currentSelection = this.viewer.getSelection();
                this.viewer.refresh();
                this.refreshViewTitle();
                if (currentSelection != null) {
                    this.viewer.setSelection(currentSelection);
                }
            });
        }
    }

    public IVagrantConnection getConnection() {
        return this.connection;
    }

    public void setConnection(IVagrantConnection conn) {
        this.connection = conn;
        if (conn != null) {
            this.viewer.setInput((Object)conn);
            this.refreshViewTitle();
        } else {
            this.viewer.setInput((Object)new IVagrantVM[0]);
            this.form.setText(DVMessages.getString(DaemonMissing));
        }
    }

    public IStructuredSelection getStructuredSelection() {
        if (this.viewer != null) {
            return this.viewer.getStructuredSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    private void refreshViewTitle() {
        if (this.viewer == null || this.viewer.getControl().isDisposed() || this.form == null || this.connection == null) {
            return;
        }
        if (!this.connection.isVMsLoaded()) {
            this.form.setText(this.connection.getName());
        } else {
            this.form.setText(DVMessages.getFormattedString("VagrantVMViewTitle.all.msg", this.connection.getName(), Integer.toString(this.connection.getVMs().size())));
        }
    }
}

