/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.callhierarchy;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4j.CallHierarchyItem;
import org.eclipse.lsp4j.Range;

public class CallHierarchyViewTreeNode {
    private final @NonNull CallHierarchyItem callContainer;
    private final @Nullable Range callSite;
    private @Nullable CallHierarchyViewTreeNode parent;
    private @Nullable CallHierarchyViewTreeNode[] children;

    public CallHierarchyViewTreeNode(@NonNull CallHierarchyItem callContainer, @Nullable Range callSite) {
        this.callContainer = callContainer;
        this.callSite = callSite;
    }

    public CallHierarchyViewTreeNode(@NonNull CallHierarchyItem callContainer) {
        this.callContainer = callContainer;
        this.callSite = null;
    }

    public @Nullable CallHierarchyViewTreeNode getParent() {
        return this.parent;
    }

    public void setParent(CallHierarchyViewTreeNode parent) {
        this.parent = parent;
    }

    public @Nullable CallHierarchyViewTreeNode[] getChildren() {
        return this.children;
    }

    public void setChildren(@NonNull List<CallHierarchyViewTreeNode> children) {
        this.children = children.toArray(new CallHierarchyViewTreeNode[children.size()]);
    }

    public @NonNull CallHierarchyItem getCallContainer() {
        return this.callContainer;
    }

    public @Nullable Range getCallSite() {
        return this.callSite;
    }

    public @NonNull Range getSelectionRange() {
        Range theCallSite = this.callSite;
        if (theCallSite != null) {
            return theCallSite;
        }
        return this.callContainer.getSelectionRange();
    }

    public boolean isRecursive() {
        String uri = this.callContainer.getUri();
        CallHierarchyViewTreeNode ancestor = this.parent;
        while (ancestor != null) {
            if (uri.equals(ancestor.getCallContainer().getUri())) {
                return true;
            }
            ancestor = ancestor.getParent();
        }
        return false;
    }
}

