/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.ui.views;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.buffer.IBufferHandler;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.internal.ui.messages.Messages;
import org.eclipse.net4j.internal.ui.views.AbstractTransportView;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.signal.ISignalProtocol;
import org.eclipse.net4j.signal.Indication;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.signal.Request;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.signal.Signal;
import org.eclipse.net4j.signal.SignalFinishedEvent;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.ui.Net4jItemProvider;
import org.eclipse.net4j.ui.shared.SharedIcons;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.actions.SafeAction;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.views.ContainerView;
import org.eclipse.net4j.util.ui.views.IElementFilter;
import org.eclipse.spi.net4j.ChannelContainer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ChannelsView
extends ContainerView
implements IElementFilter {
    public static final String ID = "org.eclipse.net4j.ChannelsView";
    private static final StyledString.Styler ERROR_STYLER = StyledString.createColorRegistryStyler((String)"ERROR_COLOR", null);
    private final Map<IChannel, LinkedList<LogEntry>> logs = new HashMap<IChannel, LinkedList<LogEntry>>();
    private final ChannelContainer channelContainer = new ChannelContainer((IContainer)IPluginContainer.INSTANCE){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeElement(IChannel channel) {
            Map<IChannel, LinkedList<LogEntry>> map = ChannelsView.this.logs;
            synchronized (map) {
                ChannelsView.this.logs.remove(channel);
            }
            return super.removeElement((Object)channel);
        }

        protected void notifyProtocolEvent(IEvent event) {
            if (event instanceof SignalFinishedEvent) {
                SignalFinishedEvent e = (SignalFinishedEvent)event;
                ChannelsView.this.notifySignalFinished(e);
            }
        }
    };
    private final IAction clearLogsAction = new ClearLogAction(null);

    protected ChannelContainer getContainer() {
        return this.channelContainer;
    }

    public boolean filter(Object element) {
        return element instanceof IChannel;
    }

    protected Control createUI(Composite parent) {
        this.channelContainer.activate();
        return super.createUI(parent);
    }

    public void dispose() {
        this.channelContainer.deactivate();
        super.dispose();
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        super.fillLocalToolBar(manager);
        manager.add(this.clearLogsAction);
    }

    protected void fillContextMenu(IMenuManager manager, ITreeSelection selection) {
        super.fillContextMenu(manager, selection);
        IChannel channel = (IChannel)UIUtil.getElement((ISelection)selection, IChannel.class);
        if (channel != null) {
            manager.add((IAction)new ClearLogAction(channel));
        }
    }

    protected ContainerItemProvider<IContainer<Object>> createContainerItemProvider() {
        return new Net4jItemProvider(this){

            public void sort(Viewer viewer, Object[] elements) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasChildren(Object element) {
                if (element instanceof IChannel) {
                    LinkedList<LogEntry> log;
                    IChannel channel = (IChannel)element;
                    Map<IChannel, LinkedList<LogEntry>> map = ChannelsView.this.logs;
                    synchronized (map) {
                        log = ChannelsView.this.logs.get(channel);
                    }
                    return log != null;
                }
                return super.hasChildren(element);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object[] getChildren(Object element) {
                if (element instanceof IChannel) {
                    LinkedList<LogEntry> log;
                    IChannel channel = (IChannel)element;
                    Object object = ChannelsView.this.logs;
                    synchronized (object) {
                        log = ChannelsView.this.logs.get(channel);
                    }
                    if (log != null) {
                        object = log;
                        synchronized (object) {
                            return log.toArray(new LogEntry[log.size()]);
                        }
                    }
                }
                return super.getChildren(element);
            }

            protected void handleElementEvent(IEvent event) {
                super.handleElementEvent(event);
                INotifier source = event.getSource();
                if (source instanceof IProtocol) {
                    IProtocol protocol = (IProtocol)source;
                    this.updateLabels(protocol.getChannel());
                }
            }

            @Override
            public Image getImage(Object obj) {
                if (obj instanceof LogEntry) {
                    return ((LogEntry)obj).getType().getImage();
                }
                return super.getImage(obj);
            }

            public StyledString getStyledText(Object obj) {
                StyledString styledText = super.getStyledText(obj);
                if (obj instanceof IChannel) {
                    IChannel channel = (IChannel)obj;
                    this.decorateChannel(styledText, channel);
                } else if (obj instanceof LogEntry) {
                    LogEntry entry = (LogEntry)obj;
                    this.decorateLogEntry(styledText, entry);
                }
                return styledText;
            }

            private void decorateChannel(StyledString styledText, IChannel channel) {
                AbstractTransportView.decorateChannelInfraStructure(styledText, channel);
                IBufferHandler receiveHandler = channel.getReceiveHandler();
                if (receiveHandler instanceof ISignalProtocol.WithSignalCounters) {
                    ISignalProtocol.WithSignalCounters counters = (ISignalProtocol.WithSignalCounters)receiveHandler;
                    AbstractTransportView.decorateCounters(styledText, counters.getReceivedSignals(), counters.getSentSignals());
                }
            }

            private void decorateLogEntry(StyledString styledText, LogEntry entry) {
                String error = entry.getError();
                if (error != null) {
                    styledText.append("  " + error, ERROR_STYLER);
                } else {
                    long duration = entry.getDuration();
                    if (duration != -1L) {
                        styledText.append("  " + duration + " ms", StyledString.COUNTER_STYLER);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySignalFinished(SignalFinishedEvent<?> event) {
        IChannel channel;
        SignalProtocol protocol = event.getSignal().getProtocol();
        if (protocol != null && (channel = protocol.getChannel()) != null) {
            LinkedList<LogEntry> log;
            Object object = this.logs;
            synchronized (object) {
                log = this.logs.get(channel);
                if (log == null) {
                    log = new LinkedList();
                    this.logs.put(channel, log);
                }
            }
            object = log;
            synchronized (object) {
                log.addFirst(new LogEntry(event));
            }
            this.refreshElement(channel, false);
        }
    }

    private final class ClearLogAction
    extends SafeAction {
        private final IChannel channel;

        private ClearLogAction(IChannel channel) {
            super(Messages.getString("ChannelsView." + (channel == null ? "1" : "0")), SharedIcons.getDescriptor((String)"etool16/clear_log.png"));
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void safeRun() throws Exception {
            Map<IChannel, LinkedList<LogEntry>> map = ChannelsView.this.logs;
            synchronized (map) {
                if (this.channel == null) {
                    ChannelsView.this.logs.clear();
                } else {
                    ChannelsView.this.logs.remove(this.channel);
                }
            }
            ChannelsView.this.refreshViewer(true);
        }
    }

    private static final class LogEntry {
        private final Type type;
        private final String text;
        private final String error;
        private final long duration;

        public LogEntry(SignalFinishedEvent<?> event) {
            Signal signal = event.getSignal();
            this.type = signal instanceof RequestWithConfirmation ? Type.REQUEST_SYNC : (signal instanceof Request ? Type.REQUEST_ASYNC : (signal instanceof IndicationWithResponse ? Type.INDICATION_SYNC : (signal instanceof Indication ? Type.INDICATION_ASYNC : Type.SIGNAL)));
            this.text = signal.toString(true);
            this.duration = event.getDuration();
            Exception exception = event.getException();
            this.error = exception == null ? null : exception.getMessage();
        }

        public Type getType() {
            return this.type;
        }

        public String getText() {
            return this.text;
        }

        public String getError() {
            return this.error;
        }

        public long getDuration() {
            return this.duration;
        }

        public String toString() {
            return this.getText();
        }

        public static enum Type {
            SIGNAL("obj16/signal"),
            REQUEST_SYNC("obj16/request_sync"),
            REQUEST_ASYNC("obj16/request_async"),
            INDICATION_SYNC("obj16/indication_sync"),
            INDICATION_ASYNC("obj16/indication_async");

            private final Image image;

            private Type(String key) {
                this.image = SharedIcons.getImage((String)key);
            }

            public Image getImage() {
                return this.image;
            }
        }
    }
}

