/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.build.fragments;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GenModelHelper {
    private @NonNull ResourceSet resourceSet;
    private @Nullable Map<String, GenPackage> genPackageMap = null;

    public GenModelHelper(@NonNull ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public @Nullable String getEcoreLiteralName(@NonNull EStructuralFeature eFeature) {
        try {
            GenFeature genFeature = this.getGenFeature(eFeature);
            return genFeature.getGenClass().getFeatureID(genFeature);
        }
        catch (IOException e) {
            return null;
        }
    }

    protected @NonNull GenClass getGenClass(@NonNull EClass eClass) throws IOException {
        GenPackage genPackage = this.getGenPackage((EClassifier)eClass);
        if (genPackage != null) {
            String name = eClass.getName();
            for (GenClass genClass : genPackage.getGenClasses()) {
                String clsName = genClass.getEcoreClass().getName();
                if (!name.equals(clsName)) continue;
                return genClass;
            }
        }
        throw new IOException("No GenClass for " + eClass);
    }

    public @NonNull GenFeature getGenFeature(@NonNull EStructuralFeature eStructuralFeature) throws IOException {
        EClass eClass = eStructuralFeature.getEContainingClass();
        if (eClass != null) {
            GenClass genClass = this.getGenClass(eClass);
            String name = eStructuralFeature.getName();
            for (GenFeature genFeature : genClass.getGenFeatures()) {
                String featureName = genFeature.getEcoreFeature().getName();
                if (!name.equals(featureName)) continue;
                return genFeature;
            }
        }
        throw new IOException("No GenFeature for " + eStructuralFeature);
    }

    public @Nullable GenPackage getGenPackage(@NonNull EClassifier eClassifier) {
        EPackage ePackage = eClassifier.getEPackage();
        if (ePackage == null) {
            return null;
        }
        return this.getGenPackage(ePackage);
    }

    public @Nullable GenPackage getGenPackage(@NonNull EPackage ePackage) {
        String nsURI = ePackage.getNsURI();
        if (nsURI == null) {
            return null;
        }
        return this.getGenPackage(nsURI);
    }

    private void addGenPackage(@NonNull GenPackage genPackage) {
        Map<String, GenPackage> genPackageMap2 = this.genPackageMap;
        if (genPackageMap2 == null) {
            this.genPackageMap = genPackageMap2 = new HashMap<String, GenPackage>();
        }
        genPackageMap2.put(genPackage.getNSURI(), genPackage);
    }

    private @Nullable GenPackage getGenPackage(@NonNull String nsURI) {
        GenPackage genPackage;
        if (this.genPackageMap != null && (genPackage = this.genPackageMap.get(nsURI)) != null) {
            return genPackage;
        }
        URI uri = (URI)EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)true).get(nsURI);
        if (uri != null) {
            Resource resource = this.resourceSet.getResource(uri, true);
            for (EObject eObject : resource.getContents()) {
                if (!(eObject instanceof GenModel)) continue;
                GenModel genModel = (GenModel)eObject;
                genModel.reconcile();
                for (GenPackage genPackage2 : genModel.getGenPackages()) {
                    if (genPackage2 == null) continue;
                    this.addGenPackage(genPackage2);
                    return genPackage2;
                }
            }
        }
        return null;
    }

    public @NonNull String getLiteralName(@NonNull EClassifier eClassifier) {
        String name = eClassifier.getName();
        return CodeGenUtil.upperName((String)(name != null ? name : ""));
    }

    public @Nullable String getQualifiedPackageInterfaceName(@NonNull EPackage ePackage) {
        GenPackage genPackage = this.getGenPackage(ePackage);
        if (genPackage == null) {
            return null;
        }
        return genPackage.getQualifiedPackageInterfaceName();
    }
}

