/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.util.List;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.IStateDeltaListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.product.DependenciesPage;
import org.eclipse.pde.internal.ui.editor.product.ProductEditor;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.pde.internal.ui.wizards.product.ProductDefinitionWizard;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class ProductInfoSection
extends PDESection
implements IRegistryChangeListener,
IStateDeltaListener {
    private ExtensionIdComboPart fAppCombo;
    private ExtensionIdComboPart fProductCombo;
    private Button fPluginButton;
    private Button fFeatureButton;
    private Button fMixedButton;
    private static final int NUM_COLUMNS = 3;

    public ProductInfoSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.ProductInfoSection_title);
        section.setDescription(PDEUIMessages.ProductInfoSection_desc);
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout(false, 1));
        TableWrapData data = new TableWrapData(256);
        data.colspan = 2;
        section.setLayoutData((Object)data);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 3));
        this.createProductEntry(client, toolkit);
        this.createApplicationEntry(client, toolkit);
        this.createConfigurationOption(client, toolkit);
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
        PDECore.getDefault().getExtensionsRegistry().addListener((IRegistryChangeListener)this);
        PDECore.getDefault().getModelManager().addStateDeltaListener((IStateDeltaListener)this);
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        PDECore.getDefault().getExtensionsRegistry().removeListener((IRegistryChangeListener)this);
        PDECore.getDefault().getModelManager().removeStateDeltaListener((IStateDeltaListener)this);
        super.dispose();
    }

    private void createProductEntry(Composite client, FormToolkit toolkit) {
        Label label = toolkit.createLabel(client, PDEUIMessages.ProductInfoSection_product);
        label.setToolTipText(PDEUIMessages.ProductInfoSection_productTooltip);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fProductCombo = new ExtensionIdComboPart();
        this.fProductCombo.createControl(client, toolkit, 8);
        this.fProductCombo.getControl().setLayoutData((Object)new GridData(768));
        this.fProductCombo.setItems(TargetPlatform.getProducts());
        this.fProductCombo.add("");
        this.fProductCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.getProduct().setProductId(this.fProductCombo.getSelection())));
        Button button = toolkit.createButton(client, PDEUIMessages.ProductInfoSection_new, 8);
        button.setEnabled(this.isEditable());
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleNewDefinition()));
        this.fProductCombo.getControl().setEnabled(this.isEditable());
    }

    private void handleNewDefinition() {
        ProductDefinitionWizard wizard = new ProductDefinitionWizard(this.getProduct());
        WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        dialog.create();
        if (dialog.open() == 0) {
            String id = wizard.getProductId();
            IProduct product = this.getProduct();
            product.setProductId(id);
            product.setApplication(wizard.getApplication());
        }
    }

    private void createApplicationEntry(Composite client, FormToolkit toolkit) {
        Label label = toolkit.createLabel(client, PDEUIMessages.ProductInfoSection_app, 64);
        label.setToolTipText(PDEUIMessages.ProductInfoSection_appTooltip);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fAppCombo = new ExtensionIdComboPart();
        this.fAppCombo.createControl(client, toolkit, 8);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fAppCombo.getControl().setLayoutData((Object)gd);
        this.fAppCombo.setItems(TargetPlatform.getApplications());
        this.fAppCombo.add("");
        this.fAppCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.getProduct().setApplication(this.fAppCombo.getSelection())));
        this.fAppCombo.getControl().setEnabled(this.isEditable());
    }

    private void createConfigurationOption(Composite client, FormToolkit toolkit) {
        Composite comp = toolkit.createComposite(client);
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        comp.setLayoutData((Object)gd);
        FormText text = toolkit.createFormText(comp, true);
        text.setText(PDEUIMessages.Product_overview_configuration, true, true);
        text.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
                ProductInfoSection.this.getStatusLineManager().setMessage(e.getLabel());
            }

            public void linkExited(HyperlinkEvent e) {
                ProductInfoSection.this.getStatusLineManager().setMessage(null);
            }

            public void linkActivated(HyperlinkEvent e) {
                String pageId = DependenciesPage.TYPE_2_ID.get(ProductInfoSection.this.getProduct().getType());
                ProductInfoSection.this.getPage().getEditor().setActivePage(pageId);
            }
        });
        this.fPluginButton = this.createTypeButton(toolkit, comp, IProduct.ProductType.BUNDLES, PDEUIMessages.ProductInfoSection_plugins);
        this.fFeatureButton = this.createTypeButton(toolkit, comp, IProduct.ProductType.FEATURES, PDEUIMessages.ProductInfoSection_features);
        this.fMixedButton = this.createTypeButton(toolkit, comp, IProduct.ProductType.MIXED, PDEUIMessages.ProductInfoSection_mixed);
    }

    private Button createTypeButton(FormToolkit toolkit, Composite comp, IProduct.ProductType type, String label) {
        Button btn = toolkit.createButton(comp, label, 16);
        GridData gd = new GridData();
        gd.horizontalIndent = 25;
        btn.setLayoutData((Object)gd);
        btn.setEnabled(this.isEditable());
        btn.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IProduct product = this.getProduct();
            if (btn.getSelection() && product.getType() != type) {
                product.setType(type);
                ((ProductEditor)this.getPage().getEditor()).updateConfigurationPage();
            }
        }));
        return btn;
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    public void refresh() {
        IProduct product = this.getProduct();
        if (product.getProductId() != null) {
            this.refreshProductCombo(product.getProductId());
        }
        if (product.getApplication() != null) {
            this.fAppCombo.setText(product.getApplication());
        }
        this.fPluginButton.setSelection(product.getType() == IProduct.ProductType.BUNDLES);
        this.fFeatureButton.setSelection(product.getType() == IProduct.ProductType.FEATURES);
        this.fMixedButton.setSelection(product.getType() == IProduct.ProductType.MIXED);
        super.refresh();
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged();
            return;
        }
        String prop = e.getChangedProperty();
        if (prop == null) {
            return;
        }
        if (prop.equals("id")) {
            this.refreshProductCombo(e.getNewValue().toString());
        } else if (prop.equals("application")) {
            this.fAppCombo.setText(e.getNewValue().toString());
        }
    }

    private void handleModelEventWorldChanged() {
        List<Boolean> previousSelection = this.getSelections();
        this.refresh();
        this.revertConfigurationPage(previousSelection);
    }

    private void revertConfigurationPage(List<Boolean> previousSelection) {
        if (previousSelection.equals(this.getSelections())) {
            return;
        }
        IFormPage currentPage = this.getPage().getEditor().getActivePageInstance();
        if (currentPage instanceof DependenciesPage) {
            this.getPage().getEditor().setActivePage("overview");
        }
        ((ProductEditor)this.getPage().getEditor()).updateConfigurationPage();
    }

    private List<Boolean> getSelections() {
        return List.of(Boolean.valueOf(this.fPluginButton.getSelection()), Boolean.valueOf(this.fFeatureButton.getSelection()), Boolean.valueOf(this.fMixedButton.getSelection()));
    }

    private void refreshProductCombo(String productID) {
        if (productID == null) {
            productID = "";
        } else if (this.fProductCombo.indexOf(productID) == -1) {
            this.fProductCombo.add(productID, 0);
        }
        this.fProductCombo.setText(productID);
    }

    private IStatusLineManager getStatusLineManager() {
        IEditorSite site = this.getPage().getEditor().getEditorSite();
        return site.getActionBars().getStatusLineManager();
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        Control c = d.getFocusControl();
        return c instanceof Text;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] productDeltas;
        IExtensionDelta[] applicationDeltas = event.getExtensionDeltas("org.eclipse.core.runtime", "applications");
        if (applicationDeltas.length + (productDeltas = event.getExtensionDeltas("org.eclipse.core.runtime", "products")).length == 0) {
            return;
        }
        Display.getDefault().syncExec(() -> {
            this.fAppCombo.handleExtensionDelta(applicationDeltas);
            this.fProductCombo.handleExtensionDelta(productDeltas);
        });
    }

    public void stateChanged(State newState) {
        String[] products = TargetPlatform.getProducts();
        String[] finalProducts = new String[products.length + 1];
        System.arraycopy(products, 0, finalProducts, 0, products.length);
        finalProducts[products.length] = "";
        String[] apps = TargetPlatform.getApplications();
        String[] finalApps = new String[apps.length + 1];
        System.arraycopy(apps, 0, finalApps, 0, apps.length);
        finalApps[apps.length] = "";
        Display.getDefault().syncExec(() -> {
            this.fAppCombo.reload(finalApps);
            this.fProductCombo.reload(finalProducts);
        });
    }

    public void stateResolved(StateDelta delta) {
    }

    class ExtensionIdComboPart
    extends ComboPart
    implements SelectionListener {
        private String fRemovedId;

        ExtensionIdComboPart() {
        }

        @Override
        public void createControl(Composite parent, FormToolkit toolkit, int style) {
            super.createControl(parent, toolkit, style);
            this.addSelectionListener(this);
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.getSelectionIndex() != this.getItemCount() - 1) {
                this.fRemovedId = null;
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private void addItem(String item, int index) {
            int selection = this.getSelectionIndex();
            super.add(item, index);
            if (item.equals(this.fRemovedId)) {
                this.select(index);
                this.fRemovedId = null;
            } else if (selection >= index) {
                this.select(selection + 1);
            }
        }

        private void removeItem(int index) {
            int selection = this.getSelectionIndex();
            if (index == selection) {
                this.fRemovedId = this.getSelection();
                this.select(this.getItemCount() - 2);
            }
            super.remove(index);
            if (selection > index) {
                this.select(selection - 1);
            }
        }

        public void handleExtensionDelta(IExtensionDelta[] deltas) {
            IExtensionDelta[] iExtensionDeltaArray = deltas;
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IExtensionDelta delta = iExtensionDeltaArray[n2];
                IExtension extension = delta.getExtension();
                if (extension == null) {
                    return;
                }
                String id = extension.getUniqueIdentifier();
                if (id != null) {
                    if (delta.getKind() == 1) {
                        index = this.computeIndex(id);
                        if (index >= 0) {
                            this.addItem(id, index);
                        }
                    } else {
                        index = this.indexOf(id);
                        if (index >= 0) {
                            this.removeItem(index);
                        }
                    }
                }
                ++n2;
            }
        }

        private int computeIndex(String newId) {
            int i = 0;
            String[] entries = this.getItems();
            while (i < entries.length - 1) {
                int compareValue = entries[i].compareTo(newId);
                if (compareValue == 0) {
                    return -1;
                }
                if (compareValue > 0) break;
                ++i;
            }
            return i;
        }

        public void reload(String[] newItems) {
            if (this.fRemovedId == null) {
                this.fRemovedId = this.getSelection();
            }
            this.setItems(newItems);
            int index = this.indexOf(this.fRemovedId);
            if (index > 0) {
                this.select(index);
                this.fRemovedId = null;
            }
        }
    }
}

