/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.intel.internal.errorparsers;

import java.io.File;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class IntelCompilerErrorParser
implements IErrorParser {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processLine(String line, ErrorParserManager eoParser) {
        StringTokenizer tokenizer = new StringTokenizer(line, ":");
        if (line.startsWith("fortcom: ")) {
            try {
                tokenizer.nextToken();
                String severitystr = tokenizer.nextToken().trim();
                if (severitystr.equals("Severe")) {
                    String message = tokenizer.nextToken("\r\n").substring(2).trim();
                    if (message.startsWith("No such file or directory")) {
                        eoParser.appendToScratchBuffer(message);
                        return false;
                    }
                    eoParser.generateMarker(null, -1, message, 3, null);
                    return false;
                }
                String filestr = tokenizer.nextToken(",").substring(2).trim();
                String linestr = tokenizer.nextToken(":").substring(2).trim();
                String message = tokenizer.nextToken("\r\n").substring(2).trim();
                IFile file = eoParser.findFileName(filestr);
                int severity = -1;
                if (severitystr.equals("Info")) {
                    severity = 0;
                } else if (severitystr.equals("Warning")) {
                    severity = 1;
                } else if (severitystr.equals("Error")) {
                    severity = 2;
                }
                int lineno = Integer.parseInt(linestr.substring(5));
                eoParser.generateMarker((IResource)file, lineno, message, severity, null);
                return false;
            }
            catch (Throwable file) {
                return false;
            }
        }
        if (eoParser.getScratchBuffer().startsWith("No such file or directory")) {
            String buffer = eoParser.getScratchBuffer();
            eoParser.clearScratchBuffer();
            String message = String.valueOf(buffer) + ' ' + line;
            eoParser.generateMarker(null, -1, message, 3, null);
            return false;
        }
        int firstColon = line.indexOf(58);
        String desc = line.substring(firstColon + 1).trim();
        int secondColon = desc.indexOf(58);
        if (firstColon != -1 && secondColon != -1) {
            String firstPart = line.substring(0, firstColon);
            int leftParen = firstPart.indexOf("(");
            if (leftParen != -1) {
                StringTokenizer tok = new StringTokenizer(firstPart, "()");
                if (tok.hasMoreTokens()) {
                    String fileName = tok.nextToken();
                    if (!tok.hasMoreTokens()) return false;
                    String lineNumber = tok.nextToken();
                    try {
                        IFile file;
                        int num = Integer.parseInt(lineNumber);
                        int i = fileName.lastIndexOf(File.separatorChar);
                        String fileName2 = fileName;
                        if (i != -1) {
                            fileName2 = fileName.substring(i + 1);
                        }
                        if ((file = eoParser.findFileName(fileName2)) == null) {
                            file = eoParser.findFileName(fileName);
                        }
                        if (file != null || eoParser.isConflictingName(fileName)) {
                            String middle = desc.substring(0, secondColon);
                            int severity = -1;
                            if (middle.indexOf("warning") != -1) {
                                severity = 1;
                            }
                            if (middle.indexOf("error") != -1) {
                                severity = 2;
                            }
                            if (middle.indexOf("remark") != -1) {
                                severity = 0;
                            }
                            if (file == null) {
                                desc = "*" + desc;
                            }
                            if (severity != 1 && severity != 2) {
                                if (severity != 0) return false;
                            }
                            eoParser.generateMarker((IResource)file, num, desc, severity, null);
                            return false;
                        }
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
            } else {
                if (firstPart.indexOf("icl") == -1 && firstPart.indexOf("icc") == -1 && firstPart.indexOf("icpc") == -1 && firstPart.indexOf("ifort") == -1 && firstPart.indexOf("xilink") == -1 && firstPart.indexOf("xild") == -1 && firstPart.indexOf("xiar") == -1 && firstPart.indexOf("xilib") == -1) {
                    if (line.indexOf("Command-line error: invalid macro definition: -D") == -1) return false;
                    int severity = 2;
                    eoParser.generateMarker(null, 0, line, severity, null);
                    return false;
                }
                String middle = desc.substring(0, secondColon);
                int severity = -1;
                if (middle.indexOf("warning") != -1) {
                    severity = 1;
                }
                if (middle.indexOf("error") != -1) {
                    severity = 2;
                }
                if (middle.indexOf("remark") != -1) {
                    severity = 0;
                }
                if (severity != 1 && severity != 2) {
                    if (severity != 0) return false;
                }
                eoParser.generateMarker(null, -1, desc, severity, null);
                return false;
            }
        }
        if (line.indexOf("Catastrophic error: could not open source file") == -1) return false;
        int severity = 2;
        eoParser.generateMarker(null, -1, line, severity, null);
        return false;
    }
}

