/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.serial.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.cdt.serial.SerialPort;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.serial.internal.core.Activator;

public class SerialPortCommandShell
implements IRemoteProcess {
    private final IRemoteConnection remoteConnection;
    private final SerialPort serialPort;

    public SerialPortCommandShell(IRemoteConnection remoteConnection, SerialPort serialPort) throws IOException {
        this.remoteConnection = remoteConnection;
        this.serialPort = serialPort;
        serialPort.open();
    }

    public synchronized void destroy() {
        if (this.serialPort.isOpen()) {
            try {
                this.serialPort.close();
            }
            catch (IOException e) {
                Activator.log(e);
            }
            this.notifyAll();
        }
    }

    public int exitValue() {
        return 0;
    }

    public InputStream getErrorStream() {
        return new InputStream(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int read() throws IOException {
                SerialPortCommandShell serialPortCommandShell = SerialPortCommandShell.this;
                synchronized (serialPortCommandShell) {
                    if (SerialPortCommandShell.this.serialPort.isOpen()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                return 0;
            }
        };
    }

    public InputStream getInputStream() {
        return this.serialPort.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.serialPort.getOutputStream();
    }

    public synchronized int waitFor() throws InterruptedException {
        if (this.serialPort.isOpen()) {
            this.wait();
        }
        return 0;
    }

    public boolean isCompleted() {
        return false;
    }

    public IRemoteConnection getRemoteConnection() {
        return this.remoteConnection;
    }

    public <T extends IRemoteProcess.Service> T getService(Class<T> service) {
        return null;
    }

    public <T extends IRemoteProcess.Service> boolean hasService(Class<T> service) {
        return false;
    }

    public IRemoteProcessBuilder getProcessBuilder() {
        return null;
    }
}

