/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.figure;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Optional;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.TransparentBorder;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.preferences.SiriusDiagramUiPreferencesKeys;
import org.eclipse.sirius.ext.draw2d.figure.IFixedFigure;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.RGB;

public class SynchronizeStatusFigure
extends Ellipse
implements IFixedFigure {
    public static final RGB BORDER_COLOR_SYNC_DIAG = new RGB(247, 226, 107);
    public static final RGB BORDER_COLOR_UNSYNC_DIAG = new RGB(247, 89, 18);
    private static final int DEFAULT_WIDTH = 25;
    private static final int DEFAULT_HEIGHT = 25;
    private static final ImageDescriptor SYNC_DIAG_IMAGE_DESCRIPTOR = SiriusEditPlugin.Implementation.getBundledImageDescriptor((String)"icons/full/decorator/syncDiagram.png");
    private static final ImageDescriptor UNSYNC_DIAG_IMAGE_DESCRIPTOR = SiriusEditPlugin.Implementation.getBundledImageDescriptor((String)"icons/full/decorator/unsyncDiagram.png");
    private int transparency = 20;
    private PropertyChangeListener propListener;
    private ZoomListener zoomListener;
    private Viewport viewport;
    private ZoomManager zoomManager;
    private DiagramRootEditPart rootEditPart;
    private Label label;
    private ScheduledThreadPoolExecutor executor;

    public SynchronizeStatusFigure(DiagramRootEditPart rootEditPart) {
        this.rootEditPart = rootEditPart;
        this.viewport = (Viewport)rootEditPart.getFigure();
        this.zoomManager = (ZoomManager)rootEditPart.getViewer().getProperty(ZoomManager.class.toString());
        this.setSize(25, 25);
        this.setLayoutManager((LayoutManager)new XYLayout());
        this.label = new Label(null);
        this.label.setSize(25, 25);
        this.add((IFigure)this.label);
        this.propListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SynchronizeStatusFigure.this.updateLocation();
            }
        };
        this.zoomListener = new ZoomListener(){

            public void zoomChanged(double newZoom) {
                SynchronizeStatusFigure.this.updateLocation();
            }
        };
        this.setConstraint((IFigure)this.label, new Rectangle(0, 0, 25, 25));
        this.updateLocation(true);
        this.refresh();
    }

    private void refresh() {
        Optional<DDiagram> diagram = Optional.of(this.rootEditPart).map(rootEP -> rootEP.getChildren().get(0)).map(diagEditPart -> (DDiagram)((IDDiagramEditPart)diagEditPart).resolveDDiagram().get());
        if (diagram.isPresent()) {
            boolean isSynchronized = diagram.get().isSynchronized();
            if (isSynchronized) {
                this.setForegroundColor(DiagramColorRegistry.getInstance().getColor(BORDER_COLOR_SYNC_DIAG));
                this.setLineStyle(1);
                this.setLineWidth(3);
                this.label.setIcon(DiagramUIPlugin.getPlugin().getImage(SYNC_DIAG_IMAGE_DESCRIPTOR));
                this.label.setToolTip((IFigure)new Label(Messages.SynchronizeStatusFigure_diagSynchronized));
            } else {
                this.setForegroundColor(DiagramColorRegistry.getInstance().getColor(BORDER_COLOR_UNSYNC_DIAG));
                this.setLineStyle(2);
                this.setLineWidth(2);
                this.label.setIcon(DiagramUIPlugin.getPlugin().getImage(UNSYNC_DIAG_IMAGE_DESCRIPTOR));
                this.label.setToolTip((IFigure)new Label(Messages.SynchronizeStatusFigure_diagUnsynchronized));
            }
        }
    }

    public void updateLocation() {
        this.updateLocation(false);
    }

    private void updateLocation(boolean force) {
        this.setVisible(false);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Dimension viewDimension = SynchronizeStatusFigure.this.viewport.getSize().getCopy();
                if (viewDimension.width() != 0 && viewDimension.height() != 0) {
                    Point viewLocation = SynchronizeStatusFigure.this.viewport.getViewLocation().getCopy();
                    viewLocation.translate(viewDimension.preciseWidth(), viewDimension.preciseHeight());
                    viewLocation.performScale(1.0 / SynchronizeStatusFigure.this.rootEditPart.getZoomManager().getZoom());
                    viewLocation.translate(SynchronizeStatusFigure.this.getSize().negate());
                    SynchronizeStatusFigure.this.setLocation(new Point(viewLocation.x, viewLocation.y));
                }
                SynchronizeStatusFigure.this.setVisible(true);
            }
        };
        if (force) {
            runnable.run();
        } else if (this.executor != null) {
            this.executor.remove((Runnable)this.executor.getQueue().peek());
            this.executor.schedule(runnable, 100L, TimeUnit.MILLISECONDS);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.executor = new ScheduledThreadPoolExecutor(1);
        this.viewport.addPropertyChangeListener("viewLocation", this.propListener);
        this.zoomManager.addZoomListener(this.zoomListener);
    }

    public void removeNotify() {
        super.removeNotify();
        this.viewport.removePropertyChangeListener("viewLocation", this.propListener);
        this.zoomManager.removeZoomListener(this.zoomListener);
        this.executor.shutdown();
        this.executor = null;
    }

    public static void updateNotification(DiagramRootEditPart rootEditPart) {
        boolean showSynchronizeStatusDecorator = DiagramUIPlugin.getPlugin().getPreferenceStore().getBoolean(SiriusDiagramUiPreferencesKeys.PREF_SHOW_SYNCHRONIZE_STATUS_DECORATOR.name());
        LayeredPane pane = (LayeredPane)rootEditPart.getLayer((Object)"Printable Layers");
        Optional<SynchronizeStatusFigure> synchronizeStatusFigure = SynchronizeStatusFigure.getDiagramSynchronizeStatusFigure(rootEditPart);
        if (synchronizeStatusFigure.isPresent()) {
            if (showSynchronizeStatusDecorator) {
                synchronizeStatusFigure.get().refresh();
            } else {
                pane.remove((IFigure)synchronizeStatusFigure.get());
            }
        } else if (showSynchronizeStatusDecorator) {
            SynchronizeStatusFigure notificationFigure = new SynchronizeStatusFigure(rootEditPart);
            pane.add((IFigure)notificationFigure);
        }
    }

    public static Optional<SynchronizeStatusFigure> getDiagramSynchronizeStatusFigure(DiagramRootEditPart rootEditPart) {
        LayeredPane pane = (LayeredPane)rootEditPart.getLayer((Object)"Printable Layers");
        return pane.getChildren().stream().filter(SynchronizeStatusFigure.class::isInstance).map(SynchronizeStatusFigure.class::cast).findFirst();
    }

    public void paintFigure(Graphics g) {
        this.applyTransparency(g);
        super.paintFigure(g);
        g.setAlpha(255);
    }

    public Rectangle getHandleBounds() {
        Insets insets = new Insets(0, 0, 0, 0);
        if (this.getBorder() instanceof TransparentBorder) {
            insets = ((TransparentBorder)this.getBorder()).getTransparentInsets((IFigure)this);
        }
        return new Rectangle(this.getBounds().x + insets.left, this.getBounds().y + insets.top, this.getBounds().width - (insets.right + insets.left), this.getBounds().height - (insets.bottom + insets.top));
    }

    public int getTransparency() {
        return this.transparency;
    }

    public void setTransparency(int transparency) {
        if (transparency != this.transparency && transparency >= 0 && transparency <= 100) {
            this.transparency = transparency;
            this.repaint();
        }
    }

    protected void applyTransparency(Graphics g) {
        g.setAlpha(255 - this.transparency * 255 / 100);
    }
}

