/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Base64;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tips.core.Messages;
import org.eclipse.tips.core.internal.ImageUtil;

public class TipImage {
    private static final double THREE_TO_TWO = 1.5;
    public static final int UNDEFINED = -1;
    private String fExtension = null;
    private int fMaxWidth = -1;
    private int fMaxHeight = -1;
    private final URL fURL;
    private double fAspectRatio = 1.5;
    private final String fBase64Image;

    public TipImage(URL url) throws IOException {
        byte[] bytes;
        Assert.isNotNull((Object)url);
        this.fURL = url;
        Throwable throwable = null;
        Object var4_4 = null;
        try (InputStream in = url.openStream();){
            bytes = in.readAllBytes();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.fBase64Image = "data:image/" + this.getExtension() + ";base64," + Base64.getEncoder().encodeToString(bytes);
    }

    public boolean isURLSet() {
        return this.fURL != null;
    }

    public TipImage(String base64Image) {
        Assert.isNotNull((Object)base64Image);
        this.fURL = null;
        if (!base64Image.matches("^data:image\\/.*?;base64,.*$")) {
            int length = base64Image.length();
            throw new RuntimeException(Messages.TipImage_5 + base64Image.substring(0, length < 50 ? length : 50));
        }
        this.fBase64Image = base64Image;
        int from = base64Image.indexOf(47) + 1;
        int to = base64Image.indexOf(59);
        this.setExtension(base64Image.substring(from, to).trim());
        this.setExtension(base64Image.substring(from, to).trim());
    }

    public TipImage setMaxHeight(int maxHeight) {
        this.fMaxHeight = maxHeight;
        return this;
    }

    public TipImage setMaxWidth(int maxWidth) {
        this.fMaxWidth = maxWidth;
        return this;
    }

    public TipImage setAspectRatio(int width, int height, boolean setAsMax) {
        Assert.isTrue((width > 0 ? 1 : 0) != 0);
        Assert.isTrue((height > 0 ? 1 : 0) != 0);
        this.fAspectRatio = (double)width / (double)height;
        if (setAsMax) {
            this.setMaxHeight(height);
            this.setMaxWidth(width);
        }
        return this;
    }

    public TipImage setAspectRatio(double aspectRatio) {
        this.fAspectRatio = aspectRatio;
        return this;
    }

    public TipImage setExtension(String extension) {
        this.fExtension = extension;
        return this;
    }

    public String getBase64Image() {
        return this.fBase64Image;
    }

    public String getIMGAttributes(int widthHint, int heightHint) {
        int myWidthHint = this.fMaxWidth == -1 ? widthHint : Math.min(widthHint, this.fMaxWidth);
        int myHeightHint = this.fMaxHeight == -1 ? heightHint : Math.min(heightHint, this.fMaxHeight);
        int width = ImageUtil.getWidth(this.fAspectRatio, myWidthHint, myHeightHint);
        int height = ImageUtil.getHeight(this.fAspectRatio, myWidthHint, myHeightHint);
        Object result = "";
        result = this.fMaxWidth == -1 ? (String)result + " width=\"" + width + "\"" : (String)result + " width=\"" + Math.min(this.fMaxWidth, width) + "\"";
        result = this.fMaxHeight == -1 ? (String)result + " height=\"" + height + "\"" : (String)result + " height=\"" + Math.min(this.fMaxHeight, height) + "\"";
        return result;
    }

    private String getExtension() {
        if (this.fExtension != null) {
            return this.fExtension;
        }
        String[] split = this.fURL.getPath().split("\\.");
        this.fExtension = split.length > 1 ? split[split.length - 1] : "png";
        return this.fExtension;
    }
}

