/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IGroupingSegmentAspect;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.internal.analysis.timing.core.Activator;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.Messages;
import org.eclipse.tracecompass.internal.tmf.core.model.TmfXyResponseFactory;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;
import org.eclipse.tracecompass.segmentstore.core.segment.interfaces.INamedSegment;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.SeriesModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ISeriesModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class SegmentStoreScatterDataProvider
extends AbstractTmfTraceDataProvider
implements ITmfTreeXYDataProvider<TmfTreeDataModel> {
    public static final String ID = "org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.scatter.dataprovider";
    private static final String DEFAULT_CATEGORY = "default";
    private static final String GROUP_PREFIX = "group";
    private static final AtomicLong ENTRY_ID = new AtomicLong();
    private final ISegmentStoreProvider fProvider;
    private final String fId;
    private final BiMap<Long, String> fIdToType = HashBiMap.create();
    private final long fTraceId = ENTRY_ID.getAndIncrement();
    private Iterable<IGroupingSegmentAspect> fGroupingAspects;

    public static @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> create(ITmfTrace trace, String secondaryId) {
        Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, ISegmentStoreProvider.class);
        Iterable filteredModules = Iterables.filter((Iterable)modules, m -> ((IAnalysisModule)m).getId().equals(secondaryId));
        Iterator iterator = filteredModules.iterator();
        if (iterator.hasNext()) {
            ISegmentStoreProvider module = (ISegmentStoreProvider)iterator.next();
            if (iterator.hasNext()) {
                return null;
            }
            ((IAnalysisModule)module).schedule();
            return new SegmentStoreScatterDataProvider(trace, module, secondaryId);
        }
        return null;
    }

    private SegmentStoreScatterDataProvider(ITmfTrace trace, ISegmentStoreProvider provider, String secondaryId) {
        super(trace);
        this.fProvider = provider;
        this.fGroupingAspects = Iterables.filter(provider.getSegmentAspects(), IGroupingSegmentAspect.class);
        this.fId = "org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.scatter.dataprovider:" + secondaryId;
    }

    public TmfModelResponse<TmfTreeModel<TmfTreeDataModel>> fetchTree(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        ISegmentStore<ISegment> segStore;
        ISegmentStoreProvider provider = this.fProvider;
        if (provider instanceof IAnalysisModule) {
            IAnalysisModule module = (IAnalysisModule)provider;
            IProgressMonitor mon = monitor != null ? monitor : new NullProgressMonitor();
            module.waitForCompletion(mon);
            if (mon.isCanceled()) {
                return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
            }
        }
        if ((segStore = provider.getSegmentStore()) == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.ANALYSIS_INITIALIZATION_FAILED);
        }
        TimeQueryFilter filter = FetchParametersUtils.createTimeQuery(fetchParameters);
        if (filter == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        long start = filter.getStart();
        long end = filter.getEnd();
        Iterable intersectingElements = Iterables.filter((Iterable)segStore.getIntersectingElements(start, end), s -> s.getStart() >= start);
        HashMap<String, INamedSegment> segmentTypes = new HashMap<String, INamedSegment>();
        IAnalysisModule module = provider instanceof IAnalysisModule ? (IAnalysisModule)provider : null;
        boolean complete = module == null || module.isQueryable(filter.getEnd());
        for (INamedSegment segment : Iterables.filter((Iterable)intersectingElements, INamedSegment.class)) {
            if (monitor != null && monitor.isCanceled()) {
                return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
            }
            segmentTypes.put(segment.getName(), segment);
        }
        ImmutableList.Builder nodes = new ImmutableList.Builder();
        nodes.add((Object)new TmfTreeDataModel(this.fTraceId, -1L, Collections.singletonList(String.valueOf(this.getTrace().getName()))));
        HashMap names = new HashMap();
        for (Map.Entry series : segmentTypes.entrySet()) {
            long parentId = this.fTraceId;
            for (IGroupingSegmentAspect aspect : this.fGroupingAspects) {
                names.putIfAbsent(aspect, new HashMap());
                Map map = (Map)names.get(aspect);
                if (map == null) break;
                String name = String.valueOf(aspect.resolve((ISegment)series.getValue()));
                String key = GROUP_PREFIX + name;
                Long uniqueId = (Long)map.get(key);
                if (uniqueId == null) {
                    uniqueId = this.getUniqueId(key);
                    map.put(key, uniqueId);
                    nodes.add((Object)new TmfTreeDataModel(uniqueId.longValue(), parentId, name));
                }
                parentId = uniqueId;
            }
            long seriesId = this.getUniqueId((String)series.getKey());
            nodes.add((Object)new TmfTreeDataModel(seriesId, parentId, (String)series.getKey()));
        }
        return new TmfModelResponse((Object)new TmfTreeModel(Collections.emptyList(), (List)nodes.build()), complete ? ITmfResponse.Status.COMPLETED : ITmfResponse.Status.RUNNING, complete ? CommonStatusMessage.COMPLETED : CommonStatusMessage.RUNNING);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public TmfModelResponse<ITmfXyModel> fetchXY(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        ISegmentStoreProvider provider = this.fProvider;
        if (provider instanceof IAnalysisModule && !((IAnalysisModule)provider).waitForCompletion()) {
            return TmfXyResponseFactory.createFailedResponse((String)CommonStatusMessage.ANALYSIS_INITIALIZATION_FAILED);
        }
        ISegmentStore<ISegment> segStore = provider.getSegmentStore();
        if (segStore == null) {
            return TmfXyResponseFactory.createFailedResponse((String)Objects.requireNonNull(Messages.SegmentStoreDataProvider_SegmentNotAvailable));
        }
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(fetchParameters);
        if (filter == null && (filter = FetchParametersUtils.createTimeQuery(fetchParameters)) == null) {
            return TmfXyResponseFactory.createFailedResponse((String)CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        HashMap<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> predicates = new HashMap<Integer, Predicate<Multimap<String, Object>>>();
        @NonNull @NonNull Multimap regexesMap = DataProviderParameterUtils.extractRegexFilter(fetchParameters);
        if (regexesMap != null) {
            predicates.putAll(this.computeRegexPredicate(regexesMap));
        }
        long start = filter.getStart();
        long end = filter.getEnd();
        String prefix = String.valueOf(this.getTrace().getName()) + '/';
        Map<String, Series> types = this.initTypes(prefix, (TimeQueryFilter)filter);
        if (types.isEmpty()) {
            return TmfXyResponseFactory.create((String)Objects.requireNonNull(Messages.SegmentStoreScatterGraphViewer_title), Collections.emptyList(), (boolean)true);
        }
        long pixelSize = Math.max(1L, (end - start) / (long)filter.getTimesRequested().length);
        Iterable intersectingElements = Iterables.filter((Iterable)segStore.getIntersectingElements(start, end, SegmentComparators.INTERVAL_START_COMPARATOR), segment -> {
            CheckSegmentType cs = new CheckSegmentType(prefix, types.keySet());
            return cs.test((ISegment)segment);
        });
        Iterable<ISegment> displayData = SegmentStoreScatterDataProvider.compactList(start, intersectingElements, pixelSize);
        IAnalysisModule module = this.fProvider instanceof IAnalysisModule ? (IAnalysisModule)this.fProvider : null;
        boolean complete = module == null || module.isQueryable(filter.getEnd());
        for (ISegment segment2 : displayData) {
            if (monitor != null && monitor.isCanceled()) {
                return TmfXyResponseFactory.createCancelledResponse((String)CommonStatusMessage.TASK_CANCELLED);
            }
            String name = String.valueOf(prefix) + SegmentStoreScatterDataProvider.getSegmentName(segment2);
            Series thisSeries = types.get(name);
            if (thisSeries == null) {
                Activator.getInstance().logError("Series " + thisSeries + " should exist");
                continue;
            }
            this.addPoint(thisSeries, segment2, predicates);
        }
        ArrayList<SeriesModel> seriesModelMap = new ArrayList<SeriesModel>();
        for (Map.Entry<String, Series> entry : types.entrySet()) {
            SeriesModel seriesModel = entry.getValue().build();
            seriesModelMap.add(seriesModel);
        }
        return TmfXyResponseFactory.create((String)Objects.requireNonNull(Messages.SegmentStoreScatterGraphViewer_title), seriesModelMap, (boolean)complete);
    }

    private static String getSegmentName(ISegment segment) {
        return segment instanceof INamedSegment ? ((INamedSegment)segment).getName() : DEFAULT_CATEGORY;
    }

    private void addPoint(Series series, ISegment segment, Map<Integer, Predicate<Multimap<String, Object>>> predicates) {
        if (!predicates.isEmpty()) {
            Multimap<@NonNull String, @NonNull Object> input = ISegmentStoreProvider.getFilterInput(this.fProvider, segment);
            int mask = 0;
            for (Map.Entry<Integer, Predicate<Multimap<String, Object>>> mapEntry : predicates.entrySet()) {
                Predicate<Multimap<String, Object>> value = Objects.requireNonNull(mapEntry.getValue());
                boolean status = value.test(input);
                Integer property = Objects.requireNonNull(mapEntry.getKey());
                if (status && property != 1) {
                    mask |= property.intValue();
                    continue;
                }
                if (!status && property == 1) {
                    mask |= 1;
                    continue;
                }
                if (status || property != 4) continue;
                mask |= 4;
            }
            series.addPoint(segment.getStart(), segment.getLength(), mask);
        } else {
            series.addPoint(segment.getStart(), segment.getLength(), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Series> initTypes(String prefix, TimeQueryFilter filter) {
        if (!(filter instanceof SelectionTimeQueryFilter)) {
            return Collections.emptyMap();
        }
        HashMap<String, Series> segmentTypes = new HashMap<String, Series>();
        BiMap<Long, String> biMap = this.fIdToType;
        synchronized (biMap) {
            for (Long id : ((SelectionTimeQueryFilter)filter).getSelectedItems()) {
                String string = (String)this.fIdToType.get((Object)id);
                if (string == null) continue;
                String name = String.valueOf(prefix) + string;
                segmentTypes.put(name, new Series(id));
            }
        }
        return segmentTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getUniqueId(String name) {
        BiMap<Long, String> biMap = this.fIdToType;
        synchronized (biMap) {
            return (Long)this.fIdToType.inverse().computeIfAbsent((Object)name, n -> ENTRY_ID.getAndIncrement());
        }
    }

    private static Iterable<ISegment> compactList(long startTime, Iterable<@NonNull ISegment> iterableToCompact, long pixelSize) {
        return () -> new SegmentStoreIterator(startTime, iterableToCompact, pixelSize);
    }

    public String getId() {
        return this.fId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        BiMap<Long, String> biMap = this.fIdToType;
        synchronized (biMap) {
            this.fIdToType.clear();
        }
    }

    private static class CheckSegmentType
    implements Predicate<ISegment> {
        private final Set<String> fSelectedTypes;
        private final String fPrefix;

        public CheckSegmentType(String prefix, Set<String> selectedTypes) {
            this.fSelectedTypes = selectedTypes;
            this.fPrefix = prefix;
        }

        @Override
        public boolean test(ISegment segment) {
            if (!(segment instanceof INamedSegment)) {
                return this.fSelectedTypes.contains(String.valueOf(this.fPrefix) + SegmentStoreScatterDataProvider.DEFAULT_CATEGORY);
            }
            return this.fSelectedTypes.contains(String.valueOf(this.fPrefix) + ((INamedSegment)segment).getName());
        }
    }

    private static class SegmentStoreIterator
    implements Iterator<ISegment> {
        private final Map<String, ISegment> fLasts = new HashMap<String, ISegment>();
        private @Nullable ISegment fNext = null;
        private final Iterator<@NonNull ISegment> fIterator;
        private final long fStartTime;
        private final long fPixelSize;

        public SegmentStoreIterator(long startTime, Iterable<@NonNull ISegment> iterableToCompact, long pixelSize) {
            this.fStartTime = startTime;
            this.fIterator = Objects.requireNonNull(iterableToCompact.iterator());
            this.fPixelSize = Math.max(1L, pixelSize);
        }

        @Override
        public @NonNull ISegment next() {
            if (this.hasNext()) {
                ISegment segment = Objects.requireNonNull(this.fNext);
                this.fLasts.put(SegmentStoreScatterDataProvider.getSegmentName(segment), segment);
                this.fNext = null;
                return segment;
            }
            throw new NoSuchElementException();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean hasNext() {
            if (this.fLasts.isEmpty() && this.fNext == null) {
                if (!this.fIterator.hasNext()) {
                    return false;
                }
                ISegment segment = this.fIterator.next();
                if (segment.getStart() >= this.fStartTime) {
                    this.fNext = segment;
                }
            }
            while (this.fNext == null && this.fIterator.hasNext()) {
                ISegment tmp = this.fIterator.next();
                ISegment last = this.fLasts.get(SegmentStoreScatterDataProvider.getSegmentName(tmp));
                if (tmp.getStart() < this.fStartTime || this.overlaps(last, tmp)) continue;
                this.fNext = tmp;
            }
            return this.fNext != null;
        }

        private boolean overlaps(@Nullable ISegment last, ISegment next) {
            if (last == null) {
                return false;
            }
            long timePerPix = this.fPixelSize;
            long start = last.getStart();
            long pixelStart = this.fStartTime;
            long pixelDuration = start - pixelStart;
            long startPixBoundL = pixelDuration / timePerPix * timePerPix + pixelStart;
            long startPixBoundR = startPixBoundL + timePerPix;
            long currentStart = next.getStart();
            if (currentStart >= startPixBoundL && currentStart <= startPixBoundR) {
                long length = last.getLength();
                long lengthNext = next.getLength();
                long lengthLow = length / timePerPix * timePerPix;
                long lengthHigh = lengthLow + timePerPix;
                return lengthNext >= lengthLow && lengthNext <= lengthHigh;
            }
            return false;
        }
    }

    private static class Series {
        private final long fId;
        private final List<Long> fXValues = new ArrayList<Long>();
        private final List<Double> fYValues = new ArrayList<Double>();
        private final List<Integer> fProperties = new ArrayList<Integer>();

        public Series(long id) {
            this.fId = id;
        }

        public void addPoint(long x, double y, int properties) {
            this.fXValues.add(x);
            this.fYValues.add(y);
            this.fProperties.add(properties);
        }

        public SeriesModel build() {
            SeriesModel.SeriesModelBuilder builder = new SeriesModel.SeriesModelBuilder(this.getId(), String.valueOf(this.getId()), Longs.toArray(this.fXValues), Doubles.toArray(this.fYValues));
            builder.seriesDisplayType(ISeriesModel.DisplayType.SCATTER);
            builder.setProperties(Ints.toArray(this.fProperties)).build();
            return builder.setProperties(Ints.toArray(this.fProperties)).build();
        }

        private long getId() {
            return this.fId;
        }
    }
}

