/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.api.adapter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.Agenda;
import org.eclipse.viatra.transformation.evm.api.ExecutionSchema;
import org.eclipse.viatra.transformation.evm.api.Executor;
import org.eclipse.viatra.transformation.evm.api.RuleEngine;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.ScheduledExecution;
import org.eclipse.viatra.transformation.evm.api.Scheduler;
import org.eclipse.viatra.transformation.evm.api.adapter.AdaptableActivationNotificationListener;
import org.eclipse.viatra.transformation.evm.api.adapter.AdaptableConflictResolver;
import org.eclipse.viatra.transformation.evm.api.adapter.AdaptableEVMFactory;
import org.eclipse.viatra.transformation.evm.api.adapter.AdaptableExecutor;
import org.eclipse.viatra.transformation.evm.api.adapter.AdaptableRuleBase;
import org.eclipse.viatra.transformation.evm.api.adapter.IAdapterConfiguration;
import org.eclipse.viatra.transformation.evm.api.adapter.IEVMAdapter;
import org.eclipse.viatra.transformation.evm.api.adapter.IEVMListener;
import org.eclipse.viatra.transformation.evm.api.event.ActivationState;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.api.event.EventType;
import org.eclipse.viatra.transformation.evm.api.resolver.ChangeableConflictSet;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictResolver;
import org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryEventRealm;
import org.eclipse.viatra.transformation.evm.specific.resolver.ArbitraryOrderConflictResolver;

public class AdaptableEVM {
    private List<IEVMAdapter> adapters = new ArrayList<IEVMAdapter>();
    private List<IEVMListener> listeners = new ArrayList<IEVMListener>();
    private String identifier;

    protected AdaptableEVM(String id) {
        this.identifier = id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<IEVMAdapter> getAdapters() {
        return this.adapters;
    }

    public List<IEVMListener> getListeners() {
        return this.listeners;
    }

    public void addAdapter(IEVMAdapter adapter) {
        this.adapters.add(adapter);
    }

    public void addAdapters(List<IEVMAdapter> adapters) {
        this.adapters.addAll(adapters);
    }

    public void addListener(IEVMListener adapter) {
        this.listeners.add(adapter);
    }

    public void addListeners(List<IEVMListener> adapters) {
        this.listeners.addAll(adapters);
    }

    public void addConfiguration(IAdapterConfiguration adapterConfiguration) {
        this.adapters.addAll(adapterConfiguration.getAdapters());
        this.listeners.addAll(adapterConfiguration.getListeners());
    }

    public void initialize(ViatraQueryEngine engine) {
        for (IEVMListener listener : this.listeners) {
            listener.initializeListener(engine);
        }
    }

    public void beforeFiring(Activation<?> activation) {
        for (IEVMListener listener : this.listeners) {
            listener.beforeFiring(activation);
        }
    }

    public void afterFiring(Activation<?> activation) {
        for (IEVMListener listener : this.listeners) {
            listener.afterFiring(activation);
        }
    }

    public void startTransaction(String transactionID) {
        for (IEVMListener listener : this.listeners) {
            listener.startTransaction(transactionID);
        }
    }

    public void endTransaction(String transactionID) {
        for (IEVMListener listener : this.listeners) {
            listener.endTransaction(transactionID);
        }
    }

    public void addedRule(RuleSpecification<?> specification, EventFilter<?> filter) {
        for (IEVMListener listener : this.listeners) {
            listener.addedRule(specification, filter);
        }
    }

    public void removedRule(RuleSpecification<?> specification, EventFilter<?> filter) {
        for (IEVMListener listener : this.listeners) {
            listener.removedRule(specification, filter);
        }
    }

    public void dispose() {
        for (IEVMListener listener : this.listeners) {
            listener.disposeListener();
        }
        this.listeners.clear();
        this.adapters.clear();
        AdaptableEVMFactory.getInstance().disposeAdaptableEVM(this);
    }

    public void activationChanged(Activation<?> activation, ActivationState oldState, EventType event) {
        for (IEVMListener listener : this.listeners) {
            listener.activationChanged(activation, oldState, event);
        }
    }

    public void activationCreated(Activation<?> activation, ActivationState inactiveState) {
        for (IEVMListener listener : this.listeners) {
            listener.activationCreated(activation, inactiveState);
        }
    }

    public void activationRemoved(Activation<?> activation, ActivationState oldState) {
        for (IEVMListener listener : this.listeners) {
            listener.activationRemoved(activation, oldState);
        }
    }

    public Iterator<Activation<?>> getExecutableActivations(Iterator<Activation<?>> iterator) {
        Iterator<Activation<?>> returnIterator = iterator;
        for (IEVMAdapter ievmAdapter : this.adapters) {
            returnIterator = ievmAdapter.getExecutableActivations(iterator);
        }
        return returnIterator;
    }

    public ChangeableConflictSet getConflictSet(ChangeableConflictSet set) {
        ChangeableConflictSet returnConflictSet = set;
        for (IEVMAdapter ievmAdapter : this.adapters) {
            returnConflictSet = ievmAdapter.getConflictSet(set);
        }
        return returnConflictSet;
    }

    public ExecutionSchema createAdaptableExecutionSchema(ViatraQueryEngine queryEngine, Scheduler.ISchedulerFactory schedulerFactory, ConflictResolver conflictResolver) {
        AdaptableExecutor executor = new AdaptableExecutor(new Executor(), this);
        AdaptableConflictResolver adaptableConflictResolver = new AdaptableConflictResolver(conflictResolver, this);
        Agenda debugAgenda = new Agenda(adaptableConflictResolver);
        debugAgenda.setActivationListener(new AdaptableActivationNotificationListener(debugAgenda.getActivationListener(), this));
        AdaptableRuleBase debugRulebase = new AdaptableRuleBase(ViatraQueryEventRealm.create(queryEngine), debugAgenda, this);
        ScheduledExecution execution = new ScheduledExecution(debugRulebase, executor);
        Scheduler scheduler = schedulerFactory.prepareScheduler(execution);
        ExecutionSchema schema = ExecutionSchema.create(scheduler);
        schema.setConflictResolver(adaptableConflictResolver);
        return schema;
    }

    public RuleEngine createAdaptableRuleEngine(ViatraQueryEngine queryEngine) {
        AdaptableConflictResolver conflictResolver = new AdaptableConflictResolver(new ArbitraryOrderConflictResolver(), this);
        Agenda debugAgenda = new Agenda(conflictResolver);
        debugAgenda.setActivationListener(new AdaptableActivationNotificationListener(debugAgenda.getActivationListener(), this));
        AdaptableRuleBase debugRulebase = new AdaptableRuleBase(ViatraQueryEventRealm.create(queryEngine), debugAgenda, this);
        return RuleEngine.create(debugRulebase);
    }
}

