/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.editor.palette.model.entry;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.IPaletteSite;
import org.eclipse.wb.core.editor.palette.model.entry.ToolEntryInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.requests.ICreationFactory;
import org.eclipse.wb.gef.core.tools.CreationTool;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.palette.TypeParametersDialog;
import org.eclipse.wb.internal.core.editor.palette.model.entry.AttributesProvider;
import org.eclipse.wb.internal.core.editor.palette.model.entry.AttributesProviders;
import org.eclipse.wb.internal.core.editor.palette.model.entry.LibraryInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ComponentPresentation;
import org.eclipse.wb.internal.core.model.description.CreationDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentPresentationHelper;
import org.eclipse.wb.internal.core.model.util.ScriptUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;

public final class ComponentEntryInfo
extends ToolEntryInfo {
    public static final String KEY_SIMULATE_PRESENTATION = "ComponentEntryInfo.simulatePresentation";
    public static final ImageDescriptor DEFAULT_ICON = DesignerPlugin.getImageDescriptor((String)"palette/Object.png");
    private String m_className;
    private String m_creationId;
    private String m_enabledScript;
    private ImageDescriptor m_icon;
    private final List<LibraryInfo> m_libraries = Lists.newArrayList();
    private Class<?> m_class;
    private ComponentPresentation m_presentation;
    private ComponentDescription m_description;
    private CreationDescription m_creation;
    private static Map<ClassLoader, Set<String>> m_contextHasClasses = new WeakHashMap<ClassLoader, Set<String>>();
    private static Map<ClassLoader, Set<String>> m_contextNoClasses = new WeakHashMap<ClassLoader, Set<String>>();

    public ComponentEntryInfo() {
    }

    public ComponentEntryInfo(CategoryInfo categoryInfo, IConfigurationElement element) throws Exception {
        this(categoryInfo, AttributesProviders.get(element));
        this.m_icon = ExternalFactoriesHelper.getImageDescriptor((IConfigurationElement)element, (String)"icon");
        this.addLibraries(element);
    }

    public ComponentEntryInfo(CategoryInfo categoryInfo, AttributesProvider attributes) {
        this.m_className = attributes.getAttribute("class");
        Assert.isNotNull((Object)this.m_className, (String)"Component must have 'class' attribute.");
        this.m_creationId = attributes.getAttribute("creationId");
        String id = attributes.getAttribute("id");
        if (id == null) {
            id = String.valueOf(categoryInfo.getId()) + " " + this.m_className;
            if (this.m_creationId != null) {
                id = String.valueOf(id) + " " + this.m_creationId;
            }
        }
        this.setId(id);
        this.setName(attributes.getAttribute("name"));
        this.setDescription(attributes.getAttribute("description"));
        this.setVisible(ComponentEntryInfo.getBoolean(attributes, "visible", true));
        this.m_enabledScript = attributes.getAttribute("enabled");
    }

    public String toString() {
        return "Component(class='" + this.m_className + "')";
    }

    public String getCreationId() {
        return this.m_creationId;
    }

    public void setCreationId(String creationId) {
        this.m_creationId = creationId;
    }

    public String getClassName() {
        return this.m_className;
    }

    public void setComponentClassName(String componentClassName) {
        this.m_className = componentClassName;
    }

    private void addLibraries(IConfigurationElement componentElement) {
        IConfigurationElement[] iConfigurationElementArray = componentElement.getChildren("library");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement libraryElement = iConfigurationElementArray[n2];
            this.m_libraries.add(new LibraryInfo(libraryElement));
            ++n2;
        }
    }

    private void ensureLibraries() throws Exception {
        for (LibraryInfo library : this.m_libraries) {
            library.ensure(this.m_javaProject);
        }
    }

    @Override
    protected String getNameDefault() {
        return this.m_className;
    }

    @Override
    public boolean initialize(IEditPartViewer editPartViewer, JavaInfo rootJavaInfo) {
        String description;
        super.initialize(editPartViewer, rootJavaInfo);
        if (!this.preparePresentation()) {
            return false;
        }
        if (this.m_icon == null) {
            this.m_icon = this.m_presentation.getIcon();
        }
        if (this.getNameRaw() == null) {
            this.setName(this.m_presentation.getName());
        }
        if (StringUtils.isEmpty((String)(description = this.getDescription())) || this.m_className.equals(description)) {
            this.setDescription(this.m_presentation.getDescription());
        }
        return true;
    }

    private boolean preparePresentation() {
        if (this.m_rootJavaInfo.getArbitraryValue(KEY_SIMULATE_PRESENTATION) != null) {
            this.m_presentation = new ComponentPresentation("key", "toolkitId", this.m_className, this.m_className, null);
            return true;
        }
        if (!this.hasClass()) {
            return false;
        }
        try {
            this.m_presentation = ComponentPresentationHelper.getPresentation(this.m_editor, this.m_className, this.m_creationId);
            if (this.m_presentation == null) {
                String message = MessageFormat.format("Palette: no presentation for component {0}", this.m_className);
                this.m_state.addWarning(new EditorWarning(message));
                return false;
            }
        }
        catch (Throwable e) {
            String message = MessageFormat.format("Palette: can not load component {0}", this.m_className);
            this.m_state.addWarning(new EditorWarning(message, e));
            return false;
        }
        return true;
    }

    private boolean ensureDescriptions() {
        if (this.m_creation == null) {
            try {
                this.m_class = this.m_state.getEditorLoader().loadClass(this.m_className);
                this.m_description = ComponentDescriptionHelper.getDescription(this.m_editor, this.m_class);
                this.m_creation = this.m_description.getCreation(this.m_creationId);
            }
            catch (Throwable e) {
                String message = MessageFormat.format("Palette: can not load component {0}", this.m_className);
                this.m_state.addWarning(new EditorWarning(message, e));
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isEnabled() {
        boolean enabled;
        return this.m_enabledScript == null || (enabled = ((Boolean)ExecutionUtils.runObjectIgnore((RunnableObjectEx)new RunnableObjectEx<Boolean>(){

            public Boolean runObject() throws Exception {
                ClassLoader classLoader = JavaInfoUtils.getClassLoader(ComponentEntryInfo.this.m_rootJavaInfo);
                return (Boolean)ScriptUtils.evaluate((ClassLoader)classLoader, (String)ComponentEntryInfo.this.m_enabledScript);
            }
        }, (Object)false)).booleanValue());
    }

    @Override
    public ImageDescriptor getIcon() {
        if (this.m_icon == null) {
            return DEFAULT_ICON;
        }
        return this.m_icon;
    }

    private boolean hasClass() {
        List elements = ExternalFactoriesHelper.getElements((String)"org.eclipse.wb.core.paletteComponentExists", (String)"component");
        for (IConfigurationElement element : elements) {
            String pkg = element.getAttribute("package");
            if (pkg == null || !this.m_className.startsWith(pkg)) continue;
            String witnessClassName = element.getAttribute("witness");
            if (witnessClassName != null) {
                return this.hasClass0(witnessClassName);
            }
            if (element.getAttribute("hasType") != null) {
                return ProjectUtils.hasType(this.m_javaProject, this.m_className);
            }
            if (element.getAttribute("always") == null) continue;
            return true;
        }
        return this.hasClass0(this.m_className);
    }

    private boolean hasClass0(String className) {
        ClassLoader classLoader = this.m_state.getEditorLoader();
        HashSet hasClasses = m_contextHasClasses.get(classLoader);
        if (hasClasses == null) {
            hasClasses = Sets.newHashSet();
            m_contextHasClasses.put(classLoader, hasClasses);
        }
        if (hasClasses.contains(className)) {
            return true;
        }
        HashSet noClasses = m_contextNoClasses.get(classLoader);
        if (noClasses == null) {
            noClasses = Sets.newHashSet();
            m_contextNoClasses.put(classLoader, noClasses);
        }
        if (noClasses.contains(className)) {
            return false;
        }
        try {
            classLoader.loadClass(className);
            hasClasses.add(className);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            noClasses.add(className);
            return false;
        }
    }

    @Override
    public Tool createTool() throws Exception {
        if (!this.ensureDescriptions()) {
            return null;
        }
        if (ReflectionUtils.isAbstract(this.m_class) && !this.m_creation.hasTrueTag("createAnonymous")) {
            Shell parentShell = IPaletteSite.Helper.getSite(this.m_rootJavaInfo).getShell();
            UiUtils.openError((Shell)parentShell, (String)Messages.ComponentEntryInfo_abstractTitle, (String)Messages.ComponentEntryInfo_abstractMessage);
            return null;
        }
        final Map<String, String> genericArguments = this.getTypeArguments();
        if (genericArguments == null) {
            return null;
        }
        ICreationFactory factory = new ICreationFactory(){
            private JavaInfo m_javaInfo;

            public void activate() throws Exception {
                ConstructorCreationSupport creationSupport = new ConstructorCreationSupport(ComponentEntryInfo.this.m_creationId, true);
                this.m_javaInfo = JavaInfoUtils.createJavaInfo(ComponentEntryInfo.this.m_editor, ComponentEntryInfo.this.m_description, (CreationSupport)creationSupport);
                this.m_javaInfo.putTemplateArguments(genericArguments);
                this.m_javaInfo = JavaInfoUtils.getWrapped(this.m_javaInfo);
                this.m_javaInfo.putArbitraryValue("manuallyCreatedComponent", Boolean.TRUE);
            }

            public Object getNewObject() {
                return this.m_javaInfo;
            }
        };
        this.ensureLibraries();
        return new CreationTool(factory);
    }

    private Map<String, String> getTypeArguments() throws JavaModelException {
        Map<String, CreationDescription.TypeParameterDescription> typeParameters = this.m_creation.getTypeParameters();
        if (typeParameters.isEmpty()) {
            return ImmutableMap.of();
        }
        TypeParametersDialog dialog = new TypeParametersDialog(DesignerPlugin.getShell(), this.m_javaProject, typeParameters);
        if (dialog.open() == 0) {
            return dialog.getArguments();
        }
        return null;
    }
}

